/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.math.BigDecimal;
import java.util.Optional;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import org.apache.commons.lang3.math.NumberUtils;

public class NbtHelper {
    public static Optional<class_2487> getNbtCompound(JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return Optional.empty();
        }
        if (json.isJsonObject()) {
            return Optional.of(NbtHelper.fromJsonObject(json.getAsJsonObject()));
        }
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            try {
                return Optional.of(class_2522.method_10718((String)json.getAsString()));
            }
            catch (CommandSyntaxException exception) {
                exception.printStackTrace();
            }
        }
        throw new UnsupportedOperationException("Nbt element is not an object or a string");
    }

    public static byte getJsonElementType(JsonElement element) {
        if (element == null) {
            throw new UnsupportedOperationException("Null JSON NBT element");
        }
        if (element.isJsonObject()) {
            return 10;
        }
        if (element.isJsonArray()) {
            return NbtHelper.getJsonArrayType(element.getAsJsonArray());
        }
        if (element.isJsonPrimitive()) {
            return NbtHelper.getJsonPrimitiveType(element.getAsJsonPrimitive());
        }
        throw new UnsupportedOperationException("Unknown JSON NBT element type");
    }

    public static byte getJsonArrayType(JsonArray array) {
        JsonElement first;
        byte type;
        if (array == null) {
            throw new UnsupportedOperationException("Null JSON NBT element");
        }
        if (array.size() > 0 && (type = NbtHelper.getJsonElementType(first = array.get(0))) == 8) {
            switch (first.getAsString()) {
                case "B;": {
                    return 7;
                }
                case "I;": {
                    return 11;
                }
                case "L;": {
                    return 12;
                }
            }
        }
        return 9;
    }

    public static byte getJsonPrimitiveType(JsonPrimitive primitive) {
        if (primitive == null) {
            throw new UnsupportedOperationException("Null JSON NBT element");
        }
        if (primitive.isBoolean()) {
            return 1;
        }
        if (primitive.isNumber()) {
            BigDecimal bigDecimal = primitive.getAsBigDecimal();
            try {
                bigDecimal.intValueExact();
                return 3;
            }
            catch (ArithmeticException exception) {
                return 6;
            }
        }
        if (primitive.isString()) {
            String numStr;
            String string = primitive.getAsString();
            if (string.length() > 1 && NumberUtils.isParsable((String)(numStr = string.substring(0, string.length() - 1)))) {
                switch (string.charAt(string.length() - 1)) {
                    case 'B': 
                    case 'b': {
                        return 1;
                    }
                    case 'S': 
                    case 's': {
                        return 2;
                    }
                    case 'I': 
                    case 'i': {
                        return 3;
                    }
                    case 'L': 
                    case 'l': {
                        return 4;
                    }
                    case 'F': 
                    case 'f': {
                        return 5;
                    }
                    case 'D': 
                    case 'd': {
                        return 6;
                    }
                }
            }
            return 8;
        }
        throw new UnsupportedOperationException("Unknown JSON NBT primitive type");
    }

    public static class_2520 fromJson(JsonElement element) {
        if (element == null) {
            throw new UnsupportedOperationException("Null JSON NBT element");
        }
        if (element.isJsonObject()) {
            return NbtHelper.fromJsonObject(element.getAsJsonObject());
        }
        if (element.isJsonArray()) {
            return NbtHelper.fromJsonArray(element.getAsJsonArray());
        }
        if (element.isJsonPrimitive()) {
            return NbtHelper.fromJsonPrimitive(element.getAsJsonPrimitive());
        }
        throw new UnsupportedOperationException("Unknown JSON NBT element type");
    }

    public static class_2487 fromJsonObject(JsonObject object) {
        if (object == null) {
            throw new UnsupportedOperationException("Null JSON NBT element");
        }
        class_2487 result = new class_2487();
        object.entrySet().forEach(entry -> {
            String name = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (element != null) {
                result.method_10566(name, NbtHelper.fromJson(element));
            }
        });
        return result;
    }

    public static class_2483<?> fromJsonArray(JsonArray array) {
        byte type = NbtHelper.getJsonArrayType(array);
        if (type == 9) {
            class_2499 list = new class_2499();
            for (int i = 0; i < array.size(); ++i) {
                list.method_10531(i, NbtHelper.fromJson(array.get(i)));
            }
            return list;
        }
        class_2479 nbtArray = switch (type) {
            case 7 -> new class_2479(new byte[0]);
            case 11 -> new class_2495(new int[0]);
            case 12 -> new class_2501(new long[0]);
            default -> throw new UnsupportedOperationException("Unknown JSON NBT list type");
        };
        for (int i = 1; i < array.size(); ++i) {
            nbtArray.method_10533(i - 1, NbtHelper.fromJson(array.get(i)));
        }
        return nbtArray;
    }

    public static class_2520 fromJsonPrimitive(JsonPrimitive primitive) {
        byte type = NbtHelper.getJsonPrimitiveType(primitive);
        if (primitive.isBoolean()) {
            return class_2481.method_23233((byte)((byte)(primitive.getAsBoolean() ? 1 : 0)));
        }
        if (primitive.isNumber()) {
            switch (type) {
                case 3: {
                    return class_2497.method_23247((int)primitive.getAsInt());
                }
                case 6: {
                    return class_2489.method_23241((double)primitive.getAsDouble());
                }
            }
        }
        if (primitive.isString()) {
            String string = primitive.getAsString();
            if (string.length() > 1) {
                String numStr = string.substring(0, string.length() - 1);
                switch (type) {
                    case 1: {
                        return class_2481.method_23233((byte)Byte.parseByte(numStr));
                    }
                    case 2: {
                        return class_2516.method_23254((short)Short.parseShort(numStr));
                    }
                    case 3: {
                        return class_2497.method_23247((int)Integer.parseInt(numStr));
                    }
                    case 4: {
                        return class_2503.method_23251((long)Long.parseLong(numStr));
                    }
                    case 5: {
                        return class_2494.method_23244((float)Float.parseFloat(numStr));
                    }
                    case 6: {
                        return class_2489.method_23241((double)Double.parseDouble(numStr));
                    }
                }
            }
            return class_2519.method_23256((String)string);
        }
        throw new UnsupportedOperationException("Unknown JSON NBT primitive type");
    }

    public static void mergeNbt(class_2520 original, class_2520 delta) {
        if (original.method_10711() != delta.method_10711()) {
            return;
        }
        switch (original.method_10711()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 99: {
                break;
            }
            case 10: {
                class_2487 originalCompound = (class_2487)original;
                class_2487 deltaCompound = (class_2487)delta;
                deltaCompound.method_10541().forEach(key -> {
                    class_2520 value = deltaCompound.method_10580(key);
                    if (originalCompound.method_10545(key)) {
                        NbtHelper.mergeNbt(originalCompound.method_10580(key), value);
                    } else {
                        originalCompound.method_10566(key, value);
                    }
                });
                break;
            }
        }
    }
}

