/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Nullable;

public enum NullableDyeColor implements class_3542
{
    WHITE(0, "white", class_1767.field_7952),
    ORANGE(1, "orange", class_1767.field_7946),
    MAGENTA(2, "magenta", class_1767.field_7958),
    LIGHT_BLUE(3, "light_blue", class_1767.field_7951),
    YELLOW(4, "yellow", class_1767.field_7947),
    LIME(5, "lime", class_1767.field_7961),
    PINK(6, "pink", class_1767.field_7954),
    GRAY(7, "gray", class_1767.field_7944),
    LIGHT_GRAY(8, "light_gray", class_1767.field_7967),
    CYAN(9, "cyan", class_1767.field_7955),
    PURPLE(10, "purple", class_1767.field_7945),
    BLUE(11, "blue", class_1767.field_7966),
    BROWN(12, "brown", class_1767.field_7957),
    GREEN(13, "green", class_1767.field_7942),
    RED(14, "red", class_1767.field_7964),
    BLACK(15, "black", class_1767.field_7963),
    NONE(16, "none", null);

    private static final NullableDyeColor[] VALUES;
    private final int id;
    private final String name;
    @Nullable
    private final class_1767 dyeColor;
    public static final String COLOR_NBT_KEY = "color";

    private NullableDyeColor(@Nullable int id, String name, class_1767 dyeColor) {
        this.id = id;
        this.name = name;
        this.dyeColor = dyeColor;
    }

    public static NullableDyeColor get(@Nullable class_1767 dyeColor) {
        if (dyeColor == null) {
            return NONE;
        }
        return NullableDyeColor.byId(dyeColor.method_7789());
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public class_1767 getDyeColor() {
        return this.dyeColor;
    }

    public static NullableDyeColor byId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public String toString() {
        return this.name;
    }

    public String method_15434() {
        return this.name;
    }

    public static void set(class_1799 stack, NullableDyeColor color) {
        stack.method_7948().method_10582(COLOR_NBT_KEY, color.getName().toLowerCase(Locale.ROOT));
    }

    public static NullableDyeColor get(@Nullable class_2487 nbt) {
        if (nbt == null || !nbt.method_10573(COLOR_NBT_KEY, 8)) {
            return NONE;
        }
        return NullableDyeColor.valueOf(nbt.method_10558(COLOR_NBT_KEY).toUpperCase(Locale.ROOT));
    }

    public static void addTooltip(class_1799 stack, List<class_2561> tooltip) {
        NullableDyeColor color = NullableDyeColor.get(stack.method_7969());
        if (color != NONE) {
            tooltip.add((class_2561)class_2561.method_43471((String)("spectrum.ink.color." + color.getName())));
        }
    }

    static {
        VALUES = (NullableDyeColor[])Arrays.stream(NullableDyeColor.values()).sorted(Comparator.comparingInt(NullableDyeColor::getId)).toArray(NullableDyeColor[]::new);
    }
}

