/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import net.minecraft.class_243;
import net.minecraft.class_3532;

public class Orientation {
    private final double longitude;
    private final double latitude;

    private Orientation(double longitude, double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public static Orientation create(double longitude, double latitude) {
        return new Orientation(longitude, latitude);
    }

    public static Orientation fromVector(class_243 vector) {
        return Orientation.getVectorOrientation(vector);
    }

    public class_243 toVector(double r) {
        return new class_243(r * Math.sin(this.latitude) * Math.cos(this.longitude), r * Math.cos(this.latitude), r * Math.sin(this.latitude) * Math.sin(this.longitude));
    }

    public Orientation add(Orientation other) {
        return new Orientation(this.longitude + other.longitude, this.latitude + other.latitude);
    }

    public Orientation add(double longitude, double latitude) {
        return new Orientation(this.longitude + longitude, this.latitude + latitude);
    }

    public Orientation subtract(Orientation other) {
        return new Orientation(this.longitude - other.longitude, this.latitude - other.latitude);
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public static Orientation getVectorOrientation(class_243 vector) {
        double r = vector.method_1033();
        double longitude = class_3532.method_15349((double)vector.field_1350, (double)vector.field_1352);
        double latitude = Math.acos(vector.field_1351 / r) - 1.5707963267948966;
        return Orientation.create(longitude, latitude *= -1.0);
    }

    public String toString() {
        return "{ Longitude: " + this.longitude + " rads | Latitude: " + this.latitude + " rads }";
    }
}

