/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.helpers;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Support {
    private static final class_2960 PROGRESSION_FINISHED_ADVANCEMENT_IDENTIFIER = SpectrumCommon.locate("endgame/finish_progression");
    public static final DecimalFormat DF = new DecimalFormat("0");
    public static final DecimalFormat DF1 = new DecimalFormat("0.0");
    public static final DecimalFormat DF2 = new DecimalFormat("0.00");

    @NotNull
    public static Optional<class_6862<class_2248>> getFirstMatchingBlockTag(@NotNull class_2680 blockState, @NotNull List<class_6862<class_2248>> tags) {
        return blockState.method_40144().filter(tags::contains).findFirst();
    }

    public static String getWithOneDecimalAfterComma(float number) {
        return DF1.format(number);
    }

    public static String getShortenedNumberString(double number) {
        if (number > 1.0E9) {
            return DF2.format(number / 1.0E9) + "G";
        }
        if (number > 1000000.0) {
            return DF2.format(number / 1000000.0) + "M";
        }
        if (number > 1000.0) {
            return DF2.format(number / 1000.0) + "K";
        }
        return DF.format(number);
    }

    public static String getShortenedNumberString(long number) {
        if (number > 1000000000L) {
            return DF2.format((double)number / 1.0E9) + "G";
        }
        if (number > 1000000L) {
            return DF2.format((double)number / 1000000.0) + "M";
        }
        if (number > 1000L) {
            return DF2.format((double)number / 1000.0) + "K";
        }
        return DF.format(number);
    }

    public static String getSensiblePercent(long x, long y) {
        if (y == 0L) {
            return "0";
        }
        double result = (double)x / (double)y;
        if (result < 0.01 && x > 0L) {
            return "1";
        }
        if (result > 0.99 && x != y) {
            return "99";
        }
        return DF.format(Math.round(result * 100.0));
    }

    public static int getIntFromDecimalWithChance(double d, @NotNull class_5819 random) {
        boolean roundUp;
        boolean bl = roundUp = (double)random.method_43057() < d % 1.0;
        if (roundUp) {
            return (int)d + 1;
        }
        return (int)d;
    }

    public static class_2338 directionalOffset(class_2338 origin, class_2382 forwardUpRight, @NotNull class_2350 horizontalFacing) {
        switch (horizontalFacing) {
            case field_11043: {
                return origin.method_10069(forwardUpRight.method_10260(), forwardUpRight.method_10264(), -forwardUpRight.method_10263());
            }
            case field_11034: {
                return origin.method_10069(forwardUpRight.method_10263(), forwardUpRight.method_10264(), forwardUpRight.method_10260());
            }
            case field_11035: {
                return origin.method_10069(-forwardUpRight.method_10260(), forwardUpRight.method_10264(), forwardUpRight.method_10263());
            }
            case field_11039: {
                return origin.method_10069(-forwardUpRight.method_10263(), forwardUpRight.method_10264(), -forwardUpRight.method_10260());
            }
        }
        SpectrumCommon.logWarning("Called directionalOffset with facing" + horizontalFacing + " this is not supported.");
        return origin;
    }

    public static void grantAdvancementCriterion(@NotNull class_3222 serverPlayerEntity, class_2960 advancementIdentifier, String criterion) {
        if (serverPlayerEntity.method_5682() == null) {
            return;
        }
        class_2989 sal = serverPlayerEntity.method_5682().method_3851();
        class_2985 tracker = serverPlayerEntity.method_14236();
        class_161 advancement = sal.method_12896(advancementIdentifier);
        if (advancement == null) {
            SpectrumCommon.logError("Trying to grant a criterion \"" + criterion + "\" for an advancement that does not exist: " + advancementIdentifier);
        } else if (!tracker.method_12882(advancement).method_740()) {
            tracker.method_12878(advancement, criterion);
        }
    }

    public static void grantAdvancementCriterion(@NotNull class_3222 serverPlayerEntity, String advancementString, String criterion) {
        Support.grantAdvancementCriterion(serverPlayerEntity, SpectrumCommon.locate(advancementString), criterion);
    }

    @NotNull
    public static String getReadableDimensionString(@NotNull String dimensionKeyString) {
        switch (dimensionKeyString) {
            case "minecraft:overworld": {
                return "Overworld";
            }
            case "minecraft:nether": {
                return "Nether";
            }
            case "minecraft:end": {
                return "End";
            }
            case "spectrum:deeper_down": {
                return "Deeper Down";
            }
        }
        if (dimensionKeyString.contains(":")) {
            return dimensionKeyString.substring(dimensionKeyString.indexOf(":") + 1);
        }
        return dimensionKeyString;
    }

    @Contract(pure=true)
    public static class_2350 directionFromRotation(@NotNull class_2470 blockRotation) {
        switch (blockRotation) {
            case field_11467: {
                return class_2350.field_11043;
            }
            case field_11463: {
                return class_2350.field_11034;
            }
            case field_11464: {
                return class_2350.field_11035;
            }
        }
        return class_2350.field_11039;
    }

    @Contract(pure=true)
    public static class_2470 rotationFromDirection(@NotNull class_2350 direction) {
        switch (direction) {
            case field_11034: {
                return class_2470.field_11463;
            }
            case field_11035: {
                return class_2470.field_11464;
            }
            case field_11039: {
                return class_2470.field_11465;
            }
        }
        return class_2470.field_11467;
    }

    public static boolean hasPlayerFinishedMod(class_1657 player) {
        return AdvancementHelper.hasAdvancement((class_1657)player, (class_2960)PROGRESSION_FINISHED_ADVANCEMENT_IDENTIFIER);
    }

    public static Optional<class_2338> getNexReplaceableBlockPosUpDown(class_1937 world, class_2338 blockPos, int maxUpDown) {
        if (world.method_8320(blockPos).method_26207().method_15800()) {
            for (int i = 0; i < maxUpDown; ++i) {
                if (world.method_8320(blockPos.method_10087(i + 1)).method_26207().method_15800()) continue;
                return Optional.of(blockPos.method_10087(i));
            }
        } else {
            for (int i = 1; i <= maxUpDown; ++i) {
                if (!world.method_8320(blockPos.method_10086(i)).method_26207().method_15800()) continue;
                return Optional.of(blockPos.method_10086(i));
            }
        }
        return Optional.empty();
    }

    public static double logBase(double base, double logNumber) {
        return Math.log(logNumber) / Math.log(base);
    }

    static {
        DF.setRoundingMode(RoundingMode.DOWN);
        DF1.setRoundingMode(RoundingMode.DOWN);
        DF2.setRoundingMode(RoundingMode.DOWN);
    }
}

