/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.LoreHelper;
import de.dafuqs.spectrum.inventories.SpectrumScreenHandlerTypes;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import org.apache.commons.lang3.StringUtils;

public class BedrockAnvilScreenHandler
extends class_1703 {
    public static final int FIRST_INPUT_SLOT_INDEX = 0;
    public static final int SECOND_INPUT_SLOT_INDEX = 1;
    public static final int OUTPUT_SLOT_INDEX = 2;
    private static final int PLAYER_INVENTORY_START_INDEX = 3;
    private static final int PLAYER_INVENTORY_END_INDEX = 39;
    protected final class_1731 output = new class_1731();
    protected final class_3914 context;
    protected final class_1263 input = new class_1277(2){

        public void method_5431() {
            super.method_5431();
            BedrockAnvilScreenHandler.this.method_7609((class_1263)this);
        }
    };
    protected final class_1657 player;
    private final class_3915 levelCost = class_3915.method_17403();
    private int repairItemCount;
    private String newItemName;
    private String newLoreString;

    public BedrockAnvilScreenHandler(int syncId, class_1661 inventory) {
        this(syncId, inventory, class_3914.field_17304);
    }

    public BedrockAnvilScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
        super(SpectrumScreenHandlerTypes.BEDROCK_ANVIL, syncId);
        int k;
        this.method_17362(this.levelCost);
        this.context = context;
        this.player = playerInventory.field_7546;
        this.method_7621(new class_1735(this.input, 0, 27, 47));
        this.method_7621(new class_1735(this.input, 1, 76, 47));
        this.method_7621(new class_1735((class_1263)this.output, 2, 134, 47){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public boolean method_7674(class_1657 playerEntity) {
                return BedrockAnvilScreenHandler.this.canTakeOutput(playerEntity, this.method_7681());
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                BedrockAnvilScreenHandler.this.onTakeOutput(player, stack);
            }
        });
        for (k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + k * 9 + 9, 8 + j * 18, 108 + k * 18));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.method_7621(new class_1735((class_1263)playerInventory, k, 8 + k * 18, 166));
        }
    }

    public static int getNextCost(int cost) {
        return cost * 2 + 1;
    }

    public void method_7609(class_1263 inventory) {
        super.method_7609(inventory);
        if (inventory == this.input) {
            this.updateResult();
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.input));
    }

    public boolean method_7597(class_1657 player) {
        return (Boolean)this.context.method_17396((world, pos) -> this.canUse(world.method_8320(pos)) && player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 64.0, (Object)true);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            int i;
            class_1799 itemStack2 = slot.method_7677();
            itemStack = itemStack2.method_7972();
            if (index == 2) {
                if (!this.method_7616(itemStack2, 3, 39, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(itemStack2, itemStack);
            } else if (index != 0 && index != 1 ? index >= 3 && index < 39 && !this.method_7616(itemStack2, i = 0, 2, false) : !this.method_7616(itemStack2, 3, 39, false)) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemStack2);
        }
        return itemStack;
    }

    protected boolean canUse(class_2680 state) {
        return state.method_26164(class_3481.field_15486);
    }

    protected boolean canTakeOutput(class_1657 player, boolean present) {
        return player.method_31549().field_7477 || player.field_7520 >= this.levelCost.method_17407();
    }

    protected void onTakeOutput(class_1657 player, class_1799 stack) {
        if (!player.method_31549().field_7477) {
            player.method_7316(-this.levelCost.method_17407());
        }
        this.input.method_5447(0, class_1799.field_8037);
        if (this.repairItemCount > 0) {
            class_1799 itemStack = this.input.method_5438(1);
            if (!itemStack.method_7960() && itemStack.method_7947() > this.repairItemCount) {
                itemStack.method_7934(this.repairItemCount);
                this.input.method_5447(1, itemStack);
            } else {
                this.input.method_5447(1, class_1799.field_8037);
            }
        } else {
            this.input.method_5447(1, class_1799.field_8037);
        }
        this.levelCost.method_17404(0);
        this.context.method_17393((world, pos) -> world.method_20290(1030, pos, 0));
    }

    public void updateResult() {
        boolean combined = false;
        class_1799 inputStack = this.input.method_5438(0);
        this.levelCost.method_17404(0);
        int enchantmentLevelCost = 0;
        int repairLevelCost = 0;
        int k = 0;
        if (inputStack.method_7960()) {
            this.output.method_5447(0, class_1799.field_8037);
            this.levelCost.method_17404(0);
        } else {
            class_1799 outputStack = inputStack.method_7972();
            class_1799 repairSlotStack = this.input.method_5438(1);
            Map enchantmentLevelMap = class_1890.method_8222((class_1799)outputStack);
            repairLevelCost += inputStack.method_7928() + (repairSlotStack.method_7960() ? 0 : repairSlotStack.method_7928());
            this.repairItemCount = 0;
            if (!repairSlotStack.method_7960()) {
                boolean enchantedBookInRepairSlot;
                combined = true;
                boolean bl = enchantedBookInRepairSlot = repairSlotStack.method_31574(class_1802.field_8598) && !class_1772.method_7806((class_1799)repairSlotStack).isEmpty();
                if (outputStack.method_7963() && outputStack.method_7909().method_7878(inputStack, repairSlotStack)) {
                    int repairItemCount;
                    int o = Math.min(outputStack.method_7919(), outputStack.method_7936() / 4);
                    if (o <= 0) {
                        this.output.method_5447(0, class_1799.field_8037);
                        this.levelCost.method_17404(0);
                        return;
                    }
                    for (repairItemCount = 0; o > 0 && repairItemCount < repairSlotStack.method_7947(); ++repairItemCount) {
                        int newOutputStackDamage = outputStack.method_7919() - o;
                        outputStack.method_7974(newOutputStackDamage);
                        ++enchantmentLevelCost;
                        o = Math.min(outputStack.method_7919(), outputStack.method_7936() / 4);
                    }
                    this.repairItemCount = repairItemCount;
                } else {
                    if (!(enchantedBookInRepairSlot || outputStack.method_31574(repairSlotStack.method_7909()) && outputStack.method_7963())) {
                        this.output.method_5447(0, class_1799.field_8037);
                        this.levelCost.method_17404(0);
                        return;
                    }
                    if (outputStack.method_7963() && !enchantedBookInRepairSlot) {
                        int o = inputStack.method_7936() - inputStack.method_7919();
                        int repairItemCount = repairSlotStack.method_7936() - repairSlotStack.method_7919();
                        int newOutputStackDamage = repairItemCount + outputStack.method_7936() * 12 / 100;
                        int r = o + newOutputStackDamage;
                        int s = outputStack.method_7936() - r;
                        if (s < 0) {
                            s = 0;
                        }
                        if (s < outputStack.method_7919()) {
                            outputStack.method_7974(s);
                            enchantmentLevelCost += 2;
                        }
                    }
                    Map currentEnchantments = class_1890.method_8222((class_1799)repairSlotStack);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Iterator enchantmentIterator = currentEnchantments.keySet().iterator();
                    while (true) {
                        int enchantmentRarityInt;
                        int newEnchantmentLevel;
                        if (!enchantmentIterator.hasNext()) {
                            if (!bl3 || bl2) break;
                            this.output.method_5447(0, class_1799.field_8037);
                            this.levelCost.method_17404(0);
                            return;
                        }
                        class_1887 enchantment = (class_1887)enchantmentIterator.next();
                        if (enchantment == null) continue;
                        int t = enchantmentLevelMap.getOrDefault(enchantment, 0);
                        newEnchantmentLevel = t == (newEnchantmentLevel = ((Integer)currentEnchantments.get(enchantment)).intValue()) ? newEnchantmentLevel + 1 : Math.max(newEnchantmentLevel, t);
                        boolean itemStackIsAcceptableForStack = enchantment.method_8192(inputStack);
                        if (this.player.method_31549().field_7477 || inputStack.method_31574(class_1802.field_8598)) {
                            itemStackIsAcceptableForStack = true;
                        }
                        for (class_1887 enchantment2 : enchantmentLevelMap.keySet()) {
                            if (enchantment2 == enchantment || enchantment.method_8188(enchantment2)) continue;
                            itemStackIsAcceptableForStack = false;
                            ++enchantmentLevelCost;
                        }
                        if (!itemStackIsAcceptableForStack) {
                            bl3 = true;
                            continue;
                        }
                        bl2 = true;
                        if (!SpectrumCommon.CONFIG.BedrockAnvilCanExceedMaxVanillaEnchantmentLevel && newEnchantmentLevel > enchantment.method_8183()) {
                            newEnchantmentLevel = enchantment.method_8183();
                        }
                        enchantmentLevelMap.put(enchantment, newEnchantmentLevel);
                        switch (enchantment.method_8186()) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case field_9087: {
                                int n = 1;
                                break;
                            }
                            case field_9090: {
                                int n = 2;
                                break;
                            }
                            case field_9088: {
                                int n = 4;
                                break;
                            }
                            case field_9091: {
                                int n = enchantmentRarityInt = 8;
                            }
                        }
                        if (enchantedBookInRepairSlot) {
                            enchantmentRarityInt = Math.max(1, enchantmentRarityInt / 2);
                        }
                        enchantmentLevelCost += enchantmentRarityInt * newEnchantmentLevel;
                        if (inputStack.method_7947() <= 1) continue;
                        enchantmentLevelCost = 40;
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)this.newItemName)) {
                if (inputStack.method_7938()) {
                    outputStack.method_7925();
                }
            } else if (!this.newItemName.equals(inputStack.method_7964().getString())) {
                outputStack.method_7977((class_2561)class_2561.method_43470((String)this.newItemName));
            }
            if (StringUtils.isBlank((CharSequence)this.newLoreString)) {
                if (LoreHelper.hasLore(inputStack)) {
                    LoreHelper.removeLore(outputStack);
                }
            } else {
                List<class_2561> lore = LoreHelper.getLoreTextArrayFromString(this.newLoreString);
                if (!LoreHelper.equalsLore(lore, inputStack)) {
                    LoreHelper.setLore(outputStack, lore);
                }
            }
            this.levelCost.method_17404(repairLevelCost + enchantmentLevelCost);
            if (enchantmentLevelCost < 0) {
                outputStack = class_1799.field_8037;
            }
            if (!combined) {
                this.levelCost.method_17404(0);
            } else if (!outputStack.method_7960()) {
                int repairCost = outputStack.method_7928();
                if (!repairSlotStack.method_7960() && repairCost < repairSlotStack.method_7928()) {
                    repairCost = repairSlotStack.method_7928();
                }
                if (k != enchantmentLevelCost) {
                    repairCost = BedrockAnvilScreenHandler.getNextCost(repairCost);
                    outputStack.method_7927(repairCost);
                }
                class_1890.method_8214((Map)enchantmentLevelMap, (class_1799)outputStack);
            }
            this.output.method_5447(0, outputStack);
            this.method_7623();
        }
    }

    public void setNewItemName(String newItemName) {
        this.newItemName = newItemName;
        if (this.method_7611(2).method_7681()) {
            class_1799 itemStack = this.method_7611(2).method_7677();
            if (StringUtils.isBlank((CharSequence)newItemName)) {
                itemStack.method_7925();
            } else {
                itemStack.method_7977((class_2561)class_2561.method_43470((String)this.newItemName));
            }
        }
        this.updateResult();
    }

    public void setNewItemLore(String newLoreString) {
        this.newLoreString = newLoreString;
        if (this.method_7611(2).method_7681()) {
            class_1799 itemStack = this.method_7611(2).method_7677();
            if (StringUtils.isBlank((CharSequence)newLoreString)) {
                LoreHelper.removeLore(itemStack);
            } else {
                LoreHelper.setLore(itemStack, LoreHelper.getLoreTextArrayFromString(this.newLoreString));
            }
        }
        this.updateResult();
    }

    public int getLevelCost() {
        return this.levelCost.method_17407();
    }
}

