/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories;

import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.particle_spawner.ParticleSpawnerBlockEntity;
import de.dafuqs.spectrum.blocks.particle_spawner.ParticleSpawnerConfiguration;
import de.dafuqs.spectrum.data_loaders.ParticleSpawnerParticlesDataLoader;
import de.dafuqs.spectrum.inventories.ParticleSpawnerScreenHandler;
import de.dafuqs.spectrum.networking.SpectrumC2SPackets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.mixin.client.particle.ParticleManagerAccessor;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class ParticleSpawnerScreen
extends class_465<ParticleSpawnerScreenHandler> {
    protected static final class_2960 GUI_TEXTURE = SpectrumCommon.locate("textures/gui/container/particle_spawner.png");
    protected static final int PARTICLES_PER_PAGE = 6;
    protected static final int TEXT_COLOR = 0x222222;
    protected class_1059 spriteAtlasTexture;
    protected boolean glowing = false;
    protected boolean collisionsEnabled = false;
    protected int activeParticlePage = 0;
    protected int particleSelectionIndex = 0;
    protected boolean selectedParticleSupportsColoring = false;
    private final List<class_339> selectableWidgets = new ArrayList<class_339>();
    private class_342 cyanField;
    private class_342 magentaField;
    private class_342 yellowField;
    private class_4185 glowingButton;
    private class_342 amountField;
    private class_342 positionXField;
    private class_342 positionYField;
    private class_342 positionZField;
    private class_342 positionXVarianceField;
    private class_342 positionYVarianceField;
    private class_342 positionZVarianceField;
    private class_342 velocityXField;
    private class_342 velocityYField;
    private class_342 velocityZField;
    private class_342 velocityXVarianceField;
    private class_342 velocityYVarianceField;
    private class_342 velocityZVarianceField;
    private class_342 scale;
    private class_342 scaleVariance;
    private class_342 duration;
    private class_342 durationVariance;
    private class_342 gravity;
    private class_4185 collisionsButton;
    private class_4185 backButton;
    private class_4185 forwardButton;
    private List<class_4185> particleButtons;
    private List<ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry> displayedParticleEntries = new ArrayList<ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry>();

    public ParticleSpawnerScreen(ParticleSpawnerScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_25267 = 48;
        this.field_25268 = 7;
        this.field_2779 = 243;
    }

    protected void method_25426() {
        super.method_25426();
        this.field_22787.field_1774.method_1462(true);
        this.spriteAtlasTexture = ((ParticleManagerAccessor)this.field_22787.field_1713).getParticleAtlasTexture();
        this.displayedParticleEntries = ParticleSpawnerParticlesDataLoader.getAllUnlocked((class_1657)this.field_22787.field_1724);
        this.selectableWidgets.clear();
        this.setupInputFields(((ParticleSpawnerScreenHandler)this.field_2797).getBlockEntity());
        this.method_20085((class_364)this.amountField);
    }

    public void method_25432() {
        super.method_25432();
        this.field_22787.field_1774.method_1462(false);
    }

    public void method_37432() {
        super.method_37432();
        for (class_339 widget : this.selectableWidgets) {
            if (!(widget instanceof class_342)) continue;
            class_342 textFieldWidget = (class_342)widget;
            textFieldWidget.method_1865();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_364 focusedElement;
        if (keyCode == 256) {
            this.field_22787.field_1724.method_7346();
        }
        if ((focusedElement = this.method_25399()) instanceof class_342) {
            class_342 focusedTextFieldWidget = (class_342)focusedElement;
            if (keyCode == 258) {
                int currentIndex = this.selectableWidgets.indexOf(focusedElement);
                focusedTextFieldWidget.method_1876(false);
                if (modifiers == 1) {
                    this.method_25395((class_364)this.selectableWidgets.get((this.selectableWidgets.size() + currentIndex - 1) % this.selectableWidgets.size()));
                } else {
                    this.method_25395((class_364)this.selectableWidgets.get((currentIndex + 1) % this.selectableWidgets.size()));
                }
            }
            return focusedElement.method_25404(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        this.renderForeground(matrices, mouseX, mouseY, delta);
        this.method_2380(matrices, mouseX, mouseY);
    }

    public void renderForeground(class_4587 matrices, int mouseX, int mouseY, float delta) {
        for (class_339 widget : this.selectableWidgets) {
            if (!(widget instanceof class_342)) continue;
            widget.method_25394(matrices, mouseX, mouseY, delta);
        }
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        this.field_22793.method_30883(matrices, this.field_22785, (float)this.field_25267, (float)this.field_25268, 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43470((String)"C").method_27692(class_124.field_1075), 7.0f, 54.0f, 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43470((String)"M").method_27692(class_124.field_1076), 47.0f, 54.0f, 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43470((String)"Y").method_27692(class_124.field_1065), 90.0f, 54.0f, 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43470((String)"Glow"), 130.0f, 54.0f, 0x222222);
        int offset = 23;
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.particle_count"), 10.0f, (float)(53 + offset), 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43470((String)"x"), 66.0f, (float)(64 + offset), 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43470((String)"y"), 99.0f, (float)(64 + offset), 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43470((String)"z"), 134.0f, (float)(64 + offset), 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.offset"), 10.0f, (float)(78 + offset), 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.variance"), 21.0f, (float)(97 + offset), 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.velocity"), 10.0f, (float)(117 + offset), 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.variance"), 21.0f, (float)(137 + offset), 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.scale"), 10.0f, (float)(161 + offset), 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.variance"), 91.0f, (float)(161 + offset), 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.duration"), 10.0f, (float)(181 + offset), 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.variance"), 91.0f, (float)(181 + offset), 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.gravity"), 10.0f, (float)(201 + offset), 0x222222);
        this.field_22793.method_30883(matrices, (class_2561)class_2561.method_43471((String)"block.spectrum.particle_spawner.collisions"), 90.0f, (float)(201 + offset), 0x222222);
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        int spriteIndex;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.method_25302(matrices, x, y, 0, 0, this.field_2792, this.field_2779);
        if (!this.selectedParticleSupportsColoring) {
            this.method_25302(matrices, x + 15, y + 50, 214, 0, 31, 16);
            this.method_25302(matrices, x + 56, y + 50, 214, 0, 31, 16);
            this.method_25302(matrices, x + 97, y + 50, 214, 0, 31, 16);
        }
        if (this.collisionsEnabled) {
            this.method_25302(matrices, x + 146, y + 220, 176, 0, 16, 16);
        }
        if (this.glowing) {
            this.method_25302(matrices, x + 153, y + 50, 176, 0, 16, 16);
        }
        if (this.particleSelectionIndex / 6 == this.activeParticlePage) {
            this.method_25302(matrices, x + 27 + 20 * (this.particleSelectionIndex % 6), y + 19, 192, 0, 22, 22);
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)this.spriteAtlasTexture.method_24106());
        int firstDisplayedEntryId = 6 * this.activeParticlePage;
        for (int j = 0; j < 6 && (spriteIndex = firstDisplayedEntryId + j) < this.displayedParticleEntries.size(); ++j) {
            class_1058 particleSprite = this.spriteAtlasTexture.method_4608(this.displayedParticleEntries.get(spriteIndex).textureIdentifier());
            ParticleSpawnerScreen.method_25298((class_4587)matrices, (int)(x + 38 + j * 20 - particleSprite.method_4595() / 2), (int)(y + 31 - particleSprite.method_4595() / 2), (int)0, (int)particleSprite.method_4578(), (int)particleSprite.method_4595(), (class_1058)particleSprite);
        }
    }

    protected void setupInputFields(ParticleSpawnerBlockEntity blockEntity) {
        this.field_22787.field_1774.method_1462(true);
        int startX = (this.field_22789 - this.field_2792) / 2 + 3;
        int startY = (this.field_22790 - this.field_2779) / 2 + 3;
        ParticleSpawnerConfiguration configuration = blockEntity.getConfiguration();
        this.cyanField = this.addTextFieldWidget(startX + 16, startY + 51, (class_2561)class_2561.method_43470((String)"Cyan"), String.valueOf(configuration.getCmyColor().method_10263()), this::isPositiveDecimalNumber100);
        this.magentaField = this.addTextFieldWidget(startX + 57, startY + 51, (class_2561)class_2561.method_43470((String)"Magenta"), String.valueOf(configuration.getCmyColor().method_10264()), this::isPositiveDecimalNumber100);
        this.yellowField = this.addTextFieldWidget(startX + 97, startY + 51, (class_2561)class_2561.method_43470((String)"Yellow"), String.valueOf(configuration.getCmyColor().method_10260()), this::isPositiveDecimalNumber100);
        this.glowingButton = new class_4185(startX + 153, startY + 50, 16, 16, (class_2561)class_2561.method_43470((String)"Glowing"), this::glowingButtonPressed);
        this.method_25429((class_364)this.glowingButton);
        this.glowing = configuration.glows();
        int offset = 23;
        this.amountField = this.addTextFieldWidget(startX + 110, startY + 50 + offset, (class_2561)class_2561.method_43470((String)"Particles per Second"), String.valueOf(configuration.getParticlesPerSecond()), this::isPositiveDecimalNumberUnderThousand);
        this.positionXField = this.addTextFieldWidget(startX + 61, startY + 74 + offset, (class_2561)class_2561.method_43470((String)"X Position"), String.valueOf(configuration.getSourcePosition().method_4943()), this::isAbsoluteDecimalNumberThousand);
        this.positionYField = this.addTextFieldWidget(startX + 96, startY + 74 + offset, (class_2561)class_2561.method_43470((String)"Y Position"), String.valueOf(configuration.getSourcePosition().method_4945()), this::isAbsoluteDecimalNumberThousand);
        this.positionZField = this.addTextFieldWidget(startX + 131, startY + 74 + offset, (class_2561)class_2561.method_43470((String)"Z Position"), String.valueOf(configuration.getSourcePosition().method_4947()), this::isAbsoluteDecimalNumberThousand);
        this.positionXVarianceField = this.addTextFieldWidget(startX + 69, startY + 94 + offset, (class_2561)class_2561.method_43470((String)"X Position Variance"), String.valueOf(configuration.getSourcePositionVariance().method_4943()), this::isAbsoluteDecimalNumberThousand);
        this.positionYVarianceField = this.addTextFieldWidget(startX + 104, startY + 94 + offset, (class_2561)class_2561.method_43470((String)"Y Position Variance"), String.valueOf(configuration.getSourcePositionVariance().method_4945()), this::isAbsoluteDecimalNumberThousand);
        this.positionZVarianceField = this.addTextFieldWidget(startX + 140, startY + 94 + offset, (class_2561)class_2561.method_43470((String)"Z Position Variance"), String.valueOf(configuration.getSourcePositionVariance().method_4947()), this::isAbsoluteDecimalNumberThousand);
        this.velocityXField = this.addTextFieldWidget(startX + 61, startY + 114 + offset, (class_2561)class_2561.method_43470((String)"X Velocity"), String.valueOf(configuration.getVelocity().method_4943()), this::isAbsoluteDecimalNumberThousand);
        this.velocityYField = this.addTextFieldWidget(startX + 96, startY + 114 + offset, (class_2561)class_2561.method_43470((String)"Y Velocity"), String.valueOf(configuration.getVelocity().method_4945()), this::isAbsoluteDecimalNumberThousand);
        this.velocityZField = this.addTextFieldWidget(startX + 131, startY + 114 + offset, (class_2561)class_2561.method_43470((String)"Z Velocity"), String.valueOf(configuration.getVelocity().method_4947()), this::isAbsoluteDecimalNumberThousand);
        this.velocityXVarianceField = this.addTextFieldWidget(startX + 69, startY + 134 + offset, (class_2561)class_2561.method_43470((String)"X Velocity Variance"), String.valueOf(configuration.getVelocityVariance().method_4943()), this::isAbsoluteDecimalNumberThousand);
        this.velocityYVarianceField = this.addTextFieldWidget(startX + 104, startY + 134 + offset, (class_2561)class_2561.method_43470((String)"Y Velocity Variance"), String.valueOf(configuration.getVelocityVariance().method_4945()), this::isAbsoluteDecimalNumberThousand);
        this.velocityZVarianceField = this.addTextFieldWidget(startX + 140, startY + 134 + offset, (class_2561)class_2561.method_43470((String)"Z Velocity Variance"), String.valueOf(configuration.getVelocityVariance().method_4947()), this::isAbsoluteDecimalNumberThousand);
        this.scale = this.addTextFieldWidget(startX + 55, startY + 158 + offset, (class_2561)class_2561.method_43470((String)"Scale"), String.valueOf(configuration.getScale()), this::isPositiveDecimalNumberUnderTen);
        this.scaleVariance = this.addTextFieldWidget(startX + 139, startY + 158 + offset, (class_2561)class_2561.method_43470((String)"Scale Variance"), String.valueOf(configuration.getScaleVariance()), this::isPositiveDecimalNumberUnderTen);
        this.duration = this.addTextFieldWidget(startX + 55, startY + 178 + offset, (class_2561)class_2561.method_43470((String)"Duration"), String.valueOf(configuration.getLifetimeTicks()), this::isPositiveWholeNumberUnderThousand);
        this.durationVariance = this.addTextFieldWidget(startX + 139, startY + 178 + offset, (class_2561)class_2561.method_43470((String)"Duration Variance"), String.valueOf(configuration.getLifetimeVariance()), this::isPositiveWholeNumberUnderThousand);
        this.gravity = this.addTextFieldWidget(startX + 55, startY + 198 + offset, (class_2561)class_2561.method_43470((String)"Gravity"), String.valueOf(configuration.getGravity()), this::isBetweenZeroAndOne);
        this.collisionsButton = new class_4185(startX + 142, startY + 194 + offset, 16, 16, (class_2561)class_2561.method_43470((String)"Collisions"), this::collisionButtonPressed);
        this.collisionsEnabled = configuration.hasCollisions();
        this.method_25429((class_364)this.collisionsButton);
        this.selectableWidgets.add((class_339)this.cyanField);
        this.selectableWidgets.add((class_339)this.magentaField);
        this.selectableWidgets.add((class_339)this.yellowField);
        this.selectableWidgets.add((class_339)this.glowingButton);
        this.selectableWidgets.add((class_339)this.amountField);
        this.selectableWidgets.add((class_339)this.positionXField);
        this.selectableWidgets.add((class_339)this.positionYField);
        this.selectableWidgets.add((class_339)this.positionZField);
        this.selectableWidgets.add((class_339)this.positionXVarianceField);
        this.selectableWidgets.add((class_339)this.positionYVarianceField);
        this.selectableWidgets.add((class_339)this.positionZVarianceField);
        this.selectableWidgets.add((class_339)this.velocityXField);
        this.selectableWidgets.add((class_339)this.velocityYField);
        this.selectableWidgets.add((class_339)this.velocityZField);
        this.selectableWidgets.add((class_339)this.velocityXVarianceField);
        this.selectableWidgets.add((class_339)this.velocityYVarianceField);
        this.selectableWidgets.add((class_339)this.velocityZVarianceField);
        this.selectableWidgets.add((class_339)this.scale);
        this.selectableWidgets.add((class_339)this.scaleVariance);
        this.selectableWidgets.add((class_339)this.duration);
        this.selectableWidgets.add((class_339)this.durationVariance);
        this.selectableWidgets.add((class_339)this.gravity);
        this.selectableWidgets.add((class_339)this.collisionsButton);
        this.backButton = new class_4185(startX + 11, startY + 19, 12, 14, (class_2561)class_2561.method_43470((String)"Back"), this::navigationButtonPressed);
        this.method_25429((class_364)this.backButton);
        this.forwardButton = new class_4185(startX + 147, startY + 19, 12, 14, (class_2561)class_2561.method_43470((String)"Forward"), this::navigationButtonPressed);
        this.method_25429((class_364)this.forwardButton);
        this.particleButtons = List.of(this.addParticleButton(startX + 23, startY + 16), this.addParticleButton(startX + 23 + 20, startY + 16), this.addParticleButton(startX + 23 + 40, startY + 16), this.addParticleButton(startX + 23 + 60, startY + 16), this.addParticleButton(startX + 23 + 80, startY + 16), this.addParticleButton(startX + 23 + 100, startY + 16));
        this.particleSelectionIndex = 0;
        int particleIndex = 0;
        for (ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry availableParticle : this.displayedParticleEntries) {
            if (availableParticle.particleType().equals(configuration.getParticleType())) {
                this.particleSelectionIndex = particleIndex;
                break;
            }
            ++particleIndex;
        }
        if (this.displayedParticleEntries.size() == 0) {
            this.setColoringEnabled(false);
        }
        ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry entry = this.displayedParticleEntries.get(this.particleSelectionIndex);
        this.setColoringEnabled(entry.supportsColoring());
    }

    private void navigationButtonPressed(class_4185 buttonWidget) {
        int pageCount = this.displayedParticleEntries.size() / 6;
        this.activeParticlePage = buttonWidget == this.forwardButton ? (this.activeParticlePage + 1) % pageCount : (this.activeParticlePage - 1 + pageCount) % pageCount;
    }

    @NotNull
    private class_342 addTextFieldWidget(int x, int y, class_2561 text, String defaultText, Predicate<String> textPredicate) {
        class_342 textFieldWidget = new class_342(this.field_22793, x, y, 31, 16, text);
        textFieldWidget.method_1890(textPredicate);
        textFieldWidget.method_1856(true);
        textFieldWidget.method_1888(true);
        textFieldWidget.method_1868(-1);
        textFieldWidget.method_1860(-1);
        textFieldWidget.method_1858(false);
        textFieldWidget.method_1880(6);
        textFieldWidget.method_1852(defaultText);
        textFieldWidget.method_1863(this::onTextBoxValueChanged);
        this.method_25429((class_364)textFieldWidget);
        return textFieldWidget;
    }

    @NotNull
    private class_4185 addParticleButton(int x, int y) {
        class_4185 button = new class_4185(x, y, 20, 20, (class_2561)class_2561.method_43470((String)"Particles"), this::particleButtonPressed);
        this.method_25429((class_364)button);
        return button;
    }

    private void particleButtonPressed(class_4185 buttonWidget) {
        int buttonIndex = this.particleButtons.indexOf(buttonWidget);
        int newIndex = 6 * this.activeParticlePage + buttonIndex;
        if (newIndex < this.displayedParticleEntries.size()) {
            this.particleSelectionIndex = newIndex;
            this.onValuesChanged();
        }
        ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry entry = this.displayedParticleEntries.get(newIndex);
        this.setColoringEnabled(entry.supportsColoring());
    }

    private void setColoringEnabled(boolean enabled) {
        this.selectedParticleSupportsColoring = enabled;
        this.cyanField.method_1888(enabled);
        this.magentaField.method_1888(enabled);
        this.yellowField.method_1888(enabled);
        this.cyanField.method_1856(enabled);
        this.magentaField.method_1856(enabled);
        this.yellowField.method_1856(enabled);
        this.cyanField.method_1863(enabled ? this::onTextBoxValueChanged : null);
        this.magentaField.method_1863(enabled ? this::onTextBoxValueChanged : null);
        this.yellowField.method_1863(enabled ? this::onTextBoxValueChanged : null);
        this.method_25395((class_364)this.amountField);
    }

    private void collisionButtonPressed(class_4185 buttonWidget) {
        this.collisionsEnabled = !this.collisionsEnabled;
        this.onValuesChanged();
    }

    private void glowingButtonPressed(class_4185 buttonWidget) {
        this.glowing = !this.glowing;
        this.onValuesChanged();
    }

    private void onTextBoxValueChanged(@NotNull String newValue) {
        this.onValuesChanged();
    }

    protected boolean isDecimalNumber(@NotNull String text) {
        return text.matches("^(-)?\\d*+(?:\\.\\d*)?$");
    }

    private boolean isPositiveDecimalNumberUnderThousand(String text) {
        try {
            return Double.parseDouble(text) < 1000.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isAbsoluteDecimalNumberThousand(String text) {
        try {
            return Math.abs(Double.parseDouble(text)) < 1000.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isPositiveDecimalNumber100(String text) {
        try {
            int number = Integer.parseInt(text);
            return number >= 0 && number <= 100;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isPositiveDecimalNumberUnderTen(String text) {
        try {
            return Double.parseDouble(text) < 10.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isPositiveDecimalNumber(@NotNull String text) {
        return text.matches("^\\d*+(?:\\.\\d*)?$");
    }

    protected boolean isPositiveWholeNumber(@NotNull String text) {
        return text.matches("^\\d*$");
    }

    protected boolean isPositiveWholeNumberUnderThousand(@NotNull String text) {
        try {
            return Integer.parseInt(text) < 1000;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isBetweenZeroAndOne(@NotNull String text) {
        try {
            float f = Float.parseFloat(text);
            return f >= 0.0f && f <= 1.0f;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void onValuesChanged() {
        try {
            ParticleSpawnerConfiguration configuration = new ParticleSpawnerConfiguration(this.displayedParticleEntries.get(this.particleSelectionIndex).particleType(), this.selectedParticleSupportsColoring ? new class_2382((double)Float.parseFloat(this.cyanField.method_1882()), (double)Float.parseFloat(this.magentaField.method_1882()), (double)Float.parseFloat(this.yellowField.method_1882())) : class_2382.field_11176, this.glowing, Float.parseFloat(this.amountField.method_1882()), new class_1160(Float.parseFloat(this.positionXField.method_1882()), Float.parseFloat(this.positionYField.method_1882()), Float.parseFloat(this.positionZField.method_1882())), new class_1160(Float.parseFloat(this.positionXVarianceField.method_1882()), Float.parseFloat(this.positionYVarianceField.method_1882()), Float.parseFloat(this.positionZVarianceField.method_1882())), new class_1160(Float.parseFloat(this.velocityXField.method_1882()), Float.parseFloat(this.velocityYField.method_1882()), Float.parseFloat(this.velocityZField.method_1882())), new class_1160(Float.parseFloat(this.velocityXVarianceField.method_1882()), Float.parseFloat(this.velocityYVarianceField.method_1882()), Float.parseFloat(this.velocityZVarianceField.method_1882())), Float.parseFloat(this.scale.method_1882()), Float.parseFloat(this.scaleVariance.method_1882()), Integer.parseInt(this.duration.method_1882()), Integer.parseInt(this.durationVariance.method_1882()), Float.parseFloat(this.gravity.method_1882()), this.collisionsEnabled);
            class_2540 packetByteBuf = PacketByteBufs.create();
            configuration.write(packetByteBuf);
            ClientPlayNetworking.send((class_2960)SpectrumC2SPackets.CHANGE_PARTICLE_SPAWNER_SETTINGS_PACKET_ID, (class_2540)packetByteBuf);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

