/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories;

import com.mojang.blaze3d.systems.RenderSystem;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.inventories.PedestalScreenHandler;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.registries.SpectrumMultiblocks;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class PedestalScreen
extends class_465<PedestalScreenHandler> {
    public static final class_2960 BACKGROUND1 = SpectrumCommon.locate("textures/gui/container/pedestal1.png");
    public static final class_2960 BACKGROUND2 = SpectrumCommon.locate("textures/gui/container/pedestal2.png");
    public static final class_2960 BACKGROUND3 = SpectrumCommon.locate("textures/gui/container/pedestal3.png");
    public static final class_2960 BACKGROUND4 = SpectrumCommon.locate("textures/gui/container/pedestal4.png");
    private final class_2960 backgroundTexture;
    private final PedestalRecipeTier maxPedestalRecipeTierForVariant;
    private final boolean structureUpdateAvailable;
    final int informationIconX = 95;
    final int informationIconY = 55;

    public PedestalScreen(PedestalScreenHandler handler, class_1661 playerInventory, class_2561 title) {
        super((class_1703)handler, playerInventory, title);
        this.field_2779 = 194;
        this.maxPedestalRecipeTierForVariant = handler.getPedestalRecipeTier();
        this.backgroundTexture = PedestalScreen.getBackgroundTextureForTier(this.maxPedestalRecipeTierForVariant);
        PedestalRecipeTier maxPedestalRecipeTier = handler.getMaxPedestalRecipeTier();
        this.structureUpdateAvailable = this.maxPedestalRecipeTierForVariant != maxPedestalRecipeTier;
    }

    @Contract(pure=true)
    public static class_2960 getBackgroundTextureForTier(@NotNull PedestalRecipeTier recipeTier) {
        switch (recipeTier) {
            case COMPLEX: {
                return BACKGROUND4;
            }
            case ADVANCED: {
                return BACKGROUND3;
            }
            case SIMPLE: {
                return BACKGROUND2;
            }
        }
        return BACKGROUND1;
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        int titleX = (this.field_2792 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
        int titleY = 7;
        class_2561 title = this.field_22785;
        int inventoryX = 8;
        int intInventoryY = 100;
        this.field_22793.method_30883(matrices, title, (float)titleX, (float)titleY, 0x323232);
        this.field_22793.method_30883(matrices, this.field_29347, (float)inventoryX, (float)intInventoryY, 0x323232);
        if (this.structureUpdateAvailable) {
            if ((this.field_22787.field_1687.method_8510() >> 4) % 2L == 0L) {
                this.field_22793.method_1729(matrices, "\u2139", 95.0f, 55.0f, 0xA80000);
            } else {
                this.field_22793.method_1729(matrices, "\u2139", 95.0f, 55.0f, 0xF80000);
            }
        }
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)this.backgroundTexture);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.method_25302(matrices, x, y, 0, 0, this.field_2792, this.field_2779);
        boolean isCrafting = ((PedestalScreenHandler)this.field_2797).isCrafting();
        if (isCrafting) {
            int progressWidth = ((PedestalScreenHandler)this.field_2797).getCraftingProgress();
            this.method_25302(matrices, x + 88, y + 37, 176, 0, progressWidth + 1, 16);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.mouseOverInformationIcon((int)mouseX, (int)mouseY)) {
            IMultiblock multiblockToDisplay;
            IMultiblock currentMultiBlock = PatchouliAPI.get().getCurrentMultiblock();
            if (currentMultiBlock == (multiblockToDisplay = PatchouliAPI.get().getMultiblock(SpectrumMultiblocks.getDisplayStructureIdentifierForTier(this.maxPedestalRecipeTierForVariant, (class_1657)class_310.method_1551().field_1724)))) {
                PatchouliAPI.get().clearMultiblock();
            } else {
                PatchouliAPI.get().showMultiblock(multiblockToDisplay, SpectrumMultiblocks.getPedestalStructureText(this.maxPedestalRecipeTierForVariant), ((PedestalScreenHandler)this.field_2797).getPedestalPos().method_10087(2), class_2470.field_11467);
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        if (this.mouseOverInformationIcon(mouseX, mouseY)) {
            this.method_25424(matrices, (class_2561)class_2561.method_43471((String)"multiblock.spectrum.pedestal.upgrade_available"), mouseX, mouseY);
        } else {
            this.method_2380(matrices, mouseX, mouseY);
        }
    }

    private boolean mouseOverInformationIcon(int mouseX, int mouseY) {
        return this.structureUpdateAvailable && mouseX > this.field_2776 + 95 - 2 && mouseX < this.field_2776 + 95 + 10 && mouseY > this.field_2800 + 55 - 2 && mouseY < this.field_2800 + 55 + 10;
    }
}

