/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.inventories.widgets;

import de.dafuqs.spectrum.energy.InkStorageBlockEntity;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.storage.IndividualCappedInkStorage;
import de.dafuqs.spectrum.helpers.RenderHelper;
import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class InkMeterWidget
extends class_332
implements class_4068,
class_364,
class_6379 {
    public static final int WIDTH_PER_COLOR = 4;
    public static final int SPACE_BETWEEN_COLORS = 2;
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    protected boolean hovered;
    protected final class_437 screen;
    protected final InkStorageBlockEntity<IndividualCappedInkStorage> inkStorageBlockEntity;

    public InkMeterWidget(int x, int y, int height, class_437 screen, InkStorageBlockEntity<IndividualCappedInkStorage> inkStorageBlockEntity) {
        this.x = x;
        this.y = y;
        this.width = inkStorageBlockEntity.getEnergyStorage().getSupportedColors().size() * 6 - 2;
        this.height = height;
        this.screen = screen;
        this.inkStorageBlockEntity = inkStorageBlockEntity;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
    }

    public class_6379.class_6380 method_37018() {
        return this.hovered ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 builder) {
    }

    public void drawMouseoverTooltip(class_4587 matrices, int x, int y) {
        ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
        this.inkStorageBlockEntity.getEnergyStorage().addTooltip(tooltip, false);
        this.screen.method_32634(matrices, tooltip, Optional.empty(), x, y);
    }

    public void draw(class_4587 matrices) {
        int startHeight = this.y + this.height;
        int currentXOffset = 0;
        IndividualCappedInkStorage inkStorage = this.inkStorageBlockEntity.getEnergyStorage();
        long total = inkStorage.getMaxPerColor();
        for (InkColor inkColor : inkStorage.getSupportedColors()) {
            long amount = inkStorage.getEnergy(inkColor);
            if (amount > 0L) {
                int height = Math.max(1, Math.round((float)amount / ((float)total / (float)this.height)));
                RenderHelper.fillQuad(matrices, this.x + currentXOffset, startHeight - height, height, 4, inkColor.getColor());
            }
            currentXOffset = currentXOffset + 4 + 2;
        }
    }
}

