/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.Support;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_5819;

public interface ExperienceStorageItem {
    public static int getStoredExperience(class_1799 itemStack) {
        class_2487 nbtCompound = itemStack.method_7969();
        if (nbtCompound == null || !nbtCompound.method_10573("stored_experience", 99)) {
            return 0;
        }
        return nbtCompound.method_10550("stored_experience");
    }

    public static int addStoredExperience(class_1799 itemStack, float amount, class_5819 random) {
        if (amount > 0.0f) {
            int intAmount = Support.getIntFromDecimalWithChance(amount, random);
            return ExperienceStorageItem.addStoredExperience(itemStack, intAmount);
        }
        return 0;
    }

    public static int addStoredExperience(class_1799 itemStack, int amount) {
        if (amount <= 0) {
            return 0;
        }
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof ExperienceStorageItem) {
            ExperienceStorageItem experienceStorageItem = (ExperienceStorageItem)class_17922;
            int maxStorage = experienceStorageItem.getMaxStoredExperience(itemStack);
            class_2487 nbtCompound = itemStack.method_7948();
            if (!nbtCompound.method_10573("stored_experience", 99)) {
                nbtCompound.method_10569("stored_experience", amount);
                itemStack.method_7980(nbtCompound);
                return 0;
            }
            int existingStoredExperience = nbtCompound.method_10550("stored_experience");
            int experienceOverflow = maxStorage - amount - existingStoredExperience;
            if (experienceOverflow < 0) {
                nbtCompound.method_10569("stored_experience", maxStorage);
                itemStack.method_7980(nbtCompound);
                return -experienceOverflow;
            }
            nbtCompound.method_10569("stored_experience", existingStoredExperience + amount);
            itemStack.method_7980(nbtCompound);
            return 0;
        }
        if (!itemStack.method_7960()) {
            SpectrumCommon.logError("Tried to add stored Experience to a non-ExperienceStorageItem item: " + itemStack.method_7909().method_7848().getString());
        }
        return 0;
    }

    public static boolean removeStoredExperience(class_1799 itemStack, int amount) {
        if (itemStack.method_7909() instanceof ExperienceStorageItem) {
            class_2487 nbtCompound = itemStack.method_7969();
            if (nbtCompound == null || !nbtCompound.method_10573("stored_experience", 99)) {
                return false;
            }
            int existingStoredExperience = nbtCompound.method_10550("stored_experience");
            if (existingStoredExperience < amount) {
                return false;
            }
            nbtCompound.method_10569("stored_experience", existingStoredExperience - amount);
            itemStack.method_7980(nbtCompound);
            return true;
        }
        SpectrumCommon.logError("Tried to remove stored Experience from a non-ExperienceStorageItem: " + itemStack.method_7909().method_7848().getString());
        return false;
    }

    public int getMaxStoredExperience(class_1799 var1);
}

