/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.energy.InkCost;
import de.dafuqs.spectrum.energy.InkPowered;
import de.dafuqs.spectrum.energy.color.InkColors;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public class CelestialPocketWatchItem
extends class_1792 {
    public static final int TIME_STEP_TICKS = 3000;
    public static final InkCost COST = new InkCost(InkColors.MAGENTA, 1000L);

    public CelestialPocketWatchItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (!world.field_9236) {
            if (!CelestialPocketWatchItem.tryAdvanceTime((class_3218)world, (class_3222)user)) {
                world.method_8396(null, user.method_24515(), SpectrumSoundEvents.USE_FAIL, class_3419.field_15248, 1.0f, 1.0f);
            }
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_29237((Object)itemStack, (boolean)true);
    }

    public static boolean tryAdvanceTime(class_3218 world, class_3222 user) {
        switch (CelestialPocketWatchItem.canAdvanceTime((class_1937)world)) {
            case FAILED_GAME_RULE: {
                user.method_7353((class_2561)class_2561.method_43471((String)"item.spectrum.celestial_pocketwatch.tooltip.use_blocked_gamerule"), true);
                break;
            }
            case FAILED_FIXED_TIME: {
                user.method_7353((class_2561)class_2561.method_43471((String)"item.spectrum.celestial_pocketwatch.tooltip.use_blocked_fixed_time"), true);
                break;
            }
            case SUCCESS: {
                if (InkPowered.tryDrainEnergy((class_1657)user, COST)) {
                    world.method_8396(null, user.method_24515(), SpectrumSoundEvents.CELESTIAL_POCKET_WATCH_TICKING, class_3419.field_15248, 1.0f, 1.0f);
                    CelestialPocketWatchItem.advanceTime(world, 3000);
                }
                return true;
            }
        }
        return false;
    }

    private static TimeToggleResult canAdvanceTime(@NotNull class_1937 world) {
        class_1928.class_4310 doDaylightCycleRule = (class_1928.class_4310)world.method_8450().method_20746(class_1928.field_19396);
        if (doDaylightCycleRule.method_20753()) {
            if (world.method_8597().method_29960()) {
                return TimeToggleResult.FAILED_FIXED_TIME;
            }
            return TimeToggleResult.SUCCESS;
        }
        return TimeToggleResult.FAILED_GAME_RULE;
    }

    private static void advanceTime(@NotNull class_3218 world, int additionalTime) {
        SpectrumS2CPacketSender.startSkyLerping(world, additionalTime);
        long timeOfDay = world.method_8532();
        world.method_29199(timeOfDay + (long)additionalTime);
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        super.method_7851(itemStack, world, tooltip, tooltipContext);
        tooltip.add((class_2561)class_2561.method_43471((String)"spectrum.tooltip.ink_powered.magenta"));
        if (world != null) {
            switch (CelestialPocketWatchItem.canAdvanceTime(world)) {
                case FAILED_GAME_RULE: {
                    tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.celestial_pocketwatch.tooltip.use_blocked_gamerule").method_27692(class_124.field_1080));
                    break;
                }
                case FAILED_FIXED_TIME: {
                    tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.celestial_pocketwatch.tooltip.use_blocked_fixed_time").method_27692(class_124.field_1080));
                    break;
                }
                case SUCCESS: {
                    tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.celestial_pocketwatch.tooltip.working").method_27692(class_124.field_1080));
                }
            }
        }
    }

    static enum TimeToggleResult {
        SUCCESS,
        FAILED_FIXED_TIME,
        FAILED_GAME_RULE;

    }
}

