/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.blocks.enchanter.ExtendedEnchantable;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.items.ExperienceStorageItem;
import de.dafuqs.spectrum.items.LoomPatternProvider;
import de.dafuqs.spectrum.registries.SpectrumBannerPatterns;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5328;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class KnowledgeGemItem
extends class_1792
implements ExperienceStorageItem,
ExtendedEnchantable,
LoomPatternProvider {
    private final int maxStorageBase;
    protected final int[] displayTiers = new int[]{1, 10, 25, 50, 100, 250, 500, 1000, 2500, 5000};

    public KnowledgeGemItem(class_1792.class_1793 settings, int maxStorageBase) {
        super(settings);
        this.maxStorageBase = maxStorageBase;
    }

    public static class_1799 getKnowledgeDropStackWithXP(int experience, boolean noStoreTooltip) {
        class_1799 stack = new class_1799((class_1935)SpectrumItems.KNOWLEDGE_GEM);
        class_2487 compound = new class_2487();
        compound.method_10569("stored_experience", experience);
        if (noStoreTooltip) {
            compound.method_10556("do_not_display_store_tooltip", true);
        }
        stack.method_7980(compound);
        return stack;
    }

    @Override
    public int getMaxStoredExperience(class_1799 itemStack) {
        int efficiencyLevel = class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)itemStack);
        return this.maxStorageBase * (int)Math.pow(10.0, Math.min(5, efficiencyLevel));
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int getTransferableExperiencePerTick(class_1799 itemStack) {
        int quickChargeLevel = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)itemStack);
        return (int)(2.0 * Math.pow(2.0, Math.min(10, quickChargeLevel)));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public int method_7881(class_1799 stack) {
        return Integer.MAX_VALUE;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        super.method_7852(world, user, stack, remainingUseTicks);
        if (user instanceof class_3222) {
            int experienceToTransfer;
            class_3222 serverPlayerEntity = (class_3222)user;
            int playerExperience = serverPlayerEntity.field_7495;
            int itemExperience = ExperienceStorageItem.getStoredExperience(stack);
            int transferableExperience = this.getTransferableExperiencePerTick(stack);
            if (serverPlayerEntity.method_5715()) {
                int experienceToTransfer2;
                int maxStorage = this.getMaxStoredExperience(stack);
                int n = experienceToTransfer2 = serverPlayerEntity.method_7337() ? Math.min(transferableExperience, maxStorage - itemExperience) : Math.min(Math.min(transferableExperience, playerExperience), maxStorage - itemExperience);
                if (experienceToTransfer2 > 0 && itemExperience < maxStorage && this.removePlayerExperience((class_1657)serverPlayerEntity, experienceToTransfer2)) {
                    ExperienceStorageItem.addStoredExperience(stack, experienceToTransfer2);
                    if (remainingUseTicks % 4 == 0) {
                        world.method_8396(null, user.method_24515(), class_3417.field_14627, class_3419.field_15248, 0.3f, 0.8f + world.method_8409().method_43057() * 0.4f);
                    }
                }
            } else if (itemExperience > 0 && playerExperience != Integer.MAX_VALUE && (experienceToTransfer = Math.min(Math.min(transferableExperience, itemExperience), Integer.MAX_VALUE - playerExperience)) > 0) {
                if (!serverPlayerEntity.method_7337()) {
                    serverPlayerEntity.method_7255(experienceToTransfer);
                }
                ExperienceStorageItem.removeStoredExperience(stack, experienceToTransfer);
                if (remainingUseTicks % 4 == 0) {
                    world.method_8396(null, user.method_24515(), class_3417.field_14627, class_3419.field_15248, 0.3f, 0.8f + world.method_8409().method_43057() * 0.4f);
                }
            }
        }
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        super.method_7851(itemStack, world, tooltip, tooltipContext);
        int maxExperience = this.getMaxStoredExperience(itemStack);
        int storedExperience = ExperienceStorageItem.getStoredExperience(itemStack);
        if (storedExperience == 0) {
            tooltip.add((class_2561)class_2561.method_43470((String)"0 ").method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43469((String)"item.spectrum.knowledge_gem.tooltip.stored_experience", (Object[])new Object[]{maxExperience}).method_27692(class_124.field_1080)));
        } else {
            tooltip.add((class_2561)class_2561.method_43470((String)(storedExperience + " ")).method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43469((String)"item.spectrum.knowledge_gem.tooltip.stored_experience", (Object[])new Object[]{maxExperience}).method_27692(class_124.field_1080)));
        }
        if (this.shouldDisplayUsageTooltip(itemStack)) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.knowledge_gem.tooltip.use", (Object[])new Object[]{this.getTransferableExperiencePerTick(itemStack)}).method_27692(class_124.field_1080));
            this.addBannerPatternProviderTooltip(tooltip);
        }
    }

    public boolean shouldDisplayUsageTooltip(class_1799 itemStack) {
        class_2487 nbtCompound = itemStack.method_7969();
        return nbtCompound == null || !nbtCompound.method_10577("do_not_display_store_tooltip");
    }

    public boolean removePlayerExperience(@NotNull class_1657 playerEntity, int experience) {
        if (playerEntity.method_7337()) {
            return true;
        }
        if (playerEntity.field_7495 < experience) {
            return false;
        }
        playerEntity.field_7495 -= experience;
        playerEntity.field_7510 -= (float)experience / (float)playerEntity.method_7349();
        while (playerEntity.field_7510 < 0.0f) {
            float f = playerEntity.field_7510 * (float)playerEntity.method_7349();
            if (playerEntity.field_7520 > 0) {
                playerEntity.method_7316(-1);
                playerEntity.field_7510 = 1.0f + f / (float)playerEntity.method_7349();
                continue;
            }
            playerEntity.method_7316(-1);
            playerEntity.field_7510 = 0.0f;
        }
        return true;
    }

    public boolean changedDisplayTier(int currentStoredExperience, int destinationStoredExperience) {
        return this.getDisplayTierForExperience(currentStoredExperience) != this.getDisplayTierForExperience(destinationStoredExperience);
    }

    public int getDisplayTierForExperience(int experience) {
        for (int i = 0; i < this.displayTiers.length; ++i) {
            if (experience >= this.displayTiers[i]) continue;
            return i;
        }
        return this.displayTiers.length;
    }

    @Override
    public class_6880<class_2582> getPattern() {
        return SpectrumBannerPatterns.KNOWLEDGE_GEM;
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }

    @Override
    public boolean acceptsEnchantment(class_1887 enchantment) {
        return enchantment == class_1893.field_9131 || enchantment == class_1893.field_9098;
    }

    public int method_7837() {
        return 5;
    }

    public void method_7850(class_1761 group, class_2371<class_1799> stacks) {
        super.method_7850(group, stacks);
        if (this.method_7877(group)) {
            class_1799 stack = this.method_7854();
            ExperienceStorageItem.addStoredExperience(stack, this.getMaxStoredExperience(stack));
            stacks.add((Object)stack);
            class_1799 enchantedStack = SpectrumEnchantmentHelper.getMaxEnchantedStack(this);
            ExperienceStorageItem.addStoredExperience(enchantedStack, this.getMaxStoredExperience(enchantedStack));
            stacks.add((Object)enchantedStack);
        }
    }
}

