/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.magic_items;

import de.dafuqs.spectrum.items.DamageAwareItem;
import de.dafuqs.spectrum.items.TickAwareItem;
import de.dafuqs.spectrum.registries.SpectrumDamageSources;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.sound.PipeBombChargingSoundInstance;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5328;
import net.minecraft.class_5362;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class PipeBombItem
extends class_1792
implements DamageAwareItem,
TickAwareItem {
    public PipeBombItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.field_9236) {
            this.startSoundInstance(user);
        }
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    @Environment(value=EnvType.CLIENT)
    public void startSoundInstance(class_1657 user) {
        class_310.method_1551().method_1483().method_4873((class_1113)new PipeBombChargingSoundInstance(user));
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        class_2487 nbt = stack.method_7948();
        nbt.method_10556("armed", true);
        nbt.method_10544("timestamp", world.method_8510());
        nbt.method_25927("owner", user.method_5667());
        user.method_5783(SpectrumSoundEvents.INCANDESCENT_ARM, 2.0f, 0.9f);
        return stack;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (world.method_8608()) {
            return;
        }
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("armed")) {
            return;
        }
        if (this.tryGetOwner(stack, (class_3218)world) == entity && world.method_8510() - nbt.method_10537("timestamp") < 100L) {
            return;
        }
        this.explode(stack, (class_3218)world, entity.method_19538(), Optional.of(entity));
    }

    @Override
    public void onItemEntityTicked(class_1542 itemEntity) {
        class_1937 world = itemEntity.method_37908();
        class_1799 stack = itemEntity.method_6983();
        class_2487 nbt = stack.method_7948();
        if (world.method_8608() || !nbt.method_10545("armed")) {
            return;
        }
        if (world.method_8510() - nbt.method_10537("timestamp") > 100L) {
            this.explode(stack, (class_3218)world, itemEntity.method_33571(), Optional.empty());
        }
    }

    @Override
    public void onItemEntityDamaged(class_1282 source, float amount, class_1542 itemEntity) {
        if ((source.method_5534() || source.method_5535()) && !itemEntity.method_37908().method_8608()) {
            this.explode(itemEntity.method_6983(), (class_3218)itemEntity.method_37908(), itemEntity.method_19538(), Optional.empty());
        }
    }

    private void explode(class_1799 stack, class_3218 world, class_243 pos, Optional<class_1297> target) {
        stack.method_7934(1);
        class_1297 owner = this.tryGetOwner(stack, world);
        target.ifPresent(entity -> entity.method_5643(SpectrumDamageSources.incandescence(owner), 200.0f));
        world.method_8454(null, SpectrumDamageSources.INCANDESCENCE, new class_5362(), pos.method_10216(), pos.method_10214(), pos.method_10215(), 7.5f, true, class_1927.class_4179.field_18685);
    }

    public class_1297 tryGetOwner(class_1799 stack, class_3218 world) {
        class_2487 nbt = stack.method_7969();
        if (nbt == null || !nbt.method_10545("owner")) {
            return null;
        }
        return world.method_14190(nbt.method_25926("owner"));
    }

    public int method_7881(class_1799 stack) {
        return 55;
    }

    public static float isArmed(class_1799 stack, @Nullable class_638 world, @Nullable class_1309 entity, int seed) {
        class_2487 nbt = stack.method_7948();
        if (!nbt.method_10545("armed")) {
            return 0.0f;
        }
        return nbt.method_10577("armed") ? 1.0f : 0.0f;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.pipe_bomb.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.pipe_bomb.tooltip2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.pipe_bomb.tooltip3").method_27692(class_124.field_1080));
    }
}

