/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import de.dafuqs.spectrum.energy.InkCost;
import de.dafuqs.spectrum.energy.InkPowered;
import de.dafuqs.spectrum.energy.color.InkColors;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.items.tools.MalachiteCrossbowItem;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.sound.OverchargingSoundInstance;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5328;
import org.jetbrains.annotations.Nullable;

public class GlassCrestCrossbowItem
extends MalachiteCrossbowItem {
    private static final InkCost OVERCHARGE_COST = new InkCost(InkColors.WHITE, 1000L);
    private static final int OVERCHARGE_DURATION_MAX_TICKS = 120;

    public GlassCrestCrossbowItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (user.method_5715() && GlassCrestCrossbowItem.method_7781((class_1799)itemStack) && !GlassCrestCrossbowItem.isOvercharged(itemStack) && InkPowered.tryDrainEnergy(user, OVERCHARGE_COST)) {
            if (world.field_9236) {
                this.startSoundInstance(user);
            }
            return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
        }
        return super.method_7836(world, user, hand);
    }

    @Environment(value=EnvType.CLIENT)
    public void startSoundInstance(class_1657 user) {
        class_310.method_1551().method_1483().method_4873((class_1113)new OverchargingSoundInstance(user));
    }

    public int method_7881(class_1799 stack) {
        return GlassCrestCrossbowItem.method_7781((class_1799)stack) ? 120 : super.method_7881(stack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (GlassCrestCrossbowItem.method_7781((class_1799)stack) && remainingUseTicks <= 0) {
            if (remainingUseTicks % 4 == 0) {
                world.method_43129(null, (class_1297)user, SpectrumSoundEvents.BLOCK_MOONSTONE_CLUSTER_BREAK, class_3419.field_15248, 1.0f, 1.0f);
            }
        } else {
            super.method_7852(world, user, stack, remainingUseTicks);
        }
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (GlassCrestCrossbowItem.method_7781((class_1799)stack)) {
            if (!world.field_9236 && remainingUseTicks > 0) {
                float overcharge = 1.0f - (float)remainingUseTicks / 120.0f;
                GlassCrestCrossbowItem.overcharge(stack, overcharge);
                if (user instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)user;
                    serverPlayerEntity.method_7353((class_2561)class_2561.method_43469((String)"item.spectrum.glass_crest_crossbow.message.charge", (Object[])new Object[]{Support.DF.format(overcharge * 100.0f)}), true);
                }
            }
            return;
        }
        super.method_7840(stack, world, user, remainingUseTicks);
    }

    public static boolean isOvercharged(class_1799 stack) {
        return GlassCrestCrossbowItem.getOvercharge(stack) > 0.0f;
    }

    public static float getOvercharge(class_1799 stack) {
        class_2487 compound = stack.method_7969();
        if (compound == null) {
            return 0.0f;
        }
        return compound.method_10583("Overcharged");
    }

    public static void overcharge(class_1799 stack, float percent) {
        class_2487 compound = stack.method_7948();
        compound.method_10548("Overcharged", percent);
    }

    public static void unOvercharge(class_1799 stack) {
        class_2487 compound = stack.method_7969();
        if (compound != null) {
            compound.method_10551("Overcharged");
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 itemStack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(itemStack, world, tooltip, context);
        float overcharge = GlassCrestCrossbowItem.getOvercharge(itemStack);
        if (overcharge == 0.0f) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.glass_crest_crossbow.tooltip.how_to_overcharge").method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43471((String)"spectrum.tooltip.ink_powered.white").method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.spectrum.glass_crest_crossbow.tooltip.overcharged", (Object[])new Object[]{Support.DF.format(overcharge * 100.0f)}).method_27692(class_124.field_1080));
        }
    }

    @Override
    public float getProjectileVelocityModifier(class_1799 stack) {
        float parent = super.getProjectileVelocityModifier(stack);
        float overcharge = GlassCrestCrossbowItem.getOvercharge(stack);
        return overcharge == 0.0f ? parent : parent * (1.0f + overcharge * 0.5f);
    }

    @Override
    public float getDivergenceMod(class_1799 stack) {
        float parent = super.getDivergenceMod(stack);
        float overcharge = GlassCrestCrossbowItem.getOvercharge(stack);
        return overcharge == 0.0f ? parent : parent * (1.0f - overcharge * 0.5f);
    }
}

