/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import de.dafuqs.spectrum.blocks.enchanter.ExtendedEnchantable;
import de.dafuqs.spectrum.entity.entity.BidentBaseEntity;
import de.dafuqs.spectrum.entity.entity.BidentEntity;
import de.dafuqs.spectrum.entity.entity.BidentMirrorImageEntity;
import de.dafuqs.spectrum.items.Preenchanted;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.registries.SpectrumToolMaterials;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5134;

public class MalachiteBidentItem
extends class_1835
implements Preenchanted,
ExtendedEnchantable {
    private final Multimap<class_1320, class_1322> attributeModifiers;

    public MalachiteBidentItem(class_1792.class_1793 settings, double damage) {
        super(settings);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Tool modifier", damage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Tool modifier", -2.6, class_1322.class_1323.field_6328));
        this.attributeModifiers = builder.build();
    }

    public Multimap<class_1320, class_1322> method_7844(class_1304 slot) {
        return slot == class_1304.field_6173 ? this.attributeModifiers : super.method_7844(slot);
    }

    @Override
    public Map<class_1887, Integer> getDefaultEnchantments() {
        return Map.of(class_1893.field_9106, 6);
    }

    public class_1799 method_7854() {
        return this.getDefaultEnchantedStack((class_1792)this);
    }

    public void method_7850(class_1761 group, class_2371<class_1799> stacks) {
        if (this.method_7877(group)) {
            stacks.add((Object)this.getDefaultEnchantedStack((class_1792)this));
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 handStack = user.method_5998(hand);
        if (handStack.method_7919() >= handStack.method_7936() - 1) {
            return class_1271.method_22431((Object)handStack);
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)handStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            int useTime = this.method_7881(stack) - remainingUseTicks;
            if (useTime >= 10) {
                player.method_7259(class_3468.field_15372.method_14956((Object)this));
                if (this.canStartRiptide(player, stack)) {
                    this.riptide(world, player, this.getRiptideLevel(stack));
                } else if (!world.field_9236) {
                    stack.method_7956(1, (class_1309)player, p -> p.method_20236(user.method_6058()));
                    this.throwBident(stack, (class_3218)world, player);
                }
            }
        }
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return SpectrumToolMaterials.ToolMaterial.MALACHITE.method_8023().method_8093(ingredient) || super.method_7878(stack, ingredient);
    }

    public int getRiptideLevel(class_1799 stack) {
        return class_1890.method_8202((class_1799)stack);
    }

    protected void riptide(class_1937 world, class_1657 playerEntity, int riptideLevel) {
        this.yeetPlayer(playerEntity, riptideLevel);
        playerEntity.method_40126(20);
        if (playerEntity.method_24828()) {
            playerEntity.method_5784(class_1313.field_6308, new class_243(0.0, 1.2, 0.0));
        }
        class_3414 soundEvent = riptideLevel >= 3 ? class_3417.field_14717 : (riptideLevel == 2 ? class_3417.field_14806 : class_3417.field_14606);
        world.method_43129(null, (class_1297)playerEntity, soundEvent, class_3419.field_15248, 1.0f, 1.0f);
    }

    protected void yeetPlayer(class_1657 playerEntity, float riptideLevel) {
        float f = playerEntity.method_36454();
        float g = playerEntity.method_36455();
        float h = -class_3532.method_15374((float)(f * ((float)Math.PI / 180))) * class_3532.method_15362((float)(g * ((float)Math.PI / 180)));
        float k = -class_3532.method_15374((float)(g * ((float)Math.PI / 180)));
        float l = class_3532.method_15362((float)(f * ((float)Math.PI / 180))) * class_3532.method_15362((float)(g * ((float)Math.PI / 180)));
        float m = class_3532.method_15355((float)(h * h + k * k + l * l));
        float n = 3.0f * ((1.0f + riptideLevel) / 4.0f);
        playerEntity.method_5762((double)(h *= n / m), (double)(k *= n / m), (double)(l *= n / m));
    }

    protected void throwBident(class_1799 stack, class_3218 world, class_1657 playerEntity) {
        boolean mirrorImage = this.isThrownAsMirrorImage(stack, world, playerEntity);
        BidentBaseEntity bidentBaseEntity = mirrorImage ? new BidentMirrorImageEntity((class_1937)world) : new BidentEntity((class_1937)world);
        bidentBaseEntity.setStack(stack);
        bidentBaseEntity.method_7432((class_1297)playerEntity);
        bidentBaseEntity.method_30634(playerEntity.method_23317(), playerEntity.method_23320() - 0.1, playerEntity.method_23321());
        bidentBaseEntity.method_24919((class_1297)playerEntity, playerEntity.method_36455(), playerEntity.method_36454(), 0.0f, this.getThrowSpeed(), 1.0f);
        if (!mirrorImage && playerEntity.method_31549().field_7477) {
            bidentBaseEntity.field_7572 = class_1665.class_1666.field_7594;
        }
        world.method_8649((class_1297)bidentBaseEntity);
        class_3414 soundEvent = class_3417.field_15001;
        if (mirrorImage) {
            SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity(world, bidentBaseEntity.method_19538(), (class_2394)SpectrumParticleTypes.MIRROR_IMAGE, 8, class_243.field_1353, new class_243(0.2, 0.2, 0.2));
            bidentBaseEntity.field_7572 = class_1665.class_1666.field_7592;
            soundEvent = SpectrumSoundEvents.BIDENT_MIRROR_IMAGE_THROWN;
        } else if (playerEntity.method_31549().field_7477) {
            bidentBaseEntity.field_7572 = class_1665.class_1666.field_7594;
        }
        world.method_43129(null, (class_1297)bidentBaseEntity, soundEvent, class_3419.field_15248, 1.0f, 1.0f);
        if (!playerEntity.method_31549().field_7477 && !mirrorImage) {
            playerEntity.method_31548().method_7378(stack);
        }
    }

    public float getThrowSpeed() {
        return 2.5f;
    }

    public boolean canStartRiptide(class_1657 player, class_1799 stack) {
        return this.getRiptideLevel(stack) > 0 && player.method_5721();
    }

    public boolean isThrownAsMirrorImage(class_1799 stack, class_3218 world, class_1657 player) {
        return false;
    }

    @Override
    public boolean acceptsEnchantment(class_1887 enchantment) {
        return enchantment == class_1893.field_9118 || enchantment == class_1893.field_9123 || enchantment == class_1893.field_9112 || enchantment == class_1893.field_9110 || enchantment == SpectrumEnchantments.CLOVERS_FAVOR;
    }
}

