/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import de.dafuqs.spectrum.energy.InkPowered;
import de.dafuqs.spectrum.energy.InkPoweredStatusEffectInstance;
import de.dafuqs.spectrum.items.InkPoweredPotionFillable;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import dev.emi.trinkets.api.SlotReference;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class PotionPendantItem
extends SpectrumTrinketItem
implements InkPoweredPotionFillable {
    private static final int TRIGGER_EVERY_X_TICKS = 300;
    private static final int EFFECT_DURATION = 520;
    private final int maxEffectCount;
    private final int maxAmplifier;

    public PotionPendantItem(class_1792.class_1793 settings, int maxEffectCount, int maxAmplifier, class_2960 unlockIdentifier) {
        super(settings, unlockIdentifier);
        this.maxEffectCount = maxEffectCount;
        this.maxAmplifier = maxAmplifier;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        this.appendPotionFillableTooltip(stack, tooltip, class_2561.method_43471((String)"item.spectrum.potion_pendant.when_worn"), false);
    }

    public boolean method_7886(class_1799 stack) {
        return super.method_7886(stack) || class_1844.method_8068((class_1799)stack).size() > 0;
    }

    @Override
    public int maxEffectCount() {
        return this.maxEffectCount;
    }

    @Override
    public int maxEffectAmplifier() {
        return this.maxAmplifier;
    }

    @Override
    public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.onEquip(stack, slot, entity);
        if (!entity.method_37908().field_9236 && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.grantEffects(stack, player);
        }
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.tick(stack, slot, entity);
        if (!entity.method_37908().field_9236 && entity.method_37908().method_8510() % 300L == 0L && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            this.grantEffects(stack, player);
        }
    }

    private void grantEffects(class_1799 stack, class_1657 player) {
        for (InkPoweredStatusEffectInstance inkPoweredEffect : this.getEffects(stack)) {
            if (!InkPowered.tryDrainEnergy(player, inkPoweredEffect.getInkCost())) continue;
            class_1293 effect = inkPoweredEffect.getStatusEffectInstance();
            player.method_6092(new class_1293(effect.method_5579(), 520, effect.method_5578(), effect.method_5591(), effect.method_5581(), true));
        }
    }
}

