/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.enchanter.ExtendedEnchantable;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.particle.VectorPattern;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import dev.emi.trinkets.api.SlotReference;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class TakeOffBeltItem
extends SpectrumTrinketItem
implements ExtendedEnchantable {
    public static final int CHARGE_TIME_TICKS = 20;
    public static final int MAX_CHARGES = 8;
    private static final HashMap<class_1309, Long> sneakingTimes = new HashMap();

    public TakeOffBeltItem(class_1792.class_1793 settings) {
        super(settings, SpectrumCommon.locate("unlocks/trinkets/take_off_belt"));
    }

    public static int getJumpBoostAmplifier(int sneakTime, int powerEnchantmentLevel) {
        return (int)Math.floor((double)sneakTime * (2.0 + (double)powerEnchantmentLevel * 0.5));
    }

    public static int getCurrentCharge(class_1657 playerEntity) {
        if (sneakingTimes.containsKey(playerEntity)) {
            return (int)(playerEntity.method_37908().method_8510() - sneakingTimes.get(playerEntity)) / 20;
        }
        return 0;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.take_off_belt.tooltip").method_27692(class_124.field_1080));
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.tick(stack, slot, entity);
        if (!entity.method_37908().field_9236) {
            long lastSneakingTime;
            if (entity.method_5715() && entity.method_24828()) {
                if (sneakingTimes.containsKey(entity)) {
                    long sneakTicks = entity.method_37908().method_8510() - sneakingTimes.get(entity);
                    if (sneakTicks % 20L == 0L) {
                        if (sneakTicks > 160L) {
                            entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), SpectrumSoundEvents.USE_FAIL, class_3419.field_15254, 4.0f, 1.05f);
                            SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)entity.method_37908(), entity.method_19538(), (class_2394)SpectrumParticleTypes.BLACK_CRAFTING, 20, new class_243(0.0, 0.0, 0.0), new class_243(0.1, 0.05, 0.1));
                            entity.method_6016(class_1294.field_5913);
                        } else {
                            int sneakTimeMod = (int)sneakTicks / 20;
                            entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), SpectrumSoundEvents.BLOCK_TOPAZ_BLOCK_HIT, class_3419.field_15254, 1.0f, 1.0f);
                            for (class_243 vec : VectorPattern.SIXTEEN.getVectors()) {
                                SpectrumS2CPacketSender.playParticleWithExactVelocity((class_3218)entity.method_37908(), entity.method_19538(), (class_2394)SpectrumParticleTypes.LIQUID_CRYSTAL_SPARKLE, 1, vec.method_1021(0.5));
                            }
                            int powerEnchantmentLevel = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)stack);
                            int featherFallingEnchantmentLevel = class_1890.method_8225((class_1887)class_1893.field_9129, (class_1799)stack);
                            entity.method_6092(new class_1293(class_1294.field_5913, 20, TakeOffBeltItem.getJumpBoostAmplifier(sneakTimeMod, powerEnchantmentLevel), true, false, true));
                            if (featherFallingEnchantmentLevel > 0) {
                                entity.method_6092(new class_1293(class_1294.field_5906, 20 + featherFallingEnchantmentLevel * 20, 0, true, false, true));
                            }
                        }
                    }
                } else {
                    sneakingTimes.put(entity, entity.method_37908().method_8510());
                    if (entity instanceof class_3222) {
                        class_3222 serverPlayerEntity = (class_3222)entity;
                        SpectrumS2CPacketSender.sendPlayTakeOffBeltSoundInstance(serverPlayerEntity);
                    }
                }
            } else if (entity.method_37908().method_8510() % 20L == 0L && sneakingTimes.containsKey(entity) && (lastSneakingTime = sneakingTimes.get(entity).longValue()) < entity.method_37908().method_8510() + 20L) {
                sneakingTimes.remove(entity);
            }
        }
    }

    public boolean method_7870(class_1799 stack) {
        return stack.method_7947() == 1;
    }

    public int method_7837() {
        return 8;
    }

    @Override
    public boolean acceptsEnchantment(class_1887 enchantment) {
        return enchantment == class_1893.field_9103 || enchantment == class_1893.field_9129;
    }

    public void method_7850(class_1761 group, class_2371<class_1799> stacks) {
        super.method_7850(group, stacks);
        if (this.method_7877(group)) {
            stacks.add((Object)SpectrumEnchantmentHelper.getMaxEnchantedStack(this));
        }
    }
}

