/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.items.trinkets;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.registries.SpectrumFluidTags;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import dev.emi.trinkets.api.SlotReference;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5575;
import net.minecraft.class_5762;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeepingCircletItem
extends SpectrumTrinketItem {
    private static final int TRIGGER_EVERY_X_TICKS = 40;
    private static final int EFFECT_DURATION = 50;
    private static final int HEAL_AXOLOTLS_EVERY_X_TICKS = 160;
    private static final int MAX_AXOLOTL_DISTANCE = 12;
    private static final int AXOLOTL_HEALING = 2;

    public WeepingCircletItem(class_1792.class_1793 settings) {
        super(settings, SpectrumCommon.locate("unlocks/trinkets/weeping_circlet"));
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.weeping_circlet.tooltip").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.weeping_circlet.tooltip2").method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.spectrum.weeping_circlet.tooltip3").method_27692(class_124.field_1080));
    }

    @Override
    public void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.onEquip(stack, slot, entity);
        this.doEffects(entity, true);
    }

    public void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        super.tick(stack, slot, entity);
        this.doEffects(entity, false);
    }

    private void doEffects(class_1309 entity, boolean always) {
        if (!entity.method_37908().field_9236) {
            long time = entity.method_37908().method_8510();
            if (entity.method_5777(SpectrumFluidTags.ACTIVATES_WEEPING_CIRCLET)) {
                if (always || time % 40L == 0L) {
                    entity.method_5855(entity.method_5748());
                    entity.method_6092(new class_1293(class_1294.field_5900, 50, 1, true, true));
                    entity.method_6092(new class_1293(class_1294.field_5927, 50, 0, true, true));
                }
                if ((always || time % 160L == 0L) && entity instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)entity;
                    this.healLovingAxolotls(serverPlayerEntity);
                }
            }
        }
    }

    private void healLovingAxolotls(@NotNull class_3222 entity) {
        List nearbyAxolotls = entity.method_14220().method_18023((class_5575)class_1299.field_28315, class_238.method_30048((class_243)entity.method_19538(), (double)12.0, (double)12.0, (double)12.0), class_1309::method_5805);
        for (class_5762 axolotlEntity : nearbyAxolotls) {
            if (!(axolotlEntity.method_6032() < axolotlEntity.method_6063()) || axolotlEntity.method_6478() == null || !axolotlEntity.method_6478().equals((Object)entity)) continue;
            axolotlEntity.method_6025(2.0f);
            entity.method_17356(SpectrumSoundEvents.BLOCK_CITRINE_BLOCK_CHIME, class_3419.field_15254, 1.0f, 0.9f + entity.method_14220().field_9229.method_43057() * 0.2f);
            SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)axolotlEntity.method_37908(), axolotlEntity.method_19538(), (class_2394)class_2398.field_29643, 10, new class_243(0.5, 0.5, 0.5), new class_243(0.0, 0.0, 0.0));
        }
    }
}

