/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.mixin;

import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.inventories.AutoCompactingInventory;
import de.dafuqs.spectrum.items.DamageAwareItem;
import de.dafuqs.spectrum.items.GravitableItem;
import de.dafuqs.spectrum.items.TickAwareItem;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.anvil_crushing.AnvilCrushingRecipe;
import de.dafuqs.spectrum.registries.SpectrumDamageSources;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItemStackDamageImmunities;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1542.class})
public abstract class ItemEntityMixin {
    private static AutoCompactingInventory autoCompactingInventory;

    @Shadow
    public abstract class_1799 method_6983();

    @Shadow
    public abstract void method_35190();

    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Inject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;DDD)V"})
    public void ItemEntity(class_1937 world, double x, double y, double z, class_1799 stack, double velocityX, double velocityY, double velocityZ, CallbackInfo ci) {
        if (class_1890.method_8225((class_1887)SpectrumEnchantments.STEADFAST, (class_1799)stack) > 0) {
            this.method_35190();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick()V"})
    public void tick(CallbackInfo ci) {
        class_1792 class_17922;
        class_1542 thisItemEntity = (class_1542)this;
        if (!thisItemEntity.method_5740() && thisItemEntity.field_6002.method_8510() % 8L == 0L) {
            int worldMinY = thisItemEntity.field_6002.method_8597().comp_651();
            if (!thisItemEntity.method_24828() && thisItemEntity.method_19538().method_10214() < (double)(worldMinY + 2) && class_1890.method_8225((class_1887)SpectrumEnchantments.STEADFAST, (class_1799)thisItemEntity.method_6983()) > 0) {
                if (thisItemEntity.method_19538().method_10214() < (double)(worldMinY + 1)) {
                    thisItemEntity.method_5814(thisItemEntity.method_19538().field_1352, (double)(worldMinY + 1), thisItemEntity.method_19538().field_1350);
                }
                thisItemEntity.method_18800(0.0, 0.0, 0.0);
                thisItemEntity.method_5875(true);
            }
        }
        if ((class_17922 = thisItemEntity.method_6983().method_7909()) instanceof TickAwareItem) {
            TickAwareItem tickingItem = (TickAwareItem)class_17922;
            tickingItem.onItemEntityTicked(thisItemEntity);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, cancellable=true)
    public void spectrumItemStackDamageActions(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        class_1792 class_17922;
        if (class_1282.field_5865.equals(source) || SpectrumDamageSources.FLOATBLOCK.equals(source)) {
            this.doAnvilCrafting(amount);
            callbackInfoReturnable.setReturnValue((Object)true);
        }
        if (amount > 1.0f && (class_17922 = this.method_6983().method_7909()) instanceof DamageAwareItem) {
            DamageAwareItem damageAwareItem = (DamageAwareItem)class_17922;
            damageAwareItem.onItemEntityDamaged(source, amount, (class_1542)this);
        }
    }

    private void doAnvilCrafting(float damageAmount) {
        class_1542 thisEntity = (class_1542)this;
        class_1799 thisItemStack = thisEntity.method_6983();
        class_1937 world = thisEntity.method_5770();
        if (autoCompactingInventory == null) {
            autoCompactingInventory = new AutoCompactingInventory();
        }
        autoCompactingInventory.setCompacting(AutoCompactingInventory.AutoCraftingMode.OneXOne, thisItemStack);
        Optional optionalAnvilCrushingRecipe = world.method_8433().method_8132(SpectrumRecipeTypes.ANVIL_CRUSHING, (class_1263)autoCompactingInventory, world);
        if (optionalAnvilCrushingRecipe.isPresent()) {
            AnvilCrushingRecipe recipe = (AnvilCrushingRecipe)optionalAnvilCrushingRecipe.get();
            int itemStackAmount = thisEntity.method_6983().method_7947();
            int crushingInputAmount = Math.min(itemStackAmount, (int)(recipe.getCrushedItemsPerPointOfDamage() * damageAmount));
            if (crushingInputAmount > 0) {
                class_3414 soundEvent;
                class_243 position = thisEntity.method_19538();
                class_1799 crushingOutput = recipe.method_8110();
                crushingOutput.method_7939(crushingOutput.method_7947() * crushingInputAmount);
                int remainingItemStackAmount = itemStackAmount - crushingInputAmount;
                if (remainingItemStackAmount > 0) {
                    thisItemStack.method_7939(remainingItemStackAmount);
                } else {
                    thisEntity.method_5650(class_1297.class_5529.field_26999);
                }
                class_1542 craftedEntity = new class_1542(world, position.field_1352, position.field_1351, position.field_1350, crushingOutput);
                world.method_8649((class_1297)craftedEntity);
                float craftingXPFloat = recipe.getExperience() * (float)crushingInputAmount;
                int craftingXP = Support.getIntFromDecimalWithChance(craftingXPFloat, world.field_9229);
                if (craftingXP > 0) {
                    class_1303 experienceOrbEntity = new class_1303(world, position.field_1352, position.field_1351, position.field_1350, craftingXP);
                    world.method_8649((class_1297)experienceOrbEntity);
                }
                if ((soundEvent = recipe.getSoundEvent()) != null) {
                    float randomVolume = 1.0f + world.method_8409().method_43057() * 0.2f;
                    float randomPitch = 0.9f + world.method_8409().method_43057() * 0.2f;
                    world.method_43128(null, position.field_1352, position.field_1351, position.field_1350, soundEvent, class_3419.field_15248, randomVolume, randomPitch);
                }
                SpectrumS2CPacketSender.playParticleWithExactVelocity((class_3218)world, position, recipe.getParticleEffect(), recipe.getParticleCount(), class_243.field_1353);
            }
        }
    }

    @Inject(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isDamageProof(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        boolean isImmune;
        class_1799 itemStack = ((class_1542)this).method_6983();
        if (itemStack != class_1799.field_8037 && source != class_1282.field_5849 && (isImmune = SpectrumItemStackDamageImmunities.isDamageImmune(itemStack, source))) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isFireImmune()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void isFireProof(CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        boolean isImmune;
        class_1799 itemStack = ((class_1542)this).method_6983();
        if (itemStack != class_1799.field_8037 && (isImmune = SpectrumItemStackDamageImmunities.isFireDamageImmune(itemStack))) {
            callbackInfoReturnable.setReturnValue((Object)true);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="TAIL")})
    public void doGravityEffects(CallbackInfo ci) {
        class_1542 itemEntity = (class_1542)this;
        if (itemEntity.method_5740()) {
            return;
        }
        class_1799 stack = itemEntity.method_6983();
        class_1792 item = stack.method_7909();
        if (item instanceof GravitableItem) {
            GravitableItem gravitableItem = (GravitableItem)item;
            gravitableItem.applyGravity(stack, itemEntity.field_6002, itemEntity);
        }
    }
}

