/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.mixin;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import de.dafuqs.additionalentityattributes.AdditionalEntityAttributes;
import de.dafuqs.spectrum.cca.LastKillComponent;
import de.dafuqs.spectrum.enchantments.ImprovedCriticalEnchantment;
import de.dafuqs.spectrum.entity.entity.SpectrumFishingBobberEntity;
import de.dafuqs.spectrum.helpers.SpectrumEnchantmentHelper;
import de.dafuqs.spectrum.interfaces.PlayerEntityAccessor;
import de.dafuqs.spectrum.items.ExperienceStorageItem;
import de.dafuqs.spectrum.items.trinkets.AttackRingItem;
import de.dafuqs.spectrum.items.trinkets.SpectrumTrinketItem;
import de.dafuqs.spectrum.progression.SpectrumAdvancementCriteria;
import de.dafuqs.spectrum.registries.SpectrumEnchantments;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import de.dafuqs.spectrum.status_effects.FrenzyStatusEffect;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
implements PlayerEntityAccessor {
    public SpectrumFishingBobberEntity spectrum$fishingBobber;

    @Shadow
    public abstract Iterable<class_1799> method_5877();

    @Inject(method={"onKilledOther"}, at={@At(value="HEAD")})
    private void spectrum$rememberKillOther(class_3218 world, class_1309 other, CallbackInfoReturnable<Boolean> cir) {
        class_1657 entity = (class_1657)this;
        LastKillComponent.rememberKillTick((class_1309)entity, entity.method_37908().method_8510());
        class_1293 frenzy = entity.method_6112(SpectrumStatusEffects.FRENZY);
        if (frenzy != null) {
            ((FrenzyStatusEffect)frenzy.method_5579()).onKill((class_1309)entity, frenzy.method_5578());
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;getAttributeValue(Lnet/minecraft/entity/attribute/EntityAttribute;)D")})
    protected void spectrum$calculateModifiers(class_1297 target, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        Multimap map = Multimaps.newMultimap((Map)Maps.newLinkedHashMap(), ArrayList::new);
        class_1322 jeopardantModifier = SpectrumTrinketItem.hasEquipped((class_1309)player, SpectrumItems.JEOPARDANT) ? new class_1322(AttackRingItem.ATTACK_RING_DAMAGE_UUID, "spectrum:attack_ring", AttackRingItem.getAttackModifierForEntity((class_1309)player), class_1322.class_1323.field_6331) : new class_1322(AttackRingItem.ATTACK_RING_DAMAGE_UUID, "spectrum:attack_ring", 0.0, class_1322.class_1323.field_6331);
        map.put((Object)class_5134.field_23721, (Object)jeopardantModifier);
        if (SpectrumEnchantments.IMPROVED_CRITICAL.canEntityUse((class_1297)player)) {
            int improvedCriticalLevel = SpectrumEnchantmentHelper.getUsableLevel(SpectrumEnchantments.IMPROVED_CRITICAL, player.method_6047(), (class_1297)player);
            class_1322 improvedCriticalModifier = new class_1322(ImprovedCriticalEnchantment.EXTRA_CRIT_DAMAGE_MULTIPLIER_ATTRIBUTE_UUID, "spectrum:improved_critical", (double)ImprovedCriticalEnchantment.getAddtionalCritDamageMultiplier(improvedCriticalLevel), class_1322.class_1323.field_6328);
            map.put((Object)AdditionalEntityAttributes.CRITICAL_BONUS_DAMAGE, (Object)improvedCriticalModifier);
        }
        player.method_6127().method_26854(map);
    }

    @Inject(at={@At(value="TAIL")}, method={"jump()V"})
    protected void spectrum$jumpAdvancementCriterion(CallbackInfo ci) {
        PlayerEntityMixin playerEntityMixin = this;
        if (playerEntityMixin instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)playerEntityMixin;
            SpectrumAdvancementCriteria.TAKE_OFF_BELT_JUMP.trigger(serverPlayerEntity);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"isInvulnerableTo(Lnet/minecraft/entity/damage/DamageSource;)Z"}, cancellable=true)
    public void spectrum$isInvulnerableTo(class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() && damageSource.method_5534() && SpectrumTrinketItem.hasEquipped((class_1309)((class_1657)this), SpectrumItems.ASHEN_CIRCLET)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public void setSpectrumBobber(SpectrumFishingBobberEntity bobber) {
        this.spectrum$fishingBobber = bobber;
    }

    @Override
    public SpectrumFishingBobberEntity getSpectrumBobber() {
        return this.spectrum$fishingBobber;
    }

    @Inject(at={@At(value="HEAD")}, method={"canFoodHeal()Z"}, cancellable=true)
    public void canFoodHeal(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657)this;
        if (player.method_6059(SpectrumStatusEffects.SCARRED)) {
            cir.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"addExperience(I)V"}, argsOnly=true)
    public int addExperience(int experience) {
        if (experience < 0) {
            return experience;
        }
        class_1657 player = (class_1657)this;
        for (class_1799 stack : this.method_5877()) {
            if (player.method_6115() || !(stack.method_7909() instanceof ExperienceStorageItem)) continue;
            experience = ExperienceStorageItem.addStoredExperience(stack, experience);
            player.field_7504 = 0;
            if (experience != 0) continue;
            break;
        }
        return experience;
    }

    @ModifyVariable(method={"getBlockBreakingSpeed"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;hasStatusEffect(Lnet/minecraft/entity/effect/StatusEffect;)Z"), to=@At(value="TAIL")), at=@At(value="LOAD"), ordinal=1)
    public float applyInexorableEffects(float value) {
        if (this.isInexorableActive()) {
            return 1.0f;
        }
        return value;
    }

    @ModifyReturnValue(method={"getBlockBreakingSpeed"}, at={@At(value="RETURN")})
    public float applyInexorableAntiSlowdowns(float original) {
        if (this.isInexorableActive()) {
            class_1657 player = (class_1657)this;
            float f = original;
            if (player.method_5777(class_3486.field_15517) && !class_1890.method_8200((class_1309)player)) {
                f *= 5.0f;
            }
            if (!player.method_24828()) {
                f *= 5.0f;
            }
            return f;
        }
        return original;
    }

    @Unique
    private boolean isInexorableActive() {
        class_1657 player = (class_1657)this;
        return SpectrumEnchantments.INEXORABLE.canEntityUse((class_1297)player) && class_1890.method_8225((class_1887)SpectrumEnchantments.INEXORABLE, (class_1799)player.method_5998(player.method_6058())) > 0;
    }
}

