/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.networking;

import de.dafuqs.spectrum.SpectrumClient;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.fusion_shrine.FusionShrineBlockEntity;
import de.dafuqs.spectrum.blocks.particle_spawner.ParticleSpawnerBlockEntity;
import de.dafuqs.spectrum.blocks.particle_spawner.ParticleSpawnerConfiguration;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmission;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlock;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.blocks.present.PresentBlock;
import de.dafuqs.spectrum.blocks.shooting_star.ShootingStarBlock;
import de.dafuqs.spectrum.energy.InkStorageBlockEntity;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.entity.entity.ShootingStarEntity;
import de.dafuqs.spectrum.helpers.ColorHelper;
import de.dafuqs.spectrum.helpers.ParticleHelper;
import de.dafuqs.spectrum.inventories.InkColorSelectedPacketReceiver;
import de.dafuqs.spectrum.networking.SpectrumS2CPackets;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.particle.VectorPattern;
import de.dafuqs.spectrum.particle.effect.BlockPosEventTransmissionParticleEffect;
import de.dafuqs.spectrum.particle.effect.ColoredTransmission;
import de.dafuqs.spectrum.particle.effect.ColoredTransmissionParticleEffect;
import de.dafuqs.spectrum.particle.effect.DynamicParticleEffect;
import de.dafuqs.spectrum.particle.effect.ExperienceTransmissionParticleEffect;
import de.dafuqs.spectrum.particle.effect.HummingstoneTransmissionParticleEffect;
import de.dafuqs.spectrum.particle.effect.ItemTransmissionParticleEffect;
import de.dafuqs.spectrum.particle.effect.PastelTransmissionParticleEffect;
import de.dafuqs.spectrum.particle.effect.TypedTransmission;
import de.dafuqs.spectrum.particle.effect.WirelessRedstoneTransmissionParticleEffect;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.sound.CraftingBlockSoundInstance;
import de.dafuqs.spectrum.sound.DivinitySoundInstance;
import de.dafuqs.spectrum.sound.TakeOffBeltSoundInstance;
import de.dafuqs.spectrum.spells.InkSpellEffects;
import de.dafuqs.spectrum.spells.MoonstoneStrike;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1113;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class SpectrumS2CPacketReceiver {
    public static void registerS2CReceivers() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_PARTICLE_WITH_RANDOM_OFFSET_AND_VELOCITY, (client, handler, buf, responseSender) -> {
            class_243 position = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            class_2396 particleType = (class_2396)class_2378.field_11141.method_10223(buf.method_10810());
            int amount = buf.readInt();
            class_243 randomOffset = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            class_243 randomVelocity = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            if (particleType instanceof class_2394) {
                class_2394 particleEffect = (class_2394)particleType;
                client.execute(() -> {
                    class_5819 random = client.field_1687.field_9229;
                    for (int i = 0; i < amount; ++i) {
                        double randomOffsetX = randomOffset.field_1352 - random.method_43058() * randomOffset.field_1352 * 2.0;
                        double randomOffsetY = randomOffset.field_1351 - random.method_43058() * randomOffset.field_1351 * 2.0;
                        double randomOffsetZ = randomOffset.field_1350 - random.method_43058() * randomOffset.field_1350 * 2.0;
                        double randomVelocityX = randomVelocity.field_1352 - random.method_43058() * randomVelocity.field_1352 * 2.0;
                        double randomVelocityY = randomVelocity.field_1351 - random.method_43058() * randomVelocity.field_1351 * 2.0;
                        double randomVelocityZ = randomVelocity.field_1350 - random.method_43058() * randomVelocity.field_1350 * 2.0;
                        client.field_1687.method_8406(particleEffect, position.method_10216() + randomOffsetX, position.method_10214() + randomOffsetY, position.method_10215() + randomOffsetZ, randomVelocityX, randomVelocityY, randomVelocityZ);
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_PARTICLE_WITH_EXACT_VELOCITY, (client, handler, buf, responseSender) -> {
            double posX = buf.readDouble();
            double posY = buf.readDouble();
            double posZ = buf.readDouble();
            class_2396 particleType = (class_2396)class_2378.field_11141.method_10223(buf.method_10810());
            int amount = buf.readInt();
            double velocityX = buf.readDouble();
            double velocityY = buf.readDouble();
            double velocityZ = buf.readDouble();
            if (particleType instanceof class_2394) {
                class_2394 particleEffect = (class_2394)particleType;
                client.execute(() -> {
                    for (int i = 0; i < amount; ++i) {
                        client.field_1687.method_8406(particleEffect, posX, posY, posZ, velocityX, velocityY, velocityZ);
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_PARTICLE_PACKET_WITH_PATTERN_AND_VELOCITY_ID, (client, handler, buf, responseSender) -> {
            class_243 position = new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
            class_2396 particleType = (class_2396)class_2378.field_11141.method_10223(buf.method_10810());
            VectorPattern pattern = VectorPattern.values()[buf.readInt()];
            double velocity = buf.readDouble();
            if (particleType instanceof class_2394) {
                class_2394 particleEffect = (class_2394)particleType;
                client.execute(() -> ParticleHelper.playParticleWithPatternAndVelocityClient((class_1937)client.field_1687, position, particleEffect, pattern, velocity));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.START_SKY_LERPING, (client, handler, buf, responseSender) -> {
            class_2874 dimensionType = client.field_1687.method_8597();
            long sourceTime = buf.readLong();
            long targetTime = buf.readLong();
            client.execute(() -> {
                SpectrumClient.skyLerper.trigger(dimensionType, sourceTime, client.method_1488(), targetTime);
                if (client.field_1687.method_8311(client.field_1724.method_24515())) {
                    client.field_1687.method_2947(client.field_1724.method_24515(), SpectrumSoundEvents.CELESTIAL_POCKET_WATCH_FLY_BY, class_3419.field_15254, 0.15f, 1.0f, false);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_PEDESTAL_CRAFTING_FINISHED_PARTICLE_PACKET_ID, (client, handler, buf, responseSender) -> {
            class_2338 position = buf.method_10811();
            class_1799 itemStack = buf.method_10819();
            client.execute(() -> {
                class_5819 random = client.field_1687.field_9229;
                for (int i = 0; i < 10; ++i) {
                    client.field_1687.method_8406((class_2394)new class_2392(class_2398.field_11218, itemStack), (double)position.method_10263() + 0.5, (double)(position.method_10264() + 1), (double)position.method_10260() + 0.5, 0.15 - (double)random.method_43057() * 0.3, (double)random.method_43057() * 0.15 + 0.1, 0.15 - (double)random.method_43057() * 0.3);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_SHOOTING_STAR_PARTICLES, (client, handler, buf, responseSender) -> {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            ShootingStarBlock.Type shootingStarType = ShootingStarBlock.Type.getType(buf.readInt());
            client.execute(() -> ShootingStarEntity.playHitParticles((class_1937)client.field_1687, x, y, z, shootingStarType, 25));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_FUSION_CRAFTING_IN_PROGRESS_PARTICLE_PACKET_ID, (client, handler, buf, responseSender) -> {
            class_2338 position = buf.method_10811();
            client.execute(() -> {
                class_2586 blockEntity = client.field_1687.method_8321(position);
                if (blockEntity instanceof FusionShrineBlockEntity) {
                    FusionShrineBlockEntity fusionShrineBlockEntity = (FusionShrineBlockEntity)blockEntity;
                    fusionShrineBlockEntity.spawnCraftingParticles();
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_FUSION_CRAFTING_FINISHED_PARTICLE_PACKET_ID, (client, handler, buf, responseSender) -> {
            class_2338 position = buf.method_10811();
            class_1767 dyeColor = class_1767.values()[buf.readInt()];
            client.execute(() -> {
                class_243 sourcePos = new class_243((double)position.method_10263() + 0.5, (double)(position.method_10264() + 1), (double)position.method_10260() + 0.5);
                class_1160 color = ColorHelper.getRGBVec(dyeColor);
                float velocityModifier = 0.25f;
                for (class_243 velocity : VectorPattern.SIXTEEN.getVectors()) {
                    client.field_1687.method_8406((class_2394)new DynamicParticleEffect((class_2396<?>)SpectrumParticleTypes.WHITE_CRAFTING, 0.0f, color, 1.5f, 40, false, true), sourcePos.field_1352, sourcePos.field_1351, sourcePos.field_1350, velocity.field_1352 * (double)velocityModifier, 0.0, velocity.field_1350 * (double)velocityModifier);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_MEMORY_MANIFESTING_PARTICLES, (client, handler, buf, responseSender) -> {
            class_2338 position = buf.method_10811();
            int color1 = buf.readInt();
            int color2 = buf.readInt();
            int amount = buf.readInt();
            client.execute(() -> {
                class_5819 random = client.field_1687.field_9229;
                class_1160 colorVec1 = ColorHelper.colorIntToVec(color1);
                class_1160 colorVec2 = ColorHelper.colorIntToVec(color2);
                for (int i = 0; i < amount; ++i) {
                    int randomLifetime = 30 + random.method_43048(20);
                    client.field_1687.method_8406((class_2394)new DynamicParticleEffect((class_2396<?>)SpectrumParticleTypes.WHITE_CRAFTING, 0.5f, colorVec1, 1.0f, randomLifetime, false, true), (double)position.method_10263() + 0.5, (double)position.method_10264() + 0.5, (double)position.method_10260(), 0.15 - (double)random.method_43057() * 0.3, (double)random.method_43057() * 0.15 + 0.1, 0.15 - (double)random.method_43057() * 0.3);
                    client.field_1687.method_8406((class_2394)new DynamicParticleEffect((class_2396<?>)SpectrumParticleTypes.WHITE_CRAFTING, 0.5f, colorVec2, 1.0f, randomLifetime, false, true), (double)position.method_10263() + 0.5, (double)position.method_10264(), (double)position.method_10260() + 0.5, 0.15 - (double)random.method_43057() * 0.3, (double)random.method_43057() * 0.15 + 0.1, 0.15 - (double)random.method_43057() * 0.3);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_PEDESTAL_UPGRADED_PARTICLE_PACKET_ID, (client, handler, buf, responseSender) -> {
            class_2338 position = buf.method_10811();
            PedestalRecipeTier tier = PedestalRecipeTier.values()[buf.readInt()];
            client.execute(() -> PedestalBlock.spawnUpgradeParticleEffectsForTier(position, tier));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_PEDESTAL_START_CRAFTING_PARTICLE_PACKET_ID, (client, handler, buf, responseSender) -> {
            class_2338 position = buf.method_10811();
            client.execute(() -> PedestalBlockEntity.spawnCraftingStartParticles((class_1937)client.field_1687, position));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.CHANGE_PARTICLE_SPAWNER_SETTINGS_CLIENT_PACKET_ID, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            ParticleSpawnerConfiguration configuration = ParticleSpawnerConfiguration.fromBuf(buf);
            client.execute(() -> {
                class_2586 patt10850$temp = client.field_1687.method_8321(pos);
                if (patt10850$temp instanceof ParticleSpawnerBlockEntity) {
                    ParticleSpawnerBlockEntity particleSpawnerBlockEntity = (ParticleSpawnerBlockEntity)patt10850$temp;
                    particleSpawnerBlockEntity.applySettings(configuration);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PASTEL_TRANSMISSION, (client, handler, buf, responseSender) -> {
            UUID networkUUID = buf.method_10790();
            int travelTime = buf.readInt();
            PastelTransmission transmission = PastelTransmission.fromPacket(buf);
            class_2338 spawnPos = transmission.getStartPos();
            int color = ColorHelper.getRandomColor(networkUUID.hashCode());
            client.execute(() -> client.field_1687.method_8406((class_2394)new PastelTransmissionParticleEffect(transmission.getNodePositions(), transmission.getVariant().toStack(), travelTime, color), (double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264() + 0.5, (double)spawnPos.method_10260() + 0.5, 0.0, 0.0, 0.0));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.TYPED_TRANSMISSION, (client, handler, buf, responseSender) -> {
            TypedTransmission transmission = TypedTransmission.readFromBuf(buf);
            client.execute(() -> {
                switch (transmission.getVariant()) {
                    case BLOCK_POS: {
                        client.field_1687.method_17452((class_2394)new BlockPosEventTransmissionParticleEffect(transmission.getDestination(), (Integer)transmission.getArrivalInTicks()), true, transmission.getOrigin().method_10216(), transmission.getOrigin().method_10214(), transmission.getOrigin().method_10215(), 0.0, 0.0, 0.0);
                        break;
                    }
                    case ITEM: {
                        client.field_1687.method_17452((class_2394)new ItemTransmissionParticleEffect(transmission.getDestination(), (Integer)transmission.getArrivalInTicks()), true, transmission.getOrigin().method_10216(), transmission.getOrigin().method_10214(), transmission.getOrigin().method_10215(), 0.0, 0.0, 0.0);
                        break;
                    }
                    case EXPERIENCE: {
                        client.field_1687.method_17452((class_2394)new ExperienceTransmissionParticleEffect(transmission.getDestination(), (Integer)transmission.getArrivalInTicks()), true, transmission.getOrigin().method_10216(), transmission.getOrigin().method_10214(), transmission.getOrigin().method_10215(), 0.0, 0.0, 0.0);
                        break;
                    }
                    case HUMMINGSTONE: {
                        client.field_1687.method_17452((class_2394)new HummingstoneTransmissionParticleEffect(transmission.getDestination(), (Integer)transmission.getArrivalInTicks()), true, transmission.getOrigin().method_10216(), transmission.getOrigin().method_10214(), transmission.getOrigin().method_10215(), 0.0, 0.0, 0.0);
                        break;
                    }
                    case REDSTONE: {
                        client.field_1687.method_17452((class_2394)new WirelessRedstoneTransmissionParticleEffect(transmission.getDestination(), (Integer)transmission.getArrivalInTicks()), true, transmission.getOrigin().method_10216(), transmission.getOrigin().method_10214(), transmission.getOrigin().method_10215(), 0.0, 0.0, 0.0);
                    }
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.COLOR_TRANSMISSION, (client, handler, buf, responseSender) -> {
            ColoredTransmission transmission = ColoredTransmission.readFromBuf(buf);
            client.execute(() -> client.field_1687.method_17452((class_2394)new ColoredTransmissionParticleEffect(transmission.getDestination(), (Integer)transmission.getArrivalInTicks(), transmission.getDyeColor()), true, transmission.getOrigin().method_10216(), transmission.getOrigin().method_10214(), transmission.getOrigin().method_10215(), 0.0, 0.0, 0.0));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_BLOCK_BOUND_SOUND_INSTANCE, (client, handler, buf, responseSender) -> {
            if (SpectrumCommon.CONFIG.BlockSoundVolume > 0.0f) {
                class_2960 soundEffectIdentifier = buf.method_10810();
                class_2960 blockIdentifier = buf.method_10810();
                class_2338 blockPos = buf.method_10811();
                int maxDurationTicks = buf.readInt();
                client.execute(() -> {
                    if (soundEffectIdentifier.method_12832().equals("stop")) {
                        CraftingBlockSoundInstance.stopPlayingOnPos(blockPos);
                    } else {
                        class_3414 soundEvent = (class_3414)class_2378.field_11156.method_10223(soundEffectIdentifier);
                        class_2248 block = (class_2248)class_2378.field_11146.method_10223(blockIdentifier);
                        CraftingBlockSoundInstance.startSoundInstance(soundEvent, blockPos, block, maxDurationTicks);
                    }
                });
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_TAKE_OFF_BELT_SOUND_INSTANCE, (client, handler, buf, responseSender) -> client.execute(TakeOffBeltSoundInstance::startSoundInstance));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.UPDATE_BLOCK_ENTITY_INK, (client, handler, buf, responseSender) -> {
            class_2338 blockPos = buf.method_10811();
            long colorTotal = buf.readLong();
            int colorEntries = buf.readInt();
            HashMap<InkColor, Long> colors = new HashMap<InkColor, Long>();
            for (int i = 0; i < colorEntries; ++i) {
                colors.put(InkColor.of(buf.method_19772()), buf.readLong());
            }
            client.execute(() -> {
                class_2586 blockEntity = client.field_1687.method_8321(blockPos);
                if (blockEntity instanceof InkStorageBlockEntity) {
                    InkStorageBlockEntity inkStorageBlockEntity = (InkStorageBlockEntity)blockEntity;
                    inkStorageBlockEntity.getEnergyStorage().setEnergy(colors, colorTotal);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.INK_COLOR_SELECTED, (client, handler, buf, responseSender) -> {
            class_1703 screenHandler = client.field_1724.field_7512;
            if (screenHandler instanceof InkColorSelectedPacketReceiver) {
                InkColor color;
                InkColorSelectedPacketReceiver inkColorSelectedPacketReceiver = (InkColorSelectedPacketReceiver)screenHandler;
                boolean isSelection = buf.readBoolean();
                if (isSelection) {
                    String inkColorString = buf.method_19772();
                    color = InkColor.of(inkColorString);
                } else {
                    color = null;
                }
                inkColorSelectedPacketReceiver.onInkColorSelectedPacket(color);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_INK_EFFECT_PARTICLES, (client, handler, buf, responseSender) -> {
            InkColor inkColor = InkColor.of(buf.method_19772());
            double posX = buf.readDouble();
            double posY = buf.readDouble();
            double posZ = buf.readDouble();
            float potency = buf.readFloat();
            client.execute(() -> InkSpellEffects.getEffect(inkColor).playEffects((class_1937)client.field_1687, new class_243(posX, posY, posZ), potency));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_PRESENT_OPENING_PARTICLES, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            int colorCount = buf.readInt();
            HashMap<class_1767, Integer> colors = new HashMap<class_1767, Integer>();
            for (int i = 0; i < colorCount; ++i) {
                class_1767 dyeColor = class_1767.method_7791((int)buf.readByte());
                byte amount = buf.readByte();
                colors.put(dyeColor, Integer.valueOf(amount));
            }
            client.execute(() -> PresentBlock.spawnParticles(client.field_1687, pos, (Map<class_1767, Integer>)colors));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_ASCENSION_APPLIED_EFFECTS, (client, handler, buf, responseSender) -> client.execute(() -> {
            client.field_1687.method_2947(client.field_1724.method_24515(), SpectrumSoundEvents.FADING_PLACED, class_3419.field_15248, 1.0f, 1.0f, false);
            client.method_1483().method_4873((class_1113)new DivinitySoundInstance());
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.PLAY_DIVINITY_APPLIED_EFFECTS, (client, handler, buf, responseSender) -> client.execute(() -> {
            class_746 player = client.field_1724;
            client.field_1713.method_3051((class_1297)player, (class_2394)SpectrumParticleTypes.DIVINITY, 30);
            client.field_1773.method_3189(SpectrumItems.DIVINATION_HEART.method_7854());
            client.field_1687.method_2947(player.method_24515(), SpectrumSoundEvents.FAILING_PLACED, class_3419.field_15248, 1.0f, 1.0f, false);
            ParticleHelper.playParticleWithPatternAndVelocityClient(player.field_6002, player.method_19538(), (class_2394)SpectrumParticleTypes.WHITE_CRAFTING, VectorPattern.SIXTEEN, 0.4);
            ParticleHelper.playParticleWithPatternAndVelocityClient(player.field_6002, player.method_19538(), (class_2394)SpectrumParticleTypes.RED_CRAFTING, VectorPattern.SIXTEEN, 0.4);
        }));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SpectrumS2CPackets.MOONSTONE_BLAST, (client, handler, buf, responseSender) -> {
            class_746 player = client.field_1724;
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            float power = buf.readFloat();
            float knockback = buf.readFloat();
            double playerVelocityX = buf.readDouble();
            double playerVelocityY = buf.readDouble();
            double playerVelocityZ = buf.readDouble();
            client.execute(() -> {
                MoonstoneStrike.create((class_1937)client.field_1687, null, null, x, y, z, power, knockback);
                player.method_18799(player.method_18798().method_1031(playerVelocityX, playerVelocityY, playerVelocityZ));
            });
        });
    }
}

