/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.networking;

import de.dafuqs.spectrum.blocks.memory.MemoryBlockEntity;
import de.dafuqs.spectrum.blocks.pastel_network.network.PastelTransmission;
import de.dafuqs.spectrum.blocks.pastel_network.network.ServerPastelNetwork;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.blocks.pedestal.PedestalVariant;
import de.dafuqs.spectrum.energy.InkStorage;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.entity.entity.ShootingStarEntity;
import de.dafuqs.spectrum.networking.SpectrumS2CPackets;
import de.dafuqs.spectrum.particle.VectorPattern;
import de.dafuqs.spectrum.particle.effect.ColoredTransmission;
import de.dafuqs.spectrum.particle.effect.TypedTransmission;
import de.dafuqs.spectrum.registries.color.ColorRegistry;
import de.dafuqs.spectrum.spells.MoonstoneStrike;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpectrumS2CPacketSender {
    public static void playParticleWithRandomOffsetAndVelocity(class_3218 world, class_243 position, @NotNull class_2394 particleEffect, int amount, class_243 randomOffset, class_243 randomVelocity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(position.field_1352);
        buf.writeDouble(position.field_1351);
        buf.writeDouble(position.field_1350);
        buf.method_10812(class_2378.field_11141.method_10221((Object)particleEffect.method_10295()));
        buf.writeInt(amount);
        buf.writeDouble(randomOffset.field_1352);
        buf.writeDouble(randomOffset.field_1351);
        buf.writeDouble(randomOffset.field_1350);
        buf.writeDouble(randomVelocity.field_1352);
        buf.writeDouble(randomVelocity.field_1351);
        buf.writeDouble(randomVelocity.field_1350);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)new class_2338(position))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PARTICLE_WITH_RANDOM_OFFSET_AND_VELOCITY, (class_2540)buf);
        }
    }

    public static void playParticles(class_3218 world, class_2338 position, class_2394 particleEffect, int amount) {
        SpectrumS2CPacketSender.playParticleWithExactVelocity(world, class_243.method_24953((class_2382)position), particleEffect, amount, class_243.field_1353);
    }

    public static void playParticleWithExactVelocity(class_3218 world, @NotNull class_243 position, @NotNull class_2394 particleEffect, int amount, @NotNull class_243 velocity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(position.field_1352);
        buf.writeDouble(position.field_1351);
        buf.writeDouble(position.field_1350);
        buf.method_10812(class_2378.field_11141.method_10221((Object)particleEffect.method_10295()));
        buf.writeInt(amount);
        buf.writeDouble(velocity.field_1352);
        buf.writeDouble(velocity.field_1351);
        buf.writeDouble(velocity.field_1350);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)new class_2338(position))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PARTICLE_WITH_EXACT_VELOCITY, (class_2540)buf);
        }
    }

    public static void playParticleWithPatternAndVelocity(@Nullable class_1657 notThisPlayerEntity, class_3218 world, @NotNull class_243 position, @NotNull class_2394 particleEffect, @NotNull VectorPattern pattern, double velocity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(position.field_1352);
        buf.writeDouble(position.field_1351);
        buf.writeDouble(position.field_1350);
        buf.method_10812(class_2378.field_11141.method_10221((Object)particleEffect.method_10295()));
        buf.writeInt(pattern.ordinal());
        buf.writeDouble(velocity);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)new class_2338(position))) {
            if (player.equals((Object)notThisPlayerEntity)) continue;
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PARTICLE_PACKET_WITH_PATTERN_AND_VELOCITY_ID, (class_2540)buf);
        }
    }

    public static void sendPlayPedestalCraftingFinishedParticle(class_1937 world, class_2338 blockPos, class_1799 itemStack) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        buf.method_10793(itemStack);
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PEDESTAL_CRAFTING_FINISHED_PARTICLE_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendPlayFusionCraftingInProgressParticles(class_1937 world, class_2338 blockPos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_FUSION_CRAFTING_IN_PROGRESS_PARTICLE_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendPlayFusionCraftingFinishedParticles(class_1937 world, class_2338 blockPos, @NotNull class_1799 itemStack) {
        Optional<class_1767> optionalItemColor = ColorRegistry.ITEM_COLORS.getMapping(itemStack.method_7909());
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        if (optionalItemColor.isPresent()) {
            buf.writeInt(optionalItemColor.get().ordinal());
        } else {
            buf.writeInt(class_1767.field_7967.ordinal());
        }
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_FUSION_CRAFTING_FINISHED_PARTICLE_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendPastelTransmissionParticle(ServerPastelNetwork network, int travelTime, @NotNull PastelTransmission transmission) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(network.getUUID());
        buf.writeInt(travelTime);
        PastelTransmission.writeToBuf(buf, transmission);
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)network.getWorld()), (class_2338)transmission.getStartPos())) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PASTEL_TRANSMISSION, (class_2540)buf);
        }
    }

    public static void playColorTransmissionParticle(class_3218 world, @NotNull ColoredTransmission transfer) {
        class_2338 blockPos = new class_2338(transfer.getOrigin());
        class_2540 buf = PacketByteBufs.create();
        ColoredTransmission.writeToBuf(buf, transfer);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.COLOR_TRANSMISSION, (class_2540)buf);
        }
    }

    public static void playTransmissionParticle(class_3218 world, @NotNull TypedTransmission transmission) {
        class_2338 blockPos = new class_2338(transmission.getOrigin());
        class_2540 buf = PacketByteBufs.create();
        TypedTransmission.writeToBuf(buf, transmission);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.TYPED_TRANSMISSION, (class_2540)buf);
        }
    }

    public static void sendPlayBlockBoundSoundInstance(class_3414 soundEvent, @NotNull class_3218 world, class_2338 blockPos, int maxDurationTicks) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10812(class_2378.field_11156.method_10221((Object)soundEvent));
        buf.method_10812(class_2378.field_11146.method_10221((Object)world.method_8320(blockPos).method_26204()));
        buf.method_10807(blockPos);
        buf.writeInt(maxDurationTicks);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_BLOCK_BOUND_SOUND_INSTANCE, (class_2540)buf);
        }
    }

    public static void sendPlayTakeOffBeltSoundInstance(class_3222 playerEntity) {
        class_2540 buf = PacketByteBufs.create();
        ServerPlayNetworking.send((class_3222)playerEntity, (class_2960)SpectrumS2CPackets.PLAY_TAKE_OFF_BELT_SOUND_INSTANCE, (class_2540)buf);
    }

    public static void sendCancelBlockBoundSoundInstance(@NotNull class_3218 world, class_2338 blockPos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10812(new class_2960("stop"));
        buf.method_10812(class_2378.field_11146.method_10221((Object)world.method_8320(blockPos).method_26204()));
        buf.method_10807(blockPos);
        buf.writeInt(1);
        for (class_3222 player : PlayerLookup.tracking((class_3218)world, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_BLOCK_BOUND_SOUND_INSTANCE, (class_2540)buf);
        }
    }

    public static void spawnPedestalUpgradeParticles(class_1937 world, class_2338 blockPos, @NotNull PedestalVariant newPedestalVariant) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        buf.writeInt(newPedestalVariant.getRecipeTier().ordinal());
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)world), (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PEDESTAL_UPGRADED_PARTICLE_PACKET_ID, (class_2540)buf);
        }
    }

    public static void spawnPedestalStartCraftingParticles(PedestalBlockEntity pedestalBlockEntity) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pedestalBlockEntity.method_11016());
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)pedestalBlockEntity.method_10997()), (class_2338)pedestalBlockEntity.method_11016())) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PEDESTAL_START_CRAFTING_PARTICLE_PACKET_ID, (class_2540)buf);
        }
    }

    public static void sendPlayShootingStarParticles(@NotNull ShootingStarEntity shootingStarEntity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeDouble(shootingStarEntity.method_19538().method_10216());
        buf.writeDouble(shootingStarEntity.method_19538().method_10214());
        buf.writeDouble(shootingStarEntity.method_19538().method_10215());
        buf.writeInt(shootingStarEntity.getShootingStarType().ordinal());
        for (class_3222 player : PlayerLookup.tracking((class_3218)((class_3218)shootingStarEntity.field_6002), (class_2338)shootingStarEntity.method_24515())) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_SHOOTING_STAR_PARTICLES, (class_2540)buf);
        }
    }

    public static void startSkyLerping(@NotNull class_3218 serverWorld, int additionalTime) {
        class_2540 buf = PacketByteBufs.create();
        long timeOfDay = serverWorld.method_8532();
        buf.writeLong(timeOfDay);
        buf.writeLong(timeOfDay + (long)additionalTime);
        for (class_3222 player : serverWorld.method_18456()) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.START_SKY_LERPING, (class_2540)buf);
        }
    }

    public static void playMemoryManifestingParticles(class_3218 serverWorld, @NotNull class_2338 blockPos, class_1299<?> entityType, int amount) {
        class_3545<Integer, Integer> eggColors = MemoryBlockEntity.getEggColorsForEntity(entityType);
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(blockPos);
        buf.writeInt(((Integer)eggColors.method_15442()).intValue());
        buf.writeInt(((Integer)eggColors.method_15441()).intValue());
        buf.writeInt(amount);
        for (class_3222 player : PlayerLookup.tracking((class_3218)serverWorld, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_MEMORY_MANIFESTING_PARTICLES, (class_2540)buf);
        }
    }

    public static void sendBossBarUpdatePropertiesPacket(UUID uuid, boolean serpentMusic, Collection<class_3222> players) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10797(uuid);
        buf.writeBoolean(serpentMusic);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.UPDATE_BOSS_BAR, (class_2540)buf);
        }
    }

    public static void updateBlockEntityInk(class_2338 pos, InkStorage inkStorage, class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        buf.writeLong(inkStorage.getCurrentTotal());
        Map<InkColor, Long> colors = inkStorage.getEnergy();
        buf.writeInt(colors.size());
        for (Map.Entry<InkColor, Long> color : colors.entrySet()) {
            buf.method_10814(color.getKey().toString());
            buf.writeLong(color.getValue().longValue());
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.UPDATE_BLOCK_ENTITY_INK, (class_2540)buf);
    }

    public static void sendInkColorSelected(@Nullable InkColor color, class_3222 player) {
        class_2540 packetByteBuf = PacketByteBufs.create();
        if (color == null) {
            packetByteBuf.writeBoolean(false);
        } else {
            packetByteBuf.writeBoolean(true);
            packetByteBuf.method_10814(color.toString());
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.INK_COLOR_SELECTED, (class_2540)packetByteBuf);
    }

    public static void playInkEffectParticles(class_3218 serverWorld, InkColor inkColor, class_243 effectPos, float potency) {
        class_2540 packetByteBuf = PacketByteBufs.create();
        packetByteBuf.method_10814(inkColor.toString());
        packetByteBuf.writeDouble(effectPos.field_1352);
        packetByteBuf.writeDouble(effectPos.field_1351);
        packetByteBuf.writeDouble(effectPos.field_1350);
        packetByteBuf.writeFloat(potency);
        for (class_3222 player : PlayerLookup.tracking((class_3218)serverWorld, (class_2338)new class_2338(effectPos))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_INK_EFFECT_PARTICLES, (class_2540)packetByteBuf);
        }
    }

    public static void playPresentOpeningParticles(class_3218 serverWorld, class_2338 pos, Map<class_1767, Integer> colors) {
        class_2540 packetByteBuf = PacketByteBufs.create();
        packetByteBuf.method_10807(pos);
        packetByteBuf.writeInt(colors.size());
        for (Map.Entry<class_1767, Integer> color : colors.entrySet()) {
            packetByteBuf.writeByte(color.getKey().method_7789());
            packetByteBuf.writeByte(color.getValue().intValue());
        }
        for (class_3222 player : PlayerLookup.tracking((class_3218)serverWorld, (class_2338)new class_2338((class_2382)pos))) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_PRESENT_OPENING_PARTICLES, (class_2540)packetByteBuf);
        }
    }

    public static void playAscensionAppliedEffects(class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_ASCENSION_APPLIED_EFFECTS, (class_2540)PacketByteBufs.create());
    }

    public static void playDivinityAppliedEffects(class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(player.method_5628());
        ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.PLAY_DIVINITY_APPLIED_EFFECTS, (class_2540)buf);
    }

    public static void sendMoonstoneBlast(class_3218 serverWorld, MoonstoneStrike moonstoneStrike) {
        for (class_3222 player : PlayerLookup.tracking((class_3218)serverWorld, (class_2338)new class_2338(moonstoneStrike.getX(), moonstoneStrike.getY(), moonstoneStrike.getZ()))) {
            class_243 playerVelocity = moonstoneStrike.getAffectedPlayers().getOrDefault(player, class_243.field_1353);
            class_2540 buf = PacketByteBufs.create();
            buf.writeDouble(moonstoneStrike.getX());
            buf.writeDouble(moonstoneStrike.getY());
            buf.writeDouble(moonstoneStrike.getZ());
            buf.writeFloat(moonstoneStrike.getPower());
            buf.writeFloat(moonstoneStrike.getKnockbackMod());
            buf.writeDouble(playerVelocity.field_1352);
            buf.writeDouble(playerVelocity.field_1351);
            buf.writeDouble(playerVelocity.field_1350);
            ServerPlayNetworking.send((class_3222)player, (class_2960)SpectrumS2CPackets.MOONSTONE_BLAST, (class_2540)buf);
        }
    }
}

