/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.particle.effect;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2540;

public class PastelTransmissionParticleEffect
implements class_2394 {
    public static final Codec<PastelTransmissionParticleEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)class_2338.field_25064).fieldOf("positions").forGetter(particleEffect -> particleEffect.nodePositions), (App)class_1799.field_24671.fieldOf("stack").forGetter(effect -> effect.stack), (App)Codec.INT.fieldOf("travel_time").forGetter(particleEffect -> particleEffect.travelTime), (App)Codec.INT.fieldOf("color").forGetter(particleEffect -> particleEffect.color)).apply((Applicative)instance, PastelTransmissionParticleEffect::new));
    public static final class_2394.class_2395<PastelTransmissionParticleEffect> FACTORY = new class_2394.class_2395<PastelTransmissionParticleEffect>(){

        public PastelTransmissionParticleEffect read(class_2396<PastelTransmissionParticleEffect> particleType, StringReader stringReader) throws CommandSyntaxException {
            ArrayList<class_2338> posList = new ArrayList<class_2338>();
            stringReader.expect(' ');
            int travelTime = stringReader.readInt();
            stringReader.expect(' ');
            int x1 = stringReader.readInt();
            stringReader.expect(' ');
            int y1 = stringReader.readInt();
            stringReader.expect(' ');
            int z1 = stringReader.readInt();
            stringReader.expect(' ');
            int x2 = stringReader.readInt();
            stringReader.expect(' ');
            int y2 = stringReader.readInt();
            stringReader.expect(' ');
            int z2 = stringReader.readInt();
            stringReader.expect(' ');
            int color = stringReader.readInt();
            class_2338 sourcePos = new class_2338(x1, y1, z1);
            class_2338 destinationPos = new class_2338(x2, y2, z2);
            posList.add(sourcePos);
            posList.add(destinationPos);
            return new PastelTransmissionParticleEffect(posList, class_1802.field_20391.method_7854(), travelTime, color);
        }

        public PastelTransmissionParticleEffect read(class_2396<PastelTransmissionParticleEffect> particleType, class_2540 buf) {
            int posCount = buf.readInt();
            ArrayList<class_2338> posList = new ArrayList<class_2338>();
            for (int i = 0; i < posCount; ++i) {
                posList.add(buf.method_10811());
            }
            class_1799 stack = buf.method_10819();
            int travelTime = buf.readInt();
            int color = buf.readInt();
            return new PastelTransmissionParticleEffect(posList, stack, travelTime, color);
        }
    };
    private final List<class_2338> nodePositions;
    private final class_1799 stack;
    private final int travelTime;
    private final int color;

    public PastelTransmissionParticleEffect(List<class_2338> nodePositions, class_1799 stack, Integer travelTime, Integer color) {
        this.nodePositions = nodePositions;
        this.stack = stack;
        this.travelTime = travelTime;
        this.color = color;
    }

    public class_2396<PastelTransmissionParticleEffect> method_10295() {
        return SpectrumParticleTypes.PASTEL_TRANSMISSION;
    }

    public String method_10293() {
        int nodeCount = this.nodePositions.size();
        class_2338 source = this.nodePositions.get(0);
        class_2338 destination = this.nodePositions.get(this.nodePositions.size() - 1);
        int d = source.method_10263();
        int e = source.method_10264();
        int f = source.method_10260();
        int g = destination.method_10263();
        int h = destination.method_10264();
        int i = destination.method_10260();
        return String.format(Locale.ROOT, "%s %d %d %d %d %d %d %d %d %d %d", class_2378.field_11141.method_10221(this.method_10295()), this.travelTime, nodeCount, d, e, f, g, h, i, this.color);
    }

    public void method_10294(class_2540 buf) {
        buf.writeInt(this.nodePositions.size());
        for (class_2338 pos : this.nodePositions) {
            buf.method_10807(pos);
        }
        buf.method_10793(this.stack);
        buf.writeInt(this.travelTime);
        buf.writeInt(this.color);
    }

    public List<class_2338> getNodePositions() {
        return this.nodePositions;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public int getTravelTime() {
        return this.travelTime;
    }

    public int getColor() {
        return this.color;
    }
}

