/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.predicate.world;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.predicate.world.WorldConditionPredicate;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class MoonPhasePredicate
implements WorldConditionPredicate {
    public static final MoonPhasePredicate ANY = new MoonPhasePredicate(null);
    public final Integer moonPhase;

    public MoonPhasePredicate(Integer moonPhase) {
        this.moonPhase = moonPhase;
    }

    public static MoonPhasePredicate fromJson(JsonObject json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        JsonElement jsonElement = json.get("moon_phase");
        String s = jsonElement.getAsString();
        if ("full_moon".equals(s)) {
            return new MoonPhasePredicate(0);
        }
        if ("new_moon".equals(s)) {
            return new MoonPhasePredicate(4);
        }
        return new MoonPhasePredicate(jsonElement.getAsInt());
    }

    @Override
    public boolean test(class_3218 world, class_2338 pos) {
        if (this == ANY) {
            return true;
        }
        return this.moonPhase.intValue() == world.method_30273();
    }
}

