/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.predicate.world;

import com.google.gson.JsonObject;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.predicate.world.WorldConditionPredicate;
import java.util.Locale;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class TimeOfDayPredicate
implements WorldConditionPredicate {
    public static final TimeOfDayPredicate ANY = new TimeOfDayPredicate(null);
    public final TimeHelper.TimeOfDay timeOfDay;

    public TimeOfDayPredicate(TimeHelper.TimeOfDay timeOfDay) {
        this.timeOfDay = timeOfDay;
    }

    public static TimeOfDayPredicate fromJson(JsonObject json) {
        if (json == null || json.isJsonNull()) {
            return ANY;
        }
        return new TimeOfDayPredicate(TimeHelper.TimeOfDay.valueOf(json.get("time").getAsString().toUpperCase(Locale.ROOT)));
    }

    @Override
    public boolean test(class_3218 world, class_2338 pos) {
        if (this == ANY) {
            return true;
        }
        TimeHelper.TimeOfDay worldTimeOfDay = TimeHelper.getTimeOfDay((class_1937)world);
        switch (this.timeOfDay) {
            case DAY: {
                return worldTimeOfDay.isDay();
            }
            case NIGHT: {
                return worldTimeOfDay.isNight();
            }
        }
        return this.timeOfDay == worldTimeOfDay;
    }
}

