/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.predicate.world;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.dafuqs.spectrum.predicate.world.CommandPredicate;
import de.dafuqs.spectrum.predicate.world.DimensionPredicate;
import de.dafuqs.spectrum.predicate.world.MoonPhasePredicate;
import de.dafuqs.spectrum.predicate.world.TimeOfDayPredicate;
import de.dafuqs.spectrum.predicate.world.WeatherPredicate;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public interface WorldConditionPredicate {
    public static final WorldConditionPredicate ANY = (world, pos) -> true;

    public static Deserializer register(String id, Deserializer deserializer) {
        Deserializers.TYPES.put(id, deserializer);
        return deserializer;
    }

    public static WorldConditionPredicate fromJson(@Nullable JsonElement json) {
        if (json instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)json;
            String string = class_3518.method_15253((JsonObject)jsonObject, (String)"type", null);
            if (string == null) {
                return ANY;
            }
            Deserializer deserializer = Deserializers.TYPES.get(string);
            if (deserializer == null) {
                throw new JsonSyntaxException("Unknown sub-predicate type: " + string);
            }
            return deserializer.deserialize(jsonObject);
        }
        return ANY;
    }

    public boolean test(class_3218 var1, class_2338 var2);

    public static final class Deserializers {
        public static final Map<String, Deserializer> TYPES = new HashMap<String, Deserializer>();
        public static final Deserializer ANY = WorldConditionPredicate.register("any", json -> ANY);
        public static final Deserializer DIMENSION = WorldConditionPredicate.register("dimension", DimensionPredicate::fromJson);
        public static final Deserializer MOON_PHASE = WorldConditionPredicate.register("moon_phase", MoonPhasePredicate::fromJson);
        public static final Deserializer TIME_OF_DAY = WorldConditionPredicate.register("time_of_day", TimeOfDayPredicate::fromJson);
        public static final Deserializer WEATHER = WorldConditionPredicate.register("weather", WeatherPredicate::fromJson);
        public static final Deserializer COMMAND = WorldConditionPredicate.register("command", CommandPredicate::fromJson);
    }

    public static interface Deserializer {
        public WorldConditionPredicate deserialize(JsonObject var1);
    }
}

