/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.progression.advancement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.items.InkPoweredPotionFillable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_2096;
import net.minecraft.class_2102;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5257;
import net.minecraft.class_5267;

public class PotionWorkshopBrewingCriterion
extends class_4558<Conditions> {
    static final class_2960 ID = SpectrumCommon.locate("potion_workshop_brewing");

    public static Conditions create(class_2073 itemPredicate, class_2102 effectsPredicate, class_2096.class_2100 brewedCountRange, class_2096.class_2100 maxAmplifierRange, class_2096.class_2100 maxDurationRange, class_2096.class_2100 effectCountRange, class_2096.class_2100 uniqueEffectCountRange) {
        return new Conditions(class_2048.class_5258.field_24388, itemPredicate, effectsPredicate, brewedCountRange, maxAmplifierRange, maxDurationRange, effectCountRange, uniqueEffectCountRange);
    }

    public class_2960 method_794() {
        return ID;
    }

    public Conditions conditionsFromJson(JsonObject jsonObject, class_2048.class_5258 extended, class_5257 advancementEntityPredicateDeserializer) {
        class_2073 itemPredicate = class_2073.method_8969((JsonElement)jsonObject.get("item"));
        class_2102 statusEffectsPredicate = class_2102.method_9064((JsonElement)jsonObject.get("effects"));
        class_2096.class_2100 brewedCountRange = class_2096.class_2100.method_9056((JsonElement)jsonObject.get("brewed_count"));
        class_2096.class_2100 maxAmplifierRange = class_2096.class_2100.method_9056((JsonElement)jsonObject.get("highest_amplifier"));
        class_2096.class_2100 maxDurationRange = class_2096.class_2100.method_9056((JsonElement)jsonObject.get("longest_duration"));
        class_2096.class_2100 effectCountRange = class_2096.class_2100.method_9056((JsonElement)jsonObject.get("effect_count"));
        class_2096.class_2100 uniqueEffectCountRange = class_2096.class_2100.method_9056((JsonElement)jsonObject.get("unique_effect_count"));
        return new Conditions(extended, itemPredicate, statusEffectsPredicate, brewedCountRange, maxAmplifierRange, maxDurationRange, effectCountRange, uniqueEffectCountRange);
    }

    public void trigger(class_3222 player, class_1799 itemStack, int brewedCount) {
        this.method_22510(player, conditions -> {
            List<class_1293> effects;
            class_1792 patt2743$temp = itemStack.method_7909();
            if (patt2743$temp instanceof InkPoweredPotionFillable) {
                InkPoweredPotionFillable inkPoweredPotionFillable = (InkPoweredPotionFillable)patt2743$temp;
                effects = inkPoweredPotionFillable.getVanillaEffects(itemStack);
            } else {
                effects = class_1844.method_8067((class_1799)itemStack);
            }
            int highestAmplifier = 0;
            int longestDuration = 0;
            for (class_1293 instance : effects) {
                if (instance.method_5578() > highestAmplifier) {
                    highestAmplifier = instance.method_5578();
                }
                if (instance.method_5584() <= longestDuration) continue;
                longestDuration = instance.method_5584();
            }
            ArrayList<class_1291> uniqueEffects = new ArrayList<class_1291>();
            for (class_1293 instance : effects) {
                if (uniqueEffects.contains(instance.method_5579())) continue;
                uniqueEffects.add(instance.method_5579());
            }
            return conditions.matches(itemStack, effects, brewedCount, highestAmplifier, longestDuration, effects.size(), uniqueEffects.size());
        });
    }

    public static class Conditions
    extends class_195 {
        private final class_2073 itemPredicate;
        private final class_2102 statusEffectsPredicate;
        private final class_2096.class_2100 brewedCountRange;
        private final class_2096.class_2100 highestEffectAmplifierRange;
        private final class_2096.class_2100 longestEffectDurationRange;
        private final class_2096.class_2100 effectCountRange;
        private final class_2096.class_2100 uniqueEffectCountRange;

        public Conditions(class_2048.class_5258 player, class_2073 itemPredicate, class_2102 statusEffectsPredicate, class_2096.class_2100 brewedCountRange, class_2096.class_2100 highestEffectAmplifierRange, class_2096.class_2100 longestEffectDurationRange, class_2096.class_2100 effectCountRange, class_2096.class_2100 uniqueEffectCountRange) {
            super(ID, player);
            this.itemPredicate = itemPredicate;
            this.statusEffectsPredicate = statusEffectsPredicate;
            this.brewedCountRange = brewedCountRange;
            this.highestEffectAmplifierRange = highestEffectAmplifierRange;
            this.longestEffectDurationRange = longestEffectDurationRange;
            this.effectCountRange = effectCountRange;
            this.uniqueEffectCountRange = uniqueEffectCountRange;
        }

        public JsonObject method_807(class_5267 predicateSerializer) {
            JsonObject jsonObject = super.method_807(predicateSerializer);
            jsonObject.add("items", this.itemPredicate.method_8971());
            jsonObject.add("effects", this.statusEffectsPredicate.method_9068());
            jsonObject.add("brewed_count", this.brewedCountRange.method_9036());
            jsonObject.add("highest_amplifier", this.highestEffectAmplifierRange.method_9036());
            jsonObject.add("longest_duration", this.longestEffectDurationRange.method_9036());
            jsonObject.add("effect_count", this.effectCountRange.method_9036());
            jsonObject.add("unique_effect_count", this.uniqueEffectCountRange.method_9036());
            return jsonObject;
        }

        public boolean matches(class_1799 stack, List<class_1293> effects, int brewedCount, int maxAmplifier, int maxDuration, int effectCount, int uniqueEffectCount) {
            if (this.brewedCountRange.method_9054(brewedCount) && this.highestEffectAmplifierRange.method_9054(maxAmplifier) && this.longestEffectDurationRange.method_9054(maxDuration) && this.effectCountRange.method_9054(effectCount) && this.uniqueEffectCountRange.method_9054(uniqueEffectCount) && this.itemPredicate.method_8970(stack)) {
                HashMap<class_1291, class_1293> effectMap = new HashMap<class_1291, class_1293>();
                for (class_1293 instance : effects) {
                    if (effectMap.containsKey(instance.method_5579())) continue;
                    effectMap.put(instance.method_5579(), instance);
                }
                return this.statusEffectsPredicate.method_9063(effectMap);
            }
            return false;
        }
    }
}

