/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.enchantment_upgrade;

import de.dafuqs.spectrum.items.ExperienceStorageItem;
import de.dafuqs.spectrum.recipe.GatedSpectrumRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.enchanter.EnchanterRecipe;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3956;

public class EnchantmentUpgradeRecipe
extends GatedSpectrumRecipe {
    protected final class_1887 enchantment;
    protected final int enchantmentDestinationLevel;
    protected final int requiredExperience;
    protected final class_1792 requiredItem;
    protected final int requiredItemCount;
    protected final class_2371<class_1856> inputs;
    protected final class_1799 output;

    public EnchantmentUpgradeRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, class_1887 enchantment, int enchantmentDestinationLevel, int requiredExperience, class_1792 requiredItem, int requiredItemCount) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.enchantment = enchantment;
        this.enchantmentDestinationLevel = enchantmentDestinationLevel;
        this.requiredExperience = requiredExperience;
        this.requiredItem = requiredItem;
        this.requiredItemCount = requiredItemCount;
        class_2371 inputs = class_2371.method_10213((int)2, (Object)class_1856.field_9017);
        class_1799 ingredientStack = new class_1799((class_1935)class_1802.field_8598);
        class_1772.method_7807((class_1799)ingredientStack, (class_1889)new class_1889(enchantment, enchantmentDestinationLevel - 1));
        inputs.set(0, (Object)class_1856.method_8101((class_1799[])new class_1799[]{ingredientStack}));
        inputs.set(1, (Object)class_1856.method_8101((class_1799[])new class_1799[]{new class_1799((class_1935)requiredItem)}));
        this.inputs = inputs;
        class_1799 outputStack = new class_1799((class_1935)class_1802.field_8598);
        class_1772.method_7807((class_1799)outputStack, (class_1889)new class_1889(enchantment, enchantmentDestinationLevel));
        this.output = outputStack;
    }

    public boolean method_8115(class_1263 inv, class_1937 world) {
        if (inv.method_5439() > 9) {
            if (!((class_1856)this.inputs.get(0)).method_8093(inv.method_5438(0))) {
                return false;
            }
            Map enchantments = class_1890.method_8222((class_1799)inv.method_5438(0));
            if (!enchantments.containsKey(this.enchantment) || (Integer)enchantments.get(this.enchantment) != this.enchantmentDestinationLevel - 1) {
                return false;
            }
            if (!(this.getRequiredExperience() <= 0 || inv.method_5438(1).method_7909() instanceof ExperienceStorageItem && ExperienceStorageItem.getStoredExperience(inv.method_5438(1)) >= this.getRequiredExperience())) {
                return false;
            }
            class_1856 inputIngredient = (class_1856)this.inputs.get(1);
            int ingredientsFound = 0;
            for (int i = 1; i < 9; ++i) {
                class_1799 currentStack = inv.method_5438(i + 1);
                if (currentStack.method_7960()) continue;
                class_1799 slotStack = inv.method_5438(i + 1);
                if (inputIngredient.method_8093(slotStack)) {
                    ingredientsFound += slotStack.method_7947();
                    continue;
                }
                return false;
            }
            return ingredientsFound >= this.requiredItemCount;
        }
        return false;
    }

    public class_1799 method_8116(class_1263 inv) {
        return null;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.ENCHANTER);
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.ENCHANTMENT_UPGRADE_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.ENCHANTMENT_UPGRADE;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return EnchanterRecipe.UNLOCK_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "enchantment_upgrade";
    }

    public class_2371<class_1856> method_8117() {
        return this.inputs;
    }

    public int getRequiredExperience() {
        return this.requiredExperience;
    }

    public class_1792 getRequiredItem() {
        return this.requiredItem;
    }

    public int getRequiredItemCount() {
        return this.requiredItemCount;
    }

    public class_1887 getEnchantment() {
        return this.enchantment;
    }

    public int getEnchantmentDestinationLevel() {
        return this.enchantmentDestinationLevel;
    }

    public boolean requiresUnlockedOverEnchanting() {
        return this.enchantmentDestinationLevel > this.enchantment.method_8183();
    }
}

