/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.pedestal;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockItem;
import de.dafuqs.spectrum.blocks.pedestal.PedestalVariant;
import de.dafuqs.spectrum.blocks.upgrade.Upgradeable;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.recipe.GatedStackSpectrumRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.recipe.pedestal.color.BuiltinGemstoneColor;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3956;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public abstract class PedestalRecipe
extends GatedStackSpectrumRecipe {
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("place_pedestal");
    public static final int[] CRAFTING_GRID_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    protected final PedestalRecipeTier tier;
    protected final List<IngredientStack> inputs;
    protected final Map<BuiltinGemstoneColor, Integer> powderInputs;
    protected final class_1799 output;
    protected final float experience;
    protected final int craftingTime;
    protected final boolean skipRecipeRemainders;
    protected final boolean noBenefitsFromYieldUpgrades;

    public PedestalRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, PedestalRecipeTier tier, List<IngredientStack> inputs, Map<BuiltinGemstoneColor, Integer> powderInputs, class_1799 output, float experience, int craftingTime, boolean skipRecipeRemainders, boolean noBenefitsFromYieldUpgrades) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.tier = tier;
        this.inputs = inputs;
        this.powderInputs = powderInputs;
        this.output = output;
        this.experience = experience;
        this.craftingTime = craftingTime;
        this.skipRecipeRemainders = skipRecipeRemainders;
        this.noBenefitsFromYieldUpgrades = noBenefitsFromYieldUpgrades;
        this.registerInToastManager(this.method_17716(), this);
    }

    @Nullable
    public static PedestalVariant getUpgradedPedestalVariantForOutput(class_1799 outputItemStack) {
        class_1792 class_17922 = outputItemStack.method_7909();
        if (class_17922 instanceof PedestalBlockItem) {
            PedestalBlockItem pedestalBlockItem = (PedestalBlockItem)class_17922;
            return pedestalBlockItem.getVariant();
        }
        return null;
    }

    public boolean method_8115(class_1263 inv, class_1937 world) {
        return this.enoughPowderPresent(inv);
    }

    protected boolean enoughPowderPresent(class_1263 inventory) {
        int topazPowderAmount = this.powderInputs.getOrDefault(BuiltinGemstoneColor.CYAN, 0);
        int amethystPowderAmount = this.powderInputs.getOrDefault(BuiltinGemstoneColor.MAGENTA, 0);
        int citrinePowderAmount = this.powderInputs.getOrDefault(BuiltinGemstoneColor.YELLOW, 0);
        int onyxPowderAmount = this.powderInputs.getOrDefault(BuiltinGemstoneColor.BLACK, 0);
        int moonstonePowderAmount = this.powderInputs.getOrDefault(BuiltinGemstoneColor.WHITE, 0);
        return !(topazPowderAmount != 0 && !this.isStackAtLeast(inventory.method_5438(9), SpectrumItems.TOPAZ_POWDER, topazPowderAmount) || amethystPowderAmount != 0 && !this.isStackAtLeast(inventory.method_5438(10), SpectrumItems.AMETHYST_POWDER, amethystPowderAmount) || citrinePowderAmount != 0 && !this.isStackAtLeast(inventory.method_5438(11), SpectrumItems.CITRINE_POWDER, citrinePowderAmount) || onyxPowderAmount != 0 && !this.isStackAtLeast(inventory.method_5438(12), SpectrumItems.ONYX_POWDER, onyxPowderAmount) || moonstonePowderAmount != 0 && !this.isStackAtLeast(inventory.method_5438(13), SpectrumItems.MOONSTONE_POWDER, moonstonePowderAmount));
    }

    private boolean isStackAtLeast(class_1799 sourceItemStack, class_1792 item, int amount) {
        return sourceItemStack.method_7909().equals(item) && sourceItemStack.method_7947() >= amount;
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        return this.inputs;
    }

    public class_1799 method_8116(class_1263 inv) {
        return this.method_8110().method_7972();
    }

    public PedestalRecipeTier getTier() {
        return this.tier;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)SpectrumBlocks.PEDESTAL_BASIC_AMETHYST);
    }

    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.PEDESTAL;
    }

    public int getGemstonePowderAmount(BuiltinGemstoneColor gemstoneColor) {
        return this.powderInputs.getOrDefault(gemstoneColor, 0);
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public float getExperience() {
        return this.experience;
    }

    public Map<BuiltinGemstoneColor, Integer> getPowderInputs() {
        return this.powderInputs;
    }

    public class_3414 getSoundEvent(class_5819 random) {
        int i;
        ArrayList<class_3414> choices = new ArrayList<class_3414>();
        for (i = 0; i < this.powderInputs.getOrDefault(BuiltinGemstoneColor.MAGENTA, 0); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_AMETHYST);
        }
        for (i = 0; i < this.powderInputs.getOrDefault(BuiltinGemstoneColor.YELLOW, 0); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_CITRINE);
        }
        for (i = 0; i < this.powderInputs.getOrDefault(BuiltinGemstoneColor.CYAN, 0); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_TOPAZ);
        }
        for (i = 0; i < this.powderInputs.getOrDefault(BuiltinGemstoneColor.BLACK, 0); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_ONYX);
        }
        for (i = 0; i < this.powderInputs.getOrDefault(BuiltinGemstoneColor.WHITE, 0); ++i) {
            choices.add(SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_MOONSTONE);
        }
        if (choices.size() == 0) {
            return SpectrumSoundEvents.PEDESTAL_CRAFTING_FINISHED_GENERIC;
        }
        return (class_3414)choices.get(random.method_43048(choices.size()));
    }

    public void consumeIngredients(PedestalBlockEntity pedestal) {
        for (BuiltinGemstoneColor gemstoneColor : BuiltinGemstoneColor.values()) {
            double efficiencyModifier = pedestal.getUpgradeHolder().getEffectiveValue(Upgradeable.UpgradeType.EFFICIENCY);
            int gemstonePowderAmount = this.getGemstonePowderAmount(gemstoneColor);
            int gemstonePowderAmountAfterMod = Support.getIntFromDecimalWithChance((double)gemstonePowderAmount / efficiencyModifier, pedestal.method_10997().field_9229);
            pedestal.method_5438(PedestalBlockEntity.getSlotForGemstonePowder(gemstoneColor)).method_7934(gemstonePowderAmountAfterMod);
        }
    }

    protected void decrementGridSlot(PedestalBlockEntity pedestal, int slot, int count, class_1799 invStack) {
        class_1799 remainder;
        class_1799 class_17992 = remainder = this.skipRecipeRemainders() ? class_1799.field_8037 : invStack.getRecipeRemainder();
        if (remainder.method_7960()) {
            invStack.method_7934(count);
        } else if (pedestal.method_5438(slot).method_7947() == count) {
            remainder.method_7939(count);
            pedestal.method_5447(slot, remainder);
        } else {
            pedestal.method_5438(slot).method_7934(count);
            class_1542 itemEntity = new class_1542(pedestal.method_10997(), (double)pedestal.method_11016().method_10263() + 0.5, (double)(pedestal.method_11016().method_10264() + 1), (double)pedestal.method_11016().method_10260() + 0.5, remainder);
            itemEntity.method_5762(0.0, 0.05, 0.0);
            pedestal.method_10997().method_8649((class_1297)itemEntity);
        }
    }

    public boolean canCraft(PedestalBlockEntity pedestalBlockEntity) {
        class_1657 playerEntity = pedestalBlockEntity.getOwnerIfOnline();
        if (playerEntity == null || !this.canPlayerCraft(playerEntity)) {
            return false;
        }
        @Nullable PedestalVariant newPedestalVariant = PedestalRecipe.getUpgradedPedestalVariantForOutput(this.output);
        if (newPedestalVariant == null) {
            return pedestalBlockEntity.getHighestAvailableRecipeTier().ordinal() >= this.tier.ordinal();
        }
        int currentTier = PedestalBlockEntity.getVariant(pedestalBlockEntity).getRecipeTier().ordinal();
        int thisTier = newPedestalVariant.getRecipeTier().ordinal();
        return thisTier == currentTier + 1;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return UNLOCK_IDENTIFIER;
    }

    @Override
    public boolean canPlayerCraft(class_1657 playerEntity) {
        return this.tier.hasUnlocked(playerEntity) && AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)this.requiredAdvancementIdentifier);
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "pedestal";
    }

    public boolean areYieldUpgradesDisabled() {
        return this.noBenefitsFromYieldUpgrades;
    }

    public boolean skipRecipeRemainders() {
        return this.skipRecipeRemainders;
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    public boolean isShapeless() {
        return true;
    }

    public int getGridSlotId(int index) {
        int width = this.getWidth();
        int x = index % width;
        int y = (index - x) / width;
        return 3 * y + x;
    }
}

