/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.pedestal;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.recipe.pedestal.color.BuiltinGemstoneColor;
import de.dafuqs.spectrum.recipe.pedestal.color.GemstoneColor;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public enum PedestalRecipeTier {
    BASIC(SpectrumCommon.locate("place_pedestal"), new GemstoneColor[]{BuiltinGemstoneColor.CYAN, BuiltinGemstoneColor.MAGENTA, BuiltinGemstoneColor.YELLOW}),
    SIMPLE(SpectrumCommon.locate("build_basic_pedestal_structure"), new GemstoneColor[]{BuiltinGemstoneColor.CYAN, BuiltinGemstoneColor.MAGENTA, BuiltinGemstoneColor.YELLOW}),
    ADVANCED(SpectrumCommon.locate("midgame/build_advanced_pedestal_structure"), new GemstoneColor[]{BuiltinGemstoneColor.CYAN, BuiltinGemstoneColor.MAGENTA, BuiltinGemstoneColor.YELLOW, BuiltinGemstoneColor.BLACK}),
    COMPLEX(SpectrumCommon.locate("lategame/build_complex_pedestal_structure"), BuiltinGemstoneColor.values());

    private final class_2960 unlockAdvancementId;
    private final GemstoneColor[] gemstoneColors;

    private PedestalRecipeTier(class_2960 unlockAdvancementId, GemstoneColor[] gemstoneColors) {
        this.unlockAdvancementId = unlockAdvancementId;
        this.gemstoneColors = gemstoneColors;
    }

    @Contract(pure=true)
    public int getPowderSlotCount() {
        return this.gemstoneColors.length;
    }

    @Contract(pure=true)
    public GemstoneColor[] getAvailableGemstoneColors() {
        return this.gemstoneColors;
    }

    @Contract(pure=true)
    public static Optional<PedestalRecipeTier> getHighestUnlockedRecipeTier(class_1657 playerEntity) {
        if (AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)PedestalRecipeTier.COMPLEX.unlockAdvancementId)) {
            return Optional.of(COMPLEX);
        }
        if (AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)PedestalRecipeTier.ADVANCED.unlockAdvancementId)) {
            return Optional.of(ADVANCED);
        }
        if (AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)PedestalRecipeTier.SIMPLE.unlockAdvancementId)) {
            return Optional.of(SIMPLE);
        }
        if (AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)PedestalRecipeTier.BASIC.unlockAdvancementId)) {
            return Optional.of(BASIC);
        }
        return Optional.empty();
    }

    public boolean hasUnlocked(class_1657 playerEntity) {
        return AdvancementHelper.hasAdvancement((class_1657)playerEntity, (class_2960)this.unlockAdvancementId);
    }

    public static Optional<PedestalRecipeTier> hasJustUnlockedANewRecipeTier(@NotNull class_2960 advancementIdentifier) {
        if (advancementIdentifier.equals((Object)PedestalRecipeTier.BASIC.unlockAdvancementId)) {
            return Optional.of(BASIC);
        }
        if (advancementIdentifier.equals((Object)PedestalRecipeTier.SIMPLE.unlockAdvancementId)) {
            return Optional.of(SIMPLE);
        }
        if (advancementIdentifier.equals((Object)PedestalRecipeTier.ADVANCED.unlockAdvancementId)) {
            return Optional.of(ADVANCED);
        }
        if (advancementIdentifier.equals((Object)PedestalRecipeTier.COMPLEX.unlockAdvancementId)) {
            return Optional.of(COMPLEX);
        }
        return Optional.empty();
    }
}

