/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.pedestal;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.blocks.pedestal.PedestalBlockEntity;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.recipe.pedestal.color.BuiltinGemstoneColor;
import java.util.List;
import java.util.Map;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import oshi.util.tuples.Triplet;

public class ShapedPedestalRecipe
extends PedestalRecipe {
    protected final int width;
    protected final int height;

    public ShapedPedestalRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, PedestalRecipeTier tier, int width, int height, List<IngredientStack> inputs, Map<BuiltinGemstoneColor, Integer> gemstonePowderInputs, class_1799 output, float experience, int craftingTime, boolean skipRecipeRemainders, boolean noBenefitsFromYieldUpgrades) {
        super(id, group, secret, requiredAdvancementIdentifier, tier, inputs, gemstonePowderInputs, output, experience, craftingTime, skipRecipeRemainders, noBenefitsFromYieldUpgrades);
        this.width = width;
        this.height = height;
    }

    @Override
    public boolean method_8115(class_1263 inv, class_1937 world) {
        return this.getRecipeOrientation(inv) != null && super.method_8115(inv, world);
    }

    public Triplet<Integer, Integer, Boolean> getRecipeOrientation(class_1263 inv) {
        for (int i = 0; i <= 3 - this.width; ++i) {
            for (int j = 0; j <= 3 - this.height; ++j) {
                if (this.matchesPattern(inv, i, j, true)) {
                    return new Triplet((Object)i, (Object)j, (Object)true);
                }
                if (!this.matchesPattern(inv, i, j, false)) continue;
                return new Triplet((Object)i, (Object)j, (Object)false);
            }
        }
        return null;
    }

    public boolean matchesPattern(class_1263 inv, int offsetX, int offsetY, boolean flipped) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int k = i - offsetX;
                int l = j - offsetY;
                IngredientStack ingredient = IngredientStack.EMPTY;
                if (k >= 0 && l >= 0 && k < this.width && l < this.height) {
                    ingredient = flipped ? (IngredientStack)this.inputs.get(this.width - k - 1 + l * this.width) : (IngredientStack)this.inputs.get(k + l * this.width);
                }
                if (ingredient.test(inv.method_5438(i + j * 3))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void consumeIngredients(PedestalBlockEntity pedestal) {
        super.consumeIngredients(pedestal);
        Triplet<Integer, Integer, Boolean> orientation = this.getRecipeOrientation((class_1263)pedestal);
        if (orientation == null) {
            return;
        }
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                class_1799 slotStack;
                int ingredientStackId = (Boolean)orientation.getC() != false ? this.width - 1 - x + this.width * y : x + this.width * y;
                int slot = x + (Integer)orientation.getA() + 3 * (y + (Integer)orientation.getB());
                IngredientStack ingredientStackAtPos = (IngredientStack)this.inputs.get(ingredientStackId);
                if (!ingredientStackAtPos.test(slotStack = pedestal.method_5438(slot))) {
                    SpectrumCommon.logError("Looks like DaFuqs fucked up Spectrums Pedestal recipe matching. Go open up a report with the recipe that was crafted and an image of the pedestals contents, please! :)");
                }
                if (slotStack.method_7960()) continue;
                this.decrementGridSlot(pedestal, slot, ingredientStackAtPos.getCount(), slotStack);
            }
        }
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.SHAPED_PEDESTAL_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.PEDESTAL;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isShapeless() {
        return false;
    }
}

