/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.pedestal;

import com.google.gson.JsonObject;
import de.dafuqs.spectrum.mixin.accessors.ShapedRecipeAccessor;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeSerializer;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import de.dafuqs.spectrum.recipe.pedestal.ShapedPedestalRecipe;
import de.dafuqs.spectrum.recipe.pedestal.color.BuiltinGemstoneColor;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ShapedPedestalRecipeSerializer
extends PedestalRecipeSerializer<ShapedPedestalRecipe> {
    public final RecipeFactory recipeFactory;

    public ShapedPedestalRecipeSerializer(RecipeFactory recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public ShapedPedestalRecipe read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        class_1799 output = RecipeUtils.itemStackWithNbtFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
        PedestalRecipeTier tier = PedestalRecipeTier.valueOf(class_3518.method_15253((JsonObject)jsonObject, (String)"tier", (String)"basic").toUpperCase(Locale.ROOT));
        float experience = class_3518.method_15277((JsonObject)jsonObject, (String)"experience", (float)0.0f);
        int craftingTime = class_3518.method_15282((JsonObject)jsonObject, (String)"time", (int)200);
        boolean noBenefitsFromYieldUpgrades = class_3518.method_15258((JsonObject)jsonObject, (String)"disable_yield_upgrades", (boolean)false);
        Map<BuiltinGemstoneColor, Integer> gemInputs = ShapedPedestalRecipeSerializer.readGemstonePowderInputs(jsonObject);
        boolean skipRecipeRemainders = false;
        if (class_3518.method_15254((JsonObject)jsonObject, (String)"skip_recipe_remainders")) {
            skipRecipeRemainders = class_3518.method_15258((JsonObject)jsonObject, (String)"skip_recipe_remainders", (boolean)false);
        }
        Map<String, IngredientStack> inputMap = RecipeUtils.readIngredientStackSymbols(class_3518.method_15296((JsonObject)jsonObject, (String)"key"));
        String[] strings = ShapedRecipeAccessor.invokeRemovePadding(ShapedRecipeAccessor.invokeGetPattern(class_3518.method_15261((JsonObject)jsonObject, (String)"pattern")));
        int height = strings.length;
        int width = strings[0].length();
        List<IngredientStack> inputs = RecipeUtils.createIngredientStackPatternMatrix(strings, inputMap, width, height);
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, tier, width, height, inputs, gemInputs, output, experience, craftingTime, skipRecipeRemainders, noBenefitsFromYieldUpgrades);
    }

    public void write(class_2540 packetByteBuf, ShapedPedestalRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        packetByteBuf.writeInt(recipe.tier.ordinal());
        packetByteBuf.writeInt(recipe.width);
        packetByteBuf.writeInt(recipe.height);
        for (IngredientStack ingredientStack : recipe.inputs) {
            ingredientStack.write(packetByteBuf);
        }
        this.writeGemstonePowderInputs(packetByteBuf, recipe);
        packetByteBuf.method_10793(recipe.output);
        packetByteBuf.writeFloat(recipe.experience);
        packetByteBuf.writeInt(recipe.craftingTime);
        packetByteBuf.writeBoolean(recipe.skipRecipeRemainders);
        packetByteBuf.writeBoolean(recipe.noBenefitsFromYieldUpgrades);
    }

    public ShapedPedestalRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        PedestalRecipeTier tier = PedestalRecipeTier.values()[packetByteBuf.readInt()];
        int width = packetByteBuf.readInt();
        int height = packetByteBuf.readInt();
        List inputs = IngredientStack.decodeByteBuf((class_2540)packetByteBuf, (int)(width * height));
        Map<BuiltinGemstoneColor, Integer> gemInputs = this.readGemstonePowderInputs(packetByteBuf);
        class_1799 output = packetByteBuf.method_10819();
        float experience = packetByteBuf.readFloat();
        int craftingTime = packetByteBuf.readInt();
        boolean skipRecipeRemainders = packetByteBuf.readBoolean();
        boolean noBenefitsFromYieldUpgrades = packetByteBuf.readBoolean();
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, tier, width, height, inputs, gemInputs, output, experience, craftingTime, skipRecipeRemainders, noBenefitsFromYieldUpgrades);
    }

    public static interface RecipeFactory {
        public ShapedPedestalRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, PedestalRecipeTier var5, int var6, int var7, List<IngredientStack> var8, Map<BuiltinGemstoneColor, Integer> var9, class_1799 var10, float var11, int var12, boolean var13, boolean var14);
    }
}

