/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.potion_workshop;

import de.dafuqs.spectrum.energy.InkPoweredStatusEffectInstance;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.items.InkPoweredPotionFillable;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionMod;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionRecipeEffect;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopRecipe;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumPotions;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3956;
import net.minecraft.class_4081;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotionWorkshopBrewingRecipe
extends PotionWorkshopRecipe {
    public static final int BASE_POTION_COUNT_ON_BREWING = 3;
    public static final int BASE_ARROW_COUNT_ON_BREWING = 12;
    protected static final List<class_3545<Float, Float>> SPLIT_EFFECT_POTENCY_AND_DURATION = new ArrayList<class_3545<Float, Float>>(){
        {
            this.add(new class_3545((Object)Float.valueOf(2.0f), (Object)Float.valueOf(0.15f)));
            this.add(new class_3545((Object)Float.valueOf(0.75f), (Object)Float.valueOf(0.5f)));
            this.add(new class_3545((Object)Float.valueOf(0.25f), (Object)Float.valueOf(1.0f)));
        }
    };
    public static final Map<class_1291, class_1291> negativeToPositiveEffect = new HashMap<class_1291, class_1291>(){
        {
            this.put(class_1294.field_16595, class_1294.field_18980);
            this.put(class_1294.field_5903, class_1294.field_5922);
            this.put(class_1294.field_5921, class_1294.field_5915);
            this.put(class_1294.field_5901, class_1294.field_5917);
            this.put(class_1294.field_5909, class_1294.field_5904);
            this.put(class_1294.field_5908, class_1294.field_5926);
            this.put(class_1294.field_5911, class_1294.field_5910);
            this.put(class_1294.field_5920, class_1294.field_5924);
            this.put(SpectrumStatusEffects.STIFFNESS, SpectrumStatusEffects.SWIFTNESS);
            this.put(SpectrumStatusEffects.DENSITY, SpectrumStatusEffects.LIGHTWEIGHT);
        }
    };
    public static final List<PotionWorkshopBrewingRecipe> positiveRecipes = new ArrayList<PotionWorkshopBrewingRecipe>();
    public static final List<PotionWorkshopBrewingRecipe> negativeRecipes = new ArrayList<PotionWorkshopBrewingRecipe>();
    public final PotionRecipeEffect recipeData;
    protected class_1799 cachedOutput;

    @Nullable
    public static PotionWorkshopBrewingRecipe getPositiveRecipe(@NotNull class_1291 statusEffect) {
        if (statusEffect.method_18792() == class_4081.field_18272) {
            class_1291 positiveEffect = negativeToPositiveEffect.getOrDefault(statusEffect, null);
            if (positiveEffect == null) {
                return null;
            }
            for (PotionWorkshopBrewingRecipe positiveRecipe : positiveRecipes) {
                if (positiveRecipe.recipeData.statusEffect() != positiveEffect) continue;
                return positiveRecipe;
            }
        }
        return null;
    }

    public PotionWorkshopBrewingRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, int craftingTime, IngredientStack ingredient1, IngredientStack ingredient2, IngredientStack ingredient3, PotionRecipeEffect recipeData) {
        super(id, group, secret, requiredAdvancementIdentifier, craftingTime, recipeData.statusEffect().method_5556(), ingredient1, ingredient2, ingredient3);
        this.recipeData = recipeData;
        this.registerInToastManager(this.method_17716(), this);
        if (recipeData.statusEffect().method_18792() == class_4081.field_18271) {
            for (PotionWorkshopBrewingRecipe ae : positiveRecipes) {
                if (ae.recipeData.statusEffect() != recipeData.statusEffect()) continue;
                return;
            }
            positiveRecipes.add(this);
        } else if (recipeData.statusEffect().method_18792() == class_4081.field_18272) {
            for (PotionWorkshopBrewingRecipe ae : negativeRecipes) {
                if (ae.recipeData.statusEffect() != recipeData.statusEffect()) continue;
                return;
            }
            negativeRecipes.add(this);
        }
    }

    @Override
    public boolean isValidBaseIngredient(class_1799 itemStack) {
        InkPoweredPotionFillable fillable;
        class_1792 class_17922;
        return this.recipeData.applicableToPotions() && itemStack.method_31574(class_1802.field_8469) || this.recipeData.applicableToTippedArrows() && itemStack.method_31574(class_1802.field_8107) || (class_17922 = itemStack.method_7909()) instanceof InkPoweredPotionFillable && ((fillable = (InkPoweredPotionFillable)class_17922).isWeapon() && this.recipeData.applicableToWeapons() || this.recipeData.applicableToPotionFillabes());
    }

    @Override
    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.POTION_WORKSHOP_BREWING_RECIPE_SERIALIZER;
    }

    @Override
    public class_3956<?> method_17716() {
        return SpectrumRecipeTypes.POTION_WORKSHOP_BREWING;
    }

    @Override
    public boolean usesReagents() {
        return true;
    }

    @Override
    public int getMinOutputCount(class_1799 baseItemStack) {
        return baseItemStack.method_31574(class_1802.field_8469) ? 3 : 1;
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        class_2371 defaultedList = class_2371.method_10211();
        defaultedList.add((Object)IngredientStack.ofStacks((class_1799[])new class_1799[]{SpectrumItems.MERMAIDS_GEM.method_7854()}));
        defaultedList.add((Object)IngredientStack.ofStacks((class_1799[])new class_1799[]{class_1802.field_8469.method_7854()}));
        this.addIngredientStacks((class_2371<IngredientStack>)defaultedList);
        return defaultedList;
    }

    public class_1799 method_8110() {
        if (this.cachedOutput == null) {
            this.cachedOutput = this.getPotion(class_1802.field_8574.method_7854(), new PotionMod(), null, class_5819.method_43047());
        }
        return this.cachedOutput;
    }

    public class_1799 method_8116(class_1263 inventory) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8574);
        class_1844.method_8056((class_1799)stack, List.of(new class_1293(this.recipeData.statusEffect(), this.recipeData.baseDurationTicks())));
        return stack;
    }

    public class_1799 getPotion(class_1799 stack, PotionMod potionMod, PotionWorkshopBrewingRecipe lastRecipe, class_5819 random) {
        List<InkPoweredStatusEffectInstance> effects = this.generateEffects(stack, potionMod, lastRecipe, random);
        class_1799 itemStack = potionMod.makeSplashing ? (potionMod.makeLingering ? new class_1799((class_1935)class_1802.field_8150) : new class_1799((class_1935)class_1802.field_8436)) : new class_1799((class_1935)class_1802.field_8574);
        if (effects.size() == 0) {
            class_1844.method_8061((class_1799)itemStack, (class_1842)class_1847.field_8985);
        } else {
            class_1844.method_8061((class_1799)itemStack, (class_1842)SpectrumPotions.PIGMENT_POTION);
        }
        PotionWorkshopBrewingRecipe.setCustomPotionEffects(itemStack, potionMod, effects);
        if (potionMod.additionalDrinkDurationTicks != 0) {
            class_2487 compound = itemStack.method_7948();
            itemStack.method_7980(compound);
        }
        return itemStack;
    }

    public class_1799 getTippedArrows(class_1799 stack, PotionMod potionMod, PotionWorkshopBrewingRecipe lastRecipe, int amount, class_5819 random) {
        List<InkPoweredStatusEffectInstance> effects = this.generateEffects(stack, potionMod, lastRecipe, random);
        class_1799 itemStack = new class_1799((class_1935)class_1802.field_8087, amount);
        if (effects.size() == 0) {
            class_1844.method_8061((class_1799)itemStack, (class_1842)class_1847.field_8985);
        } else {
            class_1844.method_8061((class_1799)itemStack, (class_1842)SpectrumPotions.PIGMENT_POTION);
            PotionWorkshopBrewingRecipe.setCustomPotionEffects(itemStack, potionMod, effects);
        }
        return itemStack;
    }

    public void fillPotionFillable(class_1799 stack, PotionMod potionMod, PotionWorkshopBrewingRecipe lastRecipe, class_5819 random) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof InkPoweredPotionFillable) {
            InkPoweredPotionFillable inkPoweredPotionFillable = (InkPoweredPotionFillable)class_17922;
            List<InkPoweredStatusEffectInstance> effects = this.generateEffects(stack, potionMod, lastRecipe, random);
            inkPoweredPotionFillable.addOrUpgradeEffects(stack, effects);
        }
    }

    private static void setCustomPotionEffects(class_1799 stack, PotionMod potionMod, List<InkPoweredStatusEffectInstance> effects) {
        ArrayList<class_1293> instances = new ArrayList<class_1293>();
        for (InkPoweredStatusEffectInstance e : effects) {
            instances.add(e.getStatusEffectInstance());
        }
        class_1844.method_8056((class_1799)stack, instances);
        for (InkPoweredStatusEffectInstance effect : effects) {
            if (effect.getColor() == -1) continue;
            class_2487 nbtCompound = stack.method_7948();
            nbtCompound.method_10569("CustomPotionColor", effect.getColor());
        }
        class_2487 nbtCompound = stack.method_7948();
        if (potionMod.unidentifiable) {
            nbtCompound.method_10556("spectrum_unidentifiable", true);
        }
    }

    private List<InkPoweredStatusEffectInstance> generateEffects(class_1799 baseIngredient, PotionMod potionMod, PotionWorkshopBrewingRecipe lastRecipe, class_5819 random) {
        List<InkPoweredStatusEffectInstance> effects = new ArrayList<InkPoweredStatusEffectInstance>();
        this.addEffect(potionMod, random, effects);
        PotionWorkshopBrewingRecipe.addLastEffect(baseIngredient, potionMod, lastRecipe, random, effects);
        PotionWorkshopBrewingRecipe.addAdditionalEffects(baseIngredient, potionMod, random, effects);
        this.addRandomEffects(potionMod, random, effects);
        if (potionMod.potentDecreasingEffect) {
            effects = this.applyPotentDecreasingEffect(effects, random);
        }
        return effects;
    }

    private static void addLastEffect(class_1799 baseIngredient, PotionMod potionMod, PotionWorkshopBrewingRecipe lastRecipe, class_5819 random, List<InkPoweredStatusEffectInstance> effects) {
        if (lastRecipe != null && (potionMod.chanceToAddLastEffect >= 1.0f || random.method_43057() < potionMod.chanceToAddLastEffect) && lastRecipe.recipeData.isApplicableTo(baseIngredient, potionMod)) {
            PotionMod lastEffectMod = new PotionMod();
            lastEffectMod.potencyMultiplier = potionMod.lastEffectPotencyMultiplier;
            lastEffectMod.durationMultiplier = potionMod.lastEffectDurationMultiplier;
            lastEffectMod.modifyFrom(potionMod);
            lastRecipe.addEffect(lastEffectMod, random, effects);
        }
    }

    private static void addAdditionalEffects(class_1799 baseIngredient, PotionMod potionMod, class_5819 random, List<InkPoweredStatusEffectInstance> effects) {
        for (class_3545<PotionRecipeEffect, Float> entry : potionMod.additionalEffects) {
            InkPoweredStatusEffectInstance statusEffectInstance;
            if (!(random.method_43057() < ((Float)entry.method_15441()).floatValue()) || !((PotionRecipeEffect)entry.method_15442()).isApplicableTo(baseIngredient, potionMod) || (statusEffectInstance = ((PotionRecipeEffect)entry.method_15442()).getStatusEffectInstance(potionMod, random)) == null) continue;
            effects.add(statusEffectInstance);
        }
    }

    private void addEffect(PotionMod potionMod, class_5819 random, List<InkPoweredStatusEffectInstance> effects) {
        PotionWorkshopBrewingRecipe positiveRecipe;
        if (potionMod.makeEffectsPositive && (positiveRecipe = PotionWorkshopBrewingRecipe.getPositiveRecipe(this.recipeData.statusEffect())) != null) {
            effects.add(positiveRecipe.recipeData.getStatusEffectInstance(potionMod, random));
            return;
        }
        InkPoweredStatusEffectInstance statusEffectInstance = this.recipeData.getStatusEffectInstance(potionMod, random);
        if (statusEffectInstance != null) {
            effects.add(statusEffectInstance);
        }
    }

    private void addRandomEffects(PotionMod potionMod, class_5819 random, List<InkPoweredStatusEffectInstance> effects) {
        InkPoweredStatusEffectInstance statusEffectInstance;
        int r;
        PotionWorkshopBrewingRecipe selectedRecipe;
        int tries;
        int i;
        if (positiveRecipes.size() > 0) {
            int additionalPositiveEffects = Support.getIntFromDecimalWithChance(potionMod.additionalRandomPositiveEffectCount, random);
            for (i = 0; i < additionalPositiveEffects; ++i) {
                tries = 0;
                do {
                    r = random.method_43048(positiveRecipes.size());
                    selectedRecipe = positiveRecipes.get(r);
                    if (!this.containsEffect(effects, selectedRecipe.recipeData.statusEffect())) continue;
                    selectedRecipe = null;
                    ++tries;
                } while (selectedRecipe == null && tries < 5);
                if (selectedRecipe == null || (statusEffectInstance = selectedRecipe.recipeData.getStatusEffectInstance(potionMod, random)) == null) continue;
                effects.add(statusEffectInstance);
            }
        }
        if (negativeRecipes.size() > 0) {
            int additionalNegativeEffects = Support.getIntFromDecimalWithChance(potionMod.additionalRandomNegativeEffectCount, random);
            for (i = 0; i < additionalNegativeEffects; ++i) {
                tries = 0;
                do {
                    r = random.method_43048(negativeRecipes.size());
                    selectedRecipe = negativeRecipes.get(r);
                    if (potionMod.makeEffectsPositive) {
                        selectedRecipe = this;
                        PotionWorkshopBrewingRecipe positiveRecipe = PotionWorkshopBrewingRecipe.getPositiveRecipe(this.recipeData.statusEffect());
                        if (positiveRecipe != null) {
                            selectedRecipe = positiveRecipe;
                        }
                    }
                    if (!this.containsEffect(effects, selectedRecipe.recipeData.statusEffect())) continue;
                    selectedRecipe = null;
                    ++tries;
                } while (selectedRecipe == null && tries < 5);
                if (selectedRecipe == null || (statusEffectInstance = selectedRecipe.recipeData.getStatusEffectInstance(potionMod, random)) == null) continue;
                effects.add(statusEffectInstance);
            }
        }
    }

    private boolean containsEffect(List<InkPoweredStatusEffectInstance> effects, class_1291 statusEffect) {
        for (InkPoweredStatusEffectInstance existingInstance : effects) {
            if (existingInstance.getStatusEffectInstance().method_5579() != statusEffect) continue;
            return true;
        }
        return false;
    }

    private List<InkPoweredStatusEffectInstance> applyPotentDecreasingEffect(@NotNull List<InkPoweredStatusEffectInstance> statusEffectInstances, class_5819 random) {
        ArrayList<InkPoweredStatusEffectInstance> splitInstances = new ArrayList<InkPoweredStatusEffectInstance>();
        for (InkPoweredStatusEffectInstance poweredInstance : statusEffectInstances) {
            class_1293 instance = poweredInstance.getStatusEffectInstance();
            if (instance.method_5579().method_5561()) {
                splitInstances.add(poweredInstance);
                continue;
            }
            for (class_3545<Float, Float> mods : SPLIT_EFFECT_POTENCY_AND_DURATION) {
                int newDuration = (int)((float)instance.method_5584() * ((Float)mods.method_15441()).floatValue());
                int newAmplifier = Support.getIntFromDecimalWithChance((float)instance.method_5578() * ((Float)mods.method_15442()).floatValue(), random);
                if (newAmplifier < 0) continue;
                splitInstances.add(new InkPoweredStatusEffectInstance(new class_1293(instance.method_5579(), newDuration, newAmplifier, instance.method_5591(), instance.method_5581()), poweredInstance.getInkCost(), poweredInstance.getColor(), poweredInstance.isUnidentifiable()));
            }
        }
        return splitInstances;
    }

    public class_1291 getStatusEffect() {
        return this.recipeData.statusEffect();
    }

    @Override
    public String getRecipeTypeShortID() {
        return "potion_workshop_brewing";
    }
}

