/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.potion_workshop;

import com.google.gson.JsonObject;
import de.dafuqs.spectrum.recipe.GatedRecipeSerializer;
import de.dafuqs.spectrum.recipe.RecipeUtils;
import de.dafuqs.spectrum.recipe.potion_workshop.PotionWorkshopCraftingRecipe;
import net.id.incubus_core.recipe.IngredientStack;
import net.id.incubus_core.recipe.RecipeParser;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class PotionWorkshopCraftingRecipeSerializer
implements GatedRecipeSerializer<PotionWorkshopCraftingRecipe> {
    public final RecipeFactory recipeFactory;

    public PotionWorkshopCraftingRecipeSerializer(RecipeFactory recipeFactory) {
        this.recipeFactory = recipeFactory;
    }

    public PotionWorkshopCraftingRecipe read(class_2960 identifier, JsonObject jsonObject) {
        String group = this.readGroup(jsonObject);
        boolean secret = this.readSecret(jsonObject);
        class_2960 requiredAdvancementIdentifier = this.readRequiredAdvancementIdentifier(jsonObject);
        IngredientStack baseIngredient = RecipeParser.ingredientStackFromJson((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"base_ingredient"));
        IngredientStack ingredient1 = RecipeParser.ingredientStackFromJson((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"ingredient1"));
        IngredientStack ingredient2 = class_3518.method_34923((JsonObject)jsonObject, (String)"ingredient2") ? RecipeParser.ingredientStackFromJson((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"ingredient2")) : IngredientStack.EMPTY;
        IngredientStack ingredient3 = class_3518.method_34923((JsonObject)jsonObject, (String)"ingredient3") ? RecipeParser.ingredientStackFromJson((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"ingredient3")) : IngredientStack.EMPTY;
        int requiredExperience = class_3518.method_15282((JsonObject)jsonObject, (String)"required_experience", (int)0);
        int craftingTime = class_3518.method_15282((JsonObject)jsonObject, (String)"time", (int)200);
        int color = class_3518.method_15282((JsonObject)jsonObject, (String)"color", (int)12595288);
        boolean consumeBaseIngredient = class_3518.method_15258((JsonObject)jsonObject, (String)"use_up_base_ingredient", (boolean)true);
        class_1799 output = RecipeUtils.itemStackWithNbtFromJson(class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, baseIngredient, consumeBaseIngredient, requiredExperience, ingredient1, ingredient2, ingredient3, output, craftingTime, color);
    }

    public void write(class_2540 packetByteBuf, PotionWorkshopCraftingRecipe recipe) {
        packetByteBuf.method_10814(recipe.group);
        packetByteBuf.writeBoolean(recipe.secret);
        this.writeNullableIdentifier(packetByteBuf, recipe.requiredAdvancementIdentifier);
        recipe.baseIngredient.write(packetByteBuf);
        packetByteBuf.writeBoolean(recipe.consumeBaseIngredient);
        packetByteBuf.writeInt(recipe.requiredExperience);
        recipe.ingredient1.write(packetByteBuf);
        recipe.ingredient2.write(packetByteBuf);
        recipe.ingredient3.write(packetByteBuf);
        packetByteBuf.method_10793(recipe.output);
        packetByteBuf.writeInt(recipe.craftingTime);
        packetByteBuf.writeInt(recipe.color);
    }

    public PotionWorkshopCraftingRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
        String group = packetByteBuf.method_19772();
        boolean secret = packetByteBuf.readBoolean();
        class_2960 requiredAdvancementIdentifier = this.readNullableIdentifier(packetByteBuf);
        IngredientStack baseIngredient = IngredientStack.fromByteBuf((class_2540)packetByteBuf);
        boolean consumeBaseIngredient = packetByteBuf.readBoolean();
        int requiredExperience = packetByteBuf.readInt();
        IngredientStack ingredient1 = IngredientStack.fromByteBuf((class_2540)packetByteBuf);
        IngredientStack ingredient2 = IngredientStack.fromByteBuf((class_2540)packetByteBuf);
        IngredientStack ingredient3 = IngredientStack.fromByteBuf((class_2540)packetByteBuf);
        class_1799 output = packetByteBuf.method_10819();
        int craftingTime = packetByteBuf.readInt();
        int color = packetByteBuf.readInt();
        return this.recipeFactory.create(identifier, group, secret, requiredAdvancementIdentifier, baseIngredient, consumeBaseIngredient, requiredExperience, ingredient1, ingredient2, ingredient3, output, craftingTime, color);
    }

    public static interface RecipeFactory {
        public PotionWorkshopCraftingRecipe create(class_2960 var1, String var2, boolean var3, class_2960 var4, IngredientStack var5, boolean var6, int var7, IngredientStack var8, IngredientStack var9, IngredientStack var10, class_1799 var11, int var12, int var13);
    }
}

