/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationStatusEffectEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_3518;

public record FermentationData(float fermentationSpeedMod, float angelsSharePercentPerMcDay, List<FermentationStatusEffectEntry> statusEffectEntries) {
    private static final String FERMENTATION_SPEED_MOD_STRING = "fermentation_speed_mod";
    private static final String ANGELS_SHARE_STRING = "angels_share_percent_per_mc_day";
    private static final String EFFECTS_STRING = "effects";

    public static FermentationData fromJson(JsonObject jsonObject) {
        float fermentationSpeedMod = class_3518.method_15277((JsonObject)jsonObject, (String)FERMENTATION_SPEED_MOD_STRING, (float)1.0f);
        float angelsSharePerMcDay = class_3518.method_15277((JsonObject)jsonObject, (String)ANGELS_SHARE_STRING, (float)0.01f);
        ArrayList<FermentationStatusEffectEntry> statusEffectEntries = new ArrayList<FermentationStatusEffectEntry>();
        if (class_3518.method_15264((JsonObject)jsonObject, (String)EFFECTS_STRING)) {
            JsonArray effectsArray = class_3518.method_15261((JsonObject)jsonObject, (String)EFFECTS_STRING);
            for (int i = 0; i < effectsArray.size(); ++i) {
                JsonObject object = effectsArray.get(i).getAsJsonObject();
                statusEffectEntries.add(FermentationStatusEffectEntry.fromJson(object));
            }
        }
        return new FermentationData(fermentationSpeedMod, angelsSharePerMcDay, statusEffectEntries);
    }

    public void write(class_2540 packetByteBuf) {
        packetByteBuf.writeFloat(this.fermentationSpeedMod);
        packetByteBuf.writeFloat(this.angelsSharePercentPerMcDay);
        packetByteBuf.writeInt(this.statusEffectEntries.size());
        for (FermentationStatusEffectEntry fermentationStatusEffectEntry : this.statusEffectEntries) {
            fermentationStatusEffectEntry.write(packetByteBuf);
        }
    }

    public static FermentationData read(class_2540 packetByteBuf) {
        float fermentationSpeedMod = packetByteBuf.readFloat();
        float angelsSharePerMcDay = packetByteBuf.readFloat();
        int statusEffectEntryCount = packetByteBuf.readInt();
        ArrayList<FermentationStatusEffectEntry> statusEffectEntries = new ArrayList<FermentationStatusEffectEntry>(statusEffectEntryCount);
        for (int i = 0; i < statusEffectEntryCount; ++i) {
            statusEffectEntries.add(FermentationStatusEffectEntry.read(packetByteBuf));
        }
        return new FermentationData(fermentationSpeedMod, angelsSharePerMcDay, statusEffectEntries);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty(FERMENTATION_SPEED_MOD_STRING, (Number)Float.valueOf(this.fermentationSpeedMod));
        json.addProperty(ANGELS_SHARE_STRING, (Number)Float.valueOf(this.angelsSharePercentPerMcDay));
        JsonArray effects = new JsonArray();
        for (FermentationStatusEffectEntry entry : this.statusEffectEntries) {
            effects.add((JsonElement)entry.toJson());
        }
        json.add(EFFECTS_STRING, (JsonElement)effects);
        return json;
    }
}

