/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.dafuqs.spectrum.SpectrumCommon;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public record FermentationStatusEffectEntry(class_1291 statusEffect, int baseDuration, List<StatusEffectPotencyEntry> potencyEntries) {
    private static final String EFFECT_ID_STRING = "id";
    private static final String BASE_DURATION_STRING = "base_duration";
    private static final String POTENCY_STRING = "potency";

    public static FermentationStatusEffectEntry fromJson(JsonObject jsonObject) {
        class_2960 statusEffectIdentifier = class_2960.method_12829((String)class_3518.method_15265((JsonObject)jsonObject, (String)EFFECT_ID_STRING));
        class_1291 statusEffect = (class_1291)class_2378.field_11159.method_10223(statusEffectIdentifier);
        if (statusEffect == null) {
            SpectrumCommon.logError("Status effect " + statusEffectIdentifier + " does not exist in the status effect registry. Falling back to WEAKNESS");
            statusEffect = class_1294.field_5911;
        }
        int baseDuration = class_3518.method_15282((JsonObject)jsonObject, (String)BASE_DURATION_STRING, (int)1200);
        ArrayList<StatusEffectPotencyEntry> potencyEntries = new ArrayList<StatusEffectPotencyEntry>();
        if (class_3518.method_15264((JsonObject)jsonObject, (String)POTENCY_STRING)) {
            JsonArray potencyArray = class_3518.method_15261((JsonObject)jsonObject, (String)POTENCY_STRING);
            for (int i = 0; i < potencyArray.size(); ++i) {
                JsonObject object = potencyArray.get(i).getAsJsonObject();
                potencyEntries.add(StatusEffectPotencyEntry.fromJson(object));
            }
        } else {
            potencyEntries.add(new StatusEffectPotencyEntry(0, 0, 0));
        }
        return new FermentationStatusEffectEntry(statusEffect, baseDuration, potencyEntries);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty(EFFECT_ID_STRING, class_2378.field_11159.method_10221((Object)this.statusEffect).toString());
        json.addProperty(BASE_DURATION_STRING, (Number)this.baseDuration);
        JsonArray effects = new JsonArray();
        for (StatusEffectPotencyEntry entry : this.potencyEntries) {
            effects.add((JsonElement)entry.toJson());
        }
        json.add(POTENCY_STRING, (JsonElement)effects);
        return json;
    }

    public void write(class_2540 packetByteBuf) {
        packetByteBuf.method_10814(class_2378.field_11159.method_10221((Object)this.statusEffect).toString());
        packetByteBuf.writeInt(this.baseDuration);
        packetByteBuf.writeInt(this.potencyEntries.size());
        for (StatusEffectPotencyEntry potencyEntry : this.potencyEntries) {
            potencyEntry.write(packetByteBuf);
        }
    }

    public static FermentationStatusEffectEntry read(class_2540 packetByteBuf) {
        class_2960 statusEffectIdentifier = class_2960.method_12829((String)packetByteBuf.method_19772());
        class_1291 statusEffect = (class_1291)class_2378.field_11159.method_10223(statusEffectIdentifier);
        int baseDuration = packetByteBuf.readInt();
        int potencyEntryCount = packetByteBuf.readInt();
        ArrayList<StatusEffectPotencyEntry> potencyEntries = new ArrayList<StatusEffectPotencyEntry>(potencyEntryCount);
        for (int i = 0; i < potencyEntryCount; ++i) {
            potencyEntries.add(StatusEffectPotencyEntry.read(packetByteBuf));
        }
        return new FermentationStatusEffectEntry(statusEffect, baseDuration, potencyEntries);
    }

    public record StatusEffectPotencyEntry(int minAlcPercent, int minThickness, int potency) {
        private static final String MIN_ALC_STRING = "min_alc";
        private static final String MIN_THICKNESS_STRING = "min_thickness";
        private static final String MIN_POTENCY_STRING = "potency";

        public static StatusEffectPotencyEntry fromJson(JsonObject jsonObject) {
            int minAlcPercent = class_3518.method_15282((JsonObject)jsonObject, (String)MIN_ALC_STRING, (int)0);
            int minThickness = class_3518.method_15282((JsonObject)jsonObject, (String)MIN_THICKNESS_STRING, (int)0);
            int potency = class_3518.method_15282((JsonObject)jsonObject, (String)"potency", (int)0);
            return new StatusEffectPotencyEntry(minAlcPercent, minThickness, potency);
        }

        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty(MIN_ALC_STRING, (Number)this.minAlcPercent);
            json.addProperty(MIN_THICKNESS_STRING, (Number)this.minThickness);
            json.addProperty("potency", (Number)this.potency);
            return json;
        }

        public void write(class_2540 packetByteBuf) {
            packetByteBuf.writeInt(this.minAlcPercent);
            packetByteBuf.writeInt(this.minThickness);
            packetByteBuf.writeInt(this.potency);
        }

        public static StatusEffectPotencyEntry read(class_2540 packetByteBuf) {
            return new StatusEffectPotencyEntry(packetByteBuf.readInt(), packetByteBuf.readInt(), packetByteBuf.readInt());
        }
    }
}

