/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel;

import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.items.FermentedItem;
import de.dafuqs.spectrum.items.food.beverages.properties.BeverageProperties;
import de.dafuqs.spectrum.items.food.beverages.properties.StatusEffectBeverageProperties;
import de.dafuqs.spectrum.items.food.beverages.properties.VariantBeverageProperties;
import de.dafuqs.spectrum.recipe.GatedStackSpectrumRecipe;
import de.dafuqs.spectrum.recipe.SpectrumRecipeTypes;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationData;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationStatusEffectEntry;
import de.dafuqs.spectrum.recipe.titration_barrel.ITitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class TitrationBarrelRecipe
extends GatedStackSpectrumRecipe
implements ITitrationBarrelRecipe {
    public static final class_1799 NOT_FERMENTED_LONG_ENOUGH_OUTPUT_STACK = class_1802.field_8574.method_7854();
    public static final List<Integer> FERMENTATION_DURATION_DISPLAY_TIME_MULTIPLIERS = new ArrayList<Integer>(){
        {
            this.add(1);
            this.add(10);
            this.add(100);
        }
    };
    protected final List<IngredientStack> inputStacks;
    protected final class_1799 outputItemStack;
    protected final class_1792 tappingItem;
    protected final class_3611 fluid;
    protected final int minFermentationTimeHours;
    protected final FermentationData fermentationData;

    public TitrationBarrelRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, List<IngredientStack> inputStacks, class_3611 fluid, class_1799 outputItemStack, class_1792 tappingItem, int minFermentationTimeHours, FermentationData fermentationData) {
        super(id, group, secret, requiredAdvancementIdentifier);
        this.inputStacks = inputStacks;
        this.fluid = fluid;
        this.minFermentationTimeHours = minFermentationTimeHours;
        this.outputItemStack = outputItemStack;
        this.tappingItem = tappingItem;
        this.fermentationData = fermentationData;
        this.registerInToastManager(this.method_17716(), this);
    }

    public boolean method_8115(class_1263 inventory, class_1937 world) {
        return TitrationBarrelRecipe.matchIngredientStacksExclusively(inventory, this.getIngredientStacks());
    }

    @Override
    public List<IngredientStack> getIngredientStacks() {
        return this.inputStacks;
    }

    @Override
    public class_1792 getTappingItem() {
        return this.tappingItem;
    }

    @Override
    public int getMinFermentationTimeHours() {
        return this.minFermentationTimeHours;
    }

    @Override
    public FermentationData getFermentationData() {
        return this.fermentationData;
    }

    public class_1799 method_8116(class_1263 inventory) {
        return class_1799.field_8037;
    }

    public class_1799 getPreviewTap(int timeMultiplier) {
        return this.tapWith(1.0f, (long)this.minFermentationTimeHours * 60L * 60L * (long)timeMultiplier, 0.4f);
    }

    public class_1799 getDefaultTap(int timeMultiplier) {
        class_1799 stack = this.getPreviewTap(timeMultiplier);
        stack.method_7939(this.outputItemStack.method_7947());
        FermentedItem.setPreviewStack(stack);
        return stack;
    }

    public class_1799 method_8110() {
        return this.getDefaultTap(1);
    }

    public Collection<class_1799> getOutputVariations(List<Integer> timeMultipliers) {
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        for (int timeMultiplier : timeMultipliers) {
            list.add(this.getDefaultTap(timeMultiplier));
        }
        return list;
    }

    @Override
    public class_3611 getFluidInput() {
        return this.fluid;
    }

    @Override
    public float getAngelsSharePerMcDay() {
        if (this.fermentationData == null) {
            return 0.0f;
        }
        return this.fermentationData.angelsSharePercentPerMcDay();
    }

    @Override
    public class_1799 tap(class_1263 inventory, long secondsFermented, float downfall) {
        int contentCount = InventoryHelper.countItemsInInventory(inventory);
        float thickness = this.getThickness(contentCount);
        return this.tapWith(thickness, secondsFermented, downfall);
    }

    private class_1799 tapWith(float thickness, long secondsFermented, float downfall) {
        if (secondsFermented / 60L / 60L < (long)this.minFermentationTimeHours) {
            return NOT_FERMENTED_LONG_ENOUGH_OUTPUT_STACK.method_7972();
        }
        class_1799 stack = this.outputItemStack.method_7972();
        stack.method_7939(1);
        if (this.fermentationData == null) {
            return stack;
        }
        return TitrationBarrelRecipe.getFermentedStack(this.fermentationData, thickness, secondsFermented, downfall, stack);
    }

    public static class_1799 getFermentedStack(@NotNull FermentationData fermentationData, float thickness, long secondsFermented, float downfall, class_1799 inputStack) {
        BeverageProperties properties;
        float ageIngameDays = TimeHelper.minecraftDaysFromSeconds(secondsFermented);
        double alcPercent = 0.0;
        if (fermentationData.fermentationSpeedMod() > 0.0f) {
            alcPercent = TitrationBarrelRecipe.getAlcPercent(fermentationData.fermentationSpeedMod(), thickness, downfall, ageIngameDays);
            alcPercent = Math.max(0.0, alcPercent);
        }
        if (alcPercent >= 100.0) {
            return SpectrumItems.PURE_ALCOHOL.method_7854();
        }
        class_1792 class_17922 = inputStack.method_7909();
        if (class_17922 instanceof FermentedItem) {
            FermentedItem fermentedItem = (FermentedItem)class_17922;
            properties = fermentedItem.getBeverageProperties(inputStack);
        } else {
            properties = VariantBeverageProperties.getFromStack(inputStack);
        }
        if (properties instanceof StatusEffectBeverageProperties) {
            StatusEffectBeverageProperties statusEffectBeverageProperties = (StatusEffectBeverageProperties)properties;
            float durationMultiplier = (float)Support.logBase(1.0f + thickness, 2.0);
            ArrayList<class_1293> effects = new ArrayList<class_1293>();
            for (FermentationStatusEffectEntry entry : fermentationData.statusEffectEntries()) {
                int potency = -1;
                int durationTicks = entry.baseDuration();
                for (FermentationStatusEffectEntry.StatusEffectPotencyEntry potencyEntry : entry.potencyEntries()) {
                    if (!(thickness >= (float)potencyEntry.minThickness()) || !(alcPercent >= (double)potencyEntry.minAlcPercent())) continue;
                    potency = potencyEntry.potency();
                }
                if (potency <= -1) continue;
                effects.add(new class_1293(entry.statusEffect(), (int)((float)durationTicks * durationMultiplier), potency));
            }
            statusEffectBeverageProperties.statusEffects = effects;
        }
        properties.alcPercent = (int)alcPercent;
        properties.ageDays = (long)ageIngameDays;
        properties.thickness = thickness;
        return properties.getStack(inputStack);
    }

    protected static double getAlcPercent(float fermentationSpeedMod, float thickness, float downfall, float ageIngameDays) {
        return Support.logBase(1.0f + fermentationSpeedMod, (double)ageIngameDays * (0.5 + (double)thickness / 2.0) * (0.5 + (double)downfall / 2.0));
    }

    protected float getThickness(int contentCount) {
        int inputStacksCount = 0;
        for (IngredientStack stack : this.inputStacks) {
            inputStacksCount += stack.getCount();
        }
        return (float)contentCount / (float)inputStacksCount;
    }

    public class_1865<?> method_8119() {
        return SpectrumRecipeTypes.TITRATION_BARREL_RECIPE_SERIALIZER;
    }

    public static class_5250 getDurationText(int minFermentationTimeHours, FermentationData fermentationData) {
        class_5250 text = fermentationData == null ? (minFermentationTimeHours == 1 ? class_2561.method_43471((String)"container.spectrum.rei.titration_barrel.time_hour") : (minFermentationTimeHours == 24 ? class_2561.method_43471((String)"container.spectrum.rei.titration_barrel.time_day") : (minFermentationTimeHours >= 72 ? class_2561.method_43469((String)"container.spectrum.rei.titration_barrel.time_days", (Object[])new Object[]{Support.getWithOneDecimalAfterComma((float)minFermentationTimeHours / 24.0f)}) : class_2561.method_43469((String)"container.spectrum.rei.titration_barrel.time_hours", (Object[])new Object[]{minFermentationTimeHours})))) : (minFermentationTimeHours == 1 ? class_2561.method_43471((String)"container.spectrum.rei.titration_barrel.at_least_time_hour") : (minFermentationTimeHours == 24 ? class_2561.method_43471((String)"container.spectrum.rei.titration_barrel.at_least_time_day") : (minFermentationTimeHours > 72 ? class_2561.method_43469((String)"container.spectrum.rei.titration_barrel.at_least_time_days", (Object[])new Object[]{Support.getWithOneDecimalAfterComma((float)minFermentationTimeHours / 24.0f)}) : class_2561.method_43469((String)"container.spectrum.rei.titration_barrel.at_least_time_hours", (Object[])new Object[]{minFermentationTimeHours}))));
        return text;
    }

    @Override
    public class_2960 getRecipeTypeUnlockIdentifier() {
        return ITitrationBarrelRecipe.UNLOCK_ADVANCEMENT_IDENTIFIER;
    }

    @Override
    public String getRecipeTypeShortID() {
        return "titration_barrel";
    }
}

