/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel.dynamic;

import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationData;
import de.dafuqs.spectrum.recipe.titration_barrel.dynamic.SweetenableTitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumItems;
import de.dafuqs.spectrum.registries.SpectrumStatusEffects;
import java.util.ArrayList;
import java.util.List;
import net.id.incubus_core.recipe.IngredientStack;
import net.id.incubus_core.recipe.matchbook.Matchbook;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1866;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;

public class JadeWineRecipe
extends SweetenableTitrationBarrelRecipe {
    public static final class_1865<JadeWineRecipe> SERIALIZER = new class_1866(JadeWineRecipe::new);
    public static final class_2960 UNLOCK_IDENTIFIER = SpectrumCommon.locate("unlocks/food/jade_wine");
    public static final int MIN_FERMENTATION_TIME_HOURS = 24;
    public static final class_1799 OUTPUT_STACK = JadeWineRecipe.getDefaultStackWithCount(SpectrumItems.JADE_WINE, 4);
    public static final class_1792 TAPPING_ITEM = class_1802.field_8469;
    public static final List<IngredientStack> INGREDIENT_STACKS = new ArrayList<IngredientStack>(){
        {
            this.add(IngredientStack.of((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{SpectrumItems.GERMINATED_JADE_VINE_BULB})));
            this.add(IngredientStack.of((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{SpectrumItems.JADE_VINE_PETALS}), (Matchbook)Matchbook.empty(), null, (int)3));
        }
    };

    public JadeWineRecipe(class_2960 identifier) {
        super(identifier, "", false, UNLOCK_IDENTIFIER, INGREDIENT_STACKS, (class_3611)class_3612.field_15910, OUTPUT_STACK, TAPPING_ITEM, 24, new FermentationData(0.075f, 0.01f, List.of()));
    }

    @Override
    public class_1799 tap(class_1263 inventory, long secondsFermented, float downfall) {
        int bulbCount = InventoryHelper.getItemCountInInventory(inventory, SpectrumItems.GERMINATED_JADE_VINE_BULB);
        int petalCount = InventoryHelper.getItemCountInInventory(inventory, SpectrumItems.JADE_VINE_PETALS);
        boolean nectar = InventoryHelper.getItemCountInInventory(inventory, SpectrumItems.MOONSTRUCK_NECTAR) > 0;
        float thickness = this.getThickness(bulbCount, petalCount);
        return this.tapWith(bulbCount, petalCount, nectar, thickness, secondsFermented, downfall);
    }

    @Override
    @NotNull
    protected List<class_1293> getEffects(boolean nectar, double bloominess, double alcPercent) {
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        int effectDuration = 1200;
        if (alcPercent >= 80.0) {
            effects.add(new class_1293(SpectrumStatusEffects.PROJECTILE_REBOUND, effectDuration));
            effectDuration *= 2;
        }
        if (alcPercent >= 70.0) {
            effects.add(new class_1293(class_1294.field_5907, effectDuration));
            effectDuration *= 2;
        }
        if (alcPercent >= 60.0) {
            effects.add(new class_1293(class_1294.field_5917, effectDuration));
            effectDuration *= 2;
        }
        if (alcPercent >= 40.0) {
            effects.add(new class_1293(class_1294.field_5918, effectDuration));
            effectDuration *= 2;
        }
        if (alcPercent >= 20.0) {
            effects.add(new class_1293(SpectrumStatusEffects.NOURISHING, effectDuration));
            effectDuration *= 2;
        }
        if (nectar) {
            effects.add(new class_1293(SpectrumStatusEffects.IMMUNITY, effectDuration));
        }
        int nectarMod = nectar ? 3 : 1;
        effectDuration = 1200;
        int alcAfterBloominess = (int)(alcPercent / ((double)nectarMod + bloominess));
        if (alcAfterBloominess >= 40) {
            effects.add(new class_1293(class_1294.field_5919, effectDuration));
            effectDuration *= 2;
        }
        if (alcAfterBloominess >= 30) {
            effects.add(new class_1293(class_1294.field_5899, effectDuration));
            effectDuration *= 2;
        }
        if (alcAfterBloominess >= 20) {
            effects.add(new class_1293(class_1294.field_5916, effectDuration));
            effectDuration *= 2;
        }
        if (alcAfterBloominess >= 10) {
            effects.add(new class_1293(class_1294.field_5911, effectDuration));
        }
        return effects;
    }

    @Override
    public boolean method_8115(class_1263 inventory, class_1937 world) {
        boolean bulbsFound = false;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            if (stack.method_31574(SpectrumItems.GERMINATED_JADE_VINE_BULB)) {
                bulbsFound = true;
                continue;
            }
            if (stack.method_31574(SpectrumItems.JADE_VINE_PETALS) || stack.method_31574(SpectrumItems.MOONSTRUCK_NECTAR)) continue;
            return false;
        }
        return bulbsFound;
    }

    @Override
    public class_1865<?> method_8119() {
        return SERIALIZER;
    }
}

