/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.recipe.titration_barrel.dynamic;

import de.dafuqs.spectrum.helpers.InventoryHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.helpers.TimeHelper;
import de.dafuqs.spectrum.items.food.beverages.properties.JadeWineBeverageProperties;
import de.dafuqs.spectrum.recipe.titration_barrel.FermentationData;
import de.dafuqs.spectrum.recipe.titration_barrel.TitrationBarrelRecipe;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.List;
import net.id.incubus_core.recipe.IngredientStack;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3611;

public abstract class SweetenableTitrationBarrelRecipe
extends TitrationBarrelRecipe {
    public SweetenableTitrationBarrelRecipe(class_2960 id, String group, boolean secret, class_2960 requiredAdvancementIdentifier, List<IngredientStack> inputStacks, class_3611 fluid, class_1799 outputItemStack, class_1792 tappingItem, int minFermentationTimeHours, FermentationData fermentationData) {
        super(id, group, secret, requiredAdvancementIdentifier, inputStacks, fluid, outputItemStack, tappingItem, minFermentationTimeHours, fermentationData);
    }

    @Override
    public class_1799 getPreviewTap(int timeMultiplier) {
        return this.tapWith(1, 3, false, 1.0f, (long)this.minFermentationTimeHours * 60L * 60L * (long)timeMultiplier, 0.4f);
    }

    protected abstract List<class_1293> getEffects(boolean var1, double var2, double var4);

    @Override
    public class_1799 tap(class_1263 inventory, long secondsFermented, float downfall) {
        int bulbCount = InventoryHelper.getItemCountInInventory(inventory, SpectrumItems.JADEITE_LOTUS_BULB);
        int petalCount = InventoryHelper.getItemCountInInventory(inventory, SpectrumItems.JADEITE_PETALS);
        boolean nectar = InventoryHelper.getItemCountInInventory(inventory, SpectrumItems.MOONSTRUCK_NECTAR) > 0;
        float thickness = this.getThickness(bulbCount, petalCount);
        return this.tapWith(bulbCount, petalCount, nectar, thickness, secondsFermented, downfall);
    }

    protected class_1799 tapWith(int bulbCount, int petalCount, boolean nectar, float thickness, long secondsFermented, float downfall) {
        double alcPercent;
        if (secondsFermented / 60L / 60L < (long)this.minFermentationTimeHours) {
            return NOT_FERMENTED_LONG_ENOUGH_OUTPUT_STACK.method_7972();
        }
        double bloominess = SweetenableTitrationBarrelRecipe.getBloominess(bulbCount, petalCount);
        float ageIngameDays = TimeHelper.minecraftDaysFromSeconds(secondsFermented);
        if (nectar) {
            thickness *= 1.5f;
        }
        if ((alcPercent = this.getAlcPercentWithBloominess(ageIngameDays, downfall, bloominess, thickness)) >= 100.0) {
            return SpectrumItems.CHRYSOCOLLA.method_7854();
        }
        List<class_1293> effects = this.getEffects(nectar, bloominess, alcPercent);
        class_1799 outputStack = this.outputItemStack.method_7972();
        outputStack.method_7939(1);
        return new JadeWineBeverageProperties((long)ageIngameDays, (int)alcPercent, thickness, (float)bloominess, nectar, effects).getStack(outputStack);
    }

    protected static double getBloominess(int bulbCount, int petalCount) {
        if (bulbCount == 0) {
            return 0.0;
        }
        return (double)petalCount / (double)bulbCount / 2.0;
    }

    protected float getThickness(int bulbCount, int petalCount) {
        return (float)bulbCount + (float)petalCount / 8.0f;
    }

    protected double getAlcPercentWithBloominess(float ageIngameDays, float downfall, double bloominess, double thickness) {
        return Support.logBase((double)(1.0f + this.fermentationData.fermentationSpeedMod()) + bloominess / 64.0, (double)ageIngameDays * (0.5 + thickness / 2.0) * (0.5 + (double)downfall / 2.0));
    }
}

