/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries;

import de.dafuqs.revelationary.api.advancements.AdvancementHelper;
import de.dafuqs.spectrum.SpectrumCommon;
import de.dafuqs.spectrum.compat.SpectrumIntegrationPacks;
import de.dafuqs.spectrum.recipe.pedestal.PedestalRecipeTier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.multiblock.StateMatcher;

public class SpectrumMultiblocks {
    public static final Map<class_2960, IMultiblock> MULTIBLOCKS = new ConcurrentHashMap<class_2960, IMultiblock>();
    public static final class_2960 PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_CHECK = SpectrumCommon.locate("pedestal_simple_structure_check");
    public static final class_2960 PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_PLACE = SpectrumCommon.locate("pedestal_simple_structure_place");
    public static final class_2960 PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_CHECK = SpectrumCommon.locate("pedestal_advanced_structure_check");
    public static final class_2960 PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_PLACE = SpectrumCommon.locate("pedestal_advanced_structure_place");
    public static final class_2960 PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_CHECK = SpectrumCommon.locate("pedestal_complex_structure_check");
    public static final class_2960 PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_PLACE = SpectrumCommon.locate("pedestal_complex_structure_place");
    public static final class_2960 PEDESTAL_COMPLEX_STRUCTURE_WITHOUT_MOONSTONE_IDENTIFIER_CHECK = SpectrumCommon.locate("pedestal_complex_structure_without_moonstone_check");
    public static final class_2960 PEDESTAL_COMPLEX_STRUCTURE_WITHOUT_MOONSTONE_IDENTIFIER_PLACE = SpectrumCommon.locate("pedestal_complex_structure_without_moonstone_place");
    public static final class_2960 FUSION_SHRINE_IDENTIFIER = SpectrumCommon.locate("fusion_shrine_structure");
    public static final class_2960 ENCHANTER_IDENTIFIER = SpectrumCommon.locate("enchanter_structure");
    public static final class_2960 SPIRIT_INSTILLER_IDENTIFIER = SpectrumCommon.locate("spirit_instiller_structure");
    public static final class_2960 CINDERHEARTH_IDENTIFIER = SpectrumCommon.locate("cinderhearth_structure");
    public static final class_2960 CINDERHEARTH_WITHOUT_LAVA_IDENTIFIER = SpectrumCommon.locate("cinderhearth_without_lava_structure");
    public static final class_2960 PEDESTAL_IDENTIFIER_WITH_UPGRADES = SpectrumCommon.locate("pedestal_structure_with_upgrades");
    public static final class_2960 FUSION_SHRINE_IDENTIFIER_WITH_UPGRADES = SpectrumCommon.locate("fusion_shrine_structure_with_upgrades");
    public static final class_2960 ENCHANTER_IDENTIFIER_WITH_UPGRADES = SpectrumCommon.locate("enchanter_structure_with_upgrades");
    public static final class_2960 CINDERHEARTH_IDENTIFIER_WITH_UPGRADES = SpectrumCommon.locate("cinderhearth_structure_with_upgrades");
    public static final class_2960 SPIRIT_INSTILLER_IDENTIFIER_WITH_UPGRADES = SpectrumCommon.locate("spirit_instiller_structure_with_upgrades");
    private static boolean registered = false;

    public static void registerMultiBlock(class_2960 identifier, String[][] structure, Object[] targetBlocks) {
        IMultiblock multiblock = PatchouliAPI.get().makeMultiblock(structure, targetBlocks);
        MULTIBLOCKS.put(identifier, PatchouliAPI.get().registerMultiblock(identifier, multiblock));
    }

    public static void register() {
        if (!registered) {
            SpectrumMultiblocks.registerPedestal();
            SpectrumMultiblocks.registerFusionShrine();
            SpectrumMultiblocks.registerEnchanter();
            SpectrumMultiblocks.registerSpiritInstiller();
            SpectrumMultiblocks.registerCinderhearth();
            SpectrumIntegrationPacks.registerMultiblocks();
            registered = true;
        }
    }

    private static void registerFusionShrine() {
        Object[] targetBlocks = new Object[]{Character.valueOf('X'), "#spectrum:polished_base_blocks", Character.valueOf('P'), "#spectrum:pillar_base_blocks", Character.valueOf('L'), "#spectrum:polished_base_block_slabs", Character.valueOf('S'), "#spectrum:gemstone_storage_blocks", Character.valueOf('C'), "#spectrum:chiseled_base_blocks", Character.valueOf('F'), "#spectrum:fusion_shrines", Character.valueOf('U'), "spectrum:upgrade_speed", Character.valueOf('_'), StateMatcher.ANY, Character.valueOf('0'), "#spectrum:polished_base_blocks"};
        String[][] structure = new String[][]{{"_________", "_L_____L_", "_________", "_________", "_________", "_________", "_________", "_L_____L_", "_________"}, {"_________", "_S_____S_", "_________", "_________", "_________", "_________", "_________", "_S_____S_", "_________"}, {"_________", "_P_____P_", "_________", "_________", "_________", "_________", "_________", "_P_____P_", "_________"}, {"__XXXXX__", "_P_____P_", "X_______X", "X_______X", "X___F___X", "X_______X", "X_______X", "_P_____P_", "__XXXXX__"}, {"__XXXXX__", "_XXXXXXX_", "XXCXXXCXX", "XXXLLLXXX", "XXXL0LXXX", "XXXLLLXXX", "XXCXXXCXX", "_XXXXXXX_", "__XXXXX__"}};
        SpectrumMultiblocks.registerMultiBlock(FUSION_SHRINE_IDENTIFIER, structure, targetBlocks);
        String[][] structureUpgrades = new String[][]{{"_________", "_L_____L_", "_________", "_________", "_________", "_________", "_________", "_L_____L_", "_________"}, {"_________", "_S_____S_", "_________", "_________", "_________", "_________", "_________", "_S_____S_", "_________"}, {"_________", "_P_____P_", "_________", "_________", "_________", "_________", "_________", "_P_____P_", "_________"}, {"__XXXXX__", "_P_____P_", "X_U___U_X", "X_______X", "X___F___X", "X_______X", "X_U___U_X", "_P_____P_", "__XXXXX__"}, {"__XXXXX__", "_XXXXXXX_", "XXCXXXCXX", "XXXLLLXXX", "XXXL0LXXX", "XXXLLLXXX", "XXCXXXCXX", "_XXXXXXX_", "__XXXXX__"}};
        SpectrumMultiblocks.registerMultiBlock(FUSION_SHRINE_IDENTIFIER_WITH_UPGRADES, structureUpgrades, targetBlocks);
    }

    private static void registerSpiritInstiller() {
        Object[] targetBlocks = new Object[]{Character.valueOf('S'), "spectrum:spirit_instiller", Character.valueOf('X'), "#spectrum:polished_base_blocks", Character.valueOf('L'), "#spectrum:polished_base_block_slabs", Character.valueOf('P'), "#spectrum:pillar_base_blocks", Character.valueOf('C'), "#spectrum:chiseled_base_blocks", Character.valueOf('G'), "#spectrum:onyx_chiseled_base_blocks", Character.valueOf('K'), "#spectrum:notched_base_blocks", Character.valueOf('I'), "#spectrum:item_bowls", Character.valueOf('M'), "#spectrum:gemstone_chimes", Character.valueOf('U'), "spectrum:upgrade_speed", Character.valueOf('_'), StateMatcher.ANY, Character.valueOf('0'), "#spectrum:polished_base_blocks"};
        String[][] structure = new String[][]{{"________", "________", "__M_____", "________", "________", "________", "__M_____", "________", "________"}, {"________", "________", "________", "________", "________", "________", "________", "________", "________"}, {"________", "K_______", "__I_____", "________", "________", "________", "__I_____", "K_______", "________"}, {"______G_", "P_______", "__C_____", "_LLLLL__", "_LSLLL__", "_LLLLL__", "__C_____", "P_______", "______G_"}, {"______P_", "PXXXX___", "XXXXXX__", "XXXXXXXL", "XXXXXX0L", "XXXXXXXL", "XXXXXX__", "PXXXX___", "______P_"}};
        SpectrumMultiblocks.registerMultiBlock(SPIRIT_INSTILLER_IDENTIFIER, structure, targetBlocks);
        String[][] structureUpgrades = new String[][]{{"________", "________", "__M_____", "________", "________", "________", "__M_____", "________", "________"}, {"________", "________", "________", "________", "________", "________", "________", "________", "________"}, {"______U_", "K_______", "__I_____", "________", "________", "________", "__I_____", "K_______", "______U_"}, {"______G_", "P_______", "__C_____", "_LLLLL__", "_LSLLL__", "_LLLLL__", "__C_____", "P_______", "______G_"}, {"______P_", "PXXXX___", "XXXXXX__", "XXXXXXXL", "XXXXXX0L", "XXXXXXXL", "XXXXXX__", "PXXXX___", "______P_"}};
        SpectrumMultiblocks.registerMultiBlock(SPIRIT_INSTILLER_IDENTIFIER_WITH_UPGRADES, structureUpgrades, targetBlocks);
    }

    private static void registerEnchanter() {
        Object[] targetBlocks = new Object[]{Character.valueOf('X'), "#spectrum:polished_base_blocks", Character.valueOf('P'), "#spectrum:pillar_base_blocks", Character.valueOf('B'), "#spectrum:polished_base_block_slabs", Character.valueOf('L'), "#spectrum:gemstone_lamps", Character.valueOf('G'), "#spectrum:gemstone_storage_blocks", Character.valueOf('F'), "spectrum:enchanter", Character.valueOf('C'), "spectrum:liquid_crystal", Character.valueOf('I'), "#spectrum:item_bowls", Character.valueOf('U'), "spectrum:upgrade_speed", Character.valueOf('_'), StateMatcher.ANY, Character.valueOf('0'), "#spectrum:polished_base_blocks"};
        String[][] structure = new String[][]{{"__I_____I__", "___________", "I_________I", "___________", "___________", "_____F_____", "___________", "___________", "I_________I", "___________", "__I_____I__"}, {"__L_____L__", "___________", "L_G_____G_L", "____BBB____", "___BXXXB___", "___BXXXB___", "___BXXXB___", "____BBB____", "L_G_____G_L", "___________", "__L_____L__"}, {"__P_____P__", "____BBB____", "P_P_XXX_P_P", "____XXX____", "_BXXXXXXXB_", "_BXXXXXXXB_", "_BXXXXXXXB_", "____XXX____", "P_P_XXX_P_P", "____BBB____", "__P_____P__"}, {"_XXXXXXXXX_", "XCCCXXXCCCX", "XCXCXXXCXCX", "XCCCXXXCCCX", "XXXXXXXXXXX", "XXXXX0XXXXX", "XXXXXXXXXXX", "XCCCXXXCCCX", "XCXCXXXCXCX", "XCCCXXXCCCX", "_XXXXXXXXX_"}, {"___________", "_XXX___XXX_", "_X_X___X_X_", "_XXX___XXX_", "___________", "___________", "___________", "_XXX___XXX_", "_X_X___X_X_", "_XXX___XXX_", "___________"}};
        SpectrumMultiblocks.registerMultiBlock(ENCHANTER_IDENTIFIER, structure, targetBlocks);
        String[][] structureUpgrades = new String[][]{{"__I_____I__", "___________", "I_U_____U_I", "___________", "___________", "_____F_____", "___________", "___________", "I_U_____U_I", "___________", "__I_____I__"}, {"__L_____L__", "___________", "L_G_____G_L", "____BBB____", "___BXXXB___", "___BXXXB___", "___BXXXB___", "____BBB____", "L_G_____G_L", "___________", "__L_____L__"}, {"__P_____P__", "____BBB____", "P_P_XXX_P_P", "____XXX____", "_BXXXXXXXB_", "_BXXXXXXXB_", "_BXXXXXXXB_", "____XXX____", "P_P_XXX_P_P", "____BBB____", "__P_____P__"}, {"_XXXXXXXXX_", "XCCCXXXCCCX", "XCXCXXXCXCX", "XCCCXXXCCCX", "XXXXXXXXXXX", "XXXXX0XXXXX", "XXXXXXXXXXX", "XCCCXXXCCCX", "XCXCXXXCXCX", "XCCCXXXCCCX", "_XXXXXXXXX_"}, {"___________", "_XXX___XXX_", "_X_X___X_X_", "_XXX___XXX_", "___________", "___________", "___________", "_XXX___XXX_", "_X_X___X_X_", "_XXX___XXX_", "___________"}};
        SpectrumMultiblocks.registerMultiBlock(ENCHANTER_IDENTIFIER_WITH_UPGRADES, structureUpgrades, targetBlocks);
    }

    private static void registerCinderhearth() {
        Object[] targetBlocks = new Object[]{Character.valueOf('X'), "#spectrum:polished_base_blocks", Character.valueOf('C'), "#spectrum:chiseled_base_blocks", Character.valueOf('c'), "#spectrum:crest_base_blocks", Character.valueOf('G'), "#minecraft:impermeable", Character.valueOf('L'), "minecraft:lava", Character.valueOf('U'), "spectrum:upgrade_speed", Character.valueOf('_'), StateMatcher.ANY, Character.valueOf('H'), "spectrum:cinderhearth[facing=south]", Character.valueOf('0'), "#spectrum:polished_base_blocks"};
        String[][] structure = new String[][]{{"C___", "____", "_H__", "____", "C___"}, {"Xcc_", "cGGX", "__GX", "cGGX", "Xcc_"}, {"_XX_", "XLLX", "XLLX", "XLLX", "_XX_"}, {"____", "_XX_", "_0X_", "_XX_", "____"}};
        SpectrumMultiblocks.registerMultiBlock(CINDERHEARTH_IDENTIFIER, structure, targetBlocks);
        String[][] withoutLavaStructure = new String[][]{{"C___", "____", "_H__", "____", "C___"}, {"Xcc_", "cGGX", "__GX", "cGGX", "Xcc_"}, {"_XX_", "X__X", "X__X", "X__X", "_XX_"}, {"____", "_XX_", "_0X_", "_XX_", "____"}};
        SpectrumMultiblocks.registerMultiBlock(CINDERHEARTH_WITHOUT_LAVA_IDENTIFIER, withoutLavaStructure, targetBlocks);
        String[][] structureUpgrades = new String[][]{{"U___", "____", "____", "____", "U___"}, {"C___", "____", "_H__", "____", "C___"}, {"Xcc_", "cGGX", "__GX", "cGGX", "Xcc_"}, {"_XX_", "XLLX", "XLLX", "XLLX", "_XX_"}, {"____", "_XX_", "_0X_", "_XX_", "____"}};
        SpectrumMultiblocks.registerMultiBlock(CINDERHEARTH_IDENTIFIER_WITH_UPGRADES, structureUpgrades, targetBlocks);
    }

    private static void registerPedestal() {
        Object[] targetBlocksCheck = new Object[]{Character.valueOf('X'), "#spectrum:polished_base_blocks", Character.valueOf('T'), "#spectrum:crest_base_blocks", Character.valueOf('t'), "#spectrum:crest_base_blocks", Character.valueOf('Q'), "#spectrum:pillar_base_blocks", Character.valueOf('L'), "#spectrum:gemstone_lamps", Character.valueOf('S'), "#spectrum:gemstone_storage_blocks", Character.valueOf('C'), "#spectrum:chiseled_base_blocks", Character.valueOf('K'), "#spectrum:notched_base_blocks", Character.valueOf('r'), "#spectrum:basic_and_onyx_gemstone_chiseled_base_blocks", Character.valueOf('O'), "#spectrum:onyx_chiseled_base_blocks", Character.valueOf('m'), "#spectrum:moonstone_chiseled_base_blocks", Character.valueOf('n'), "#spectrum:moonstone_chiseled_base_blocks", Character.valueOf('M'), "#spectrum:moonstone_chiseled_base_blocks", Character.valueOf('N'), "#spectrum:moonstone_chiseled_base_blocks", Character.valueOf('2'), "#spectrum:pedestals", Character.valueOf('3'), "#spectrum:pedestals", Character.valueOf('4'), "#spectrum:pedestals", Character.valueOf('_'), StateMatcher.ANY, Character.valueOf('0'), StateMatcher.ANY};
        Object[] targetBlocksPlace = new Object[]{Character.valueOf('X'), "spectrum:polished_basalt", Character.valueOf('T'), "spectrum:polished_basalt_crest[cardinal_facing=true]", Character.valueOf('t'), "spectrum:polished_basalt_crest[cardinal_facing=false]", Character.valueOf('Q'), "spectrum:polished_basalt_pillar[axis=y]", Character.valueOf('L'), "spectrum:amethyst_basalt_lamp", Character.valueOf('S'), "spectrum:amethyst_storage_block", Character.valueOf('C'), "spectrum:chiseled_polished_basalt", Character.valueOf('K'), "spectrum:notched_polished_basalt", Character.valueOf('r'), "spectrum:amethyst_chiseled_basalt", Character.valueOf('O'), "spectrum:onyx_chiseled_basalt", Character.valueOf('m'), "spectrum:moonstone_chiseled_basalt[facing=east]", Character.valueOf('n'), "spectrum:moonstone_chiseled_basalt[facing=north]", Character.valueOf('M'), "spectrum:moonstone_chiseled_basalt[facing=west]", Character.valueOf('N'), "spectrum:moonstone_chiseled_basalt[facing=south]", Character.valueOf('2'), "spectrum:pedestal_all_basic", Character.valueOf('3'), "spectrum:pedestal_onyx", Character.valueOf('4'), "spectrum:pedestal_moonstone", Character.valueOf('U'), "spectrum:upgrade_speed", Character.valueOf('_'), StateMatcher.ANY, Character.valueOf('0'), StateMatcher.ANY};
        String[][] tier1Structure = new String[][]{{"C_________C", "___________", "___________", "___________", "___________", "___________", "___________", "___________", "___________", "___________", "C_________C"}, {"Q_________Q", "___________", "__S_____S__", "___________", "___________", "___________", "___________", "___________", "__S_____S__", "___________", "Q_________Q"}, {"K_________K", "___________", "__Q_____Q__", "___________", "___________", "_____2_____", "___________", "___________", "__Q_____Q__", "___________", "K_________K"}, {"___________", "___XXXXX___", "__XXXXXXX__", "_XXXXXXXXX_", "_XXXXXXXXX_", "_XXXX0XXXX_", "_XXXXXXXXX_", "_XXXXXXXXX_", "__XXXXXXX__", "___XXXXX___", "___________"}};
        SpectrumMultiblocks.registerMultiBlock(PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_CHECK, tier1Structure, targetBlocksCheck);
        SpectrumMultiblocks.registerMultiBlock(PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_PLACE, tier1Structure, targetBlocksPlace);
        String[][] tier2Structure = new String[][]{{"_____________", "_Sttr___rttS_", "_T_________T_", "_T_________T_", "_r_________r_", "_____________", "_____________", "_____________", "_r_________r_", "_T_________T_", "_T_________T_", "_Sttr___rttS_", "_____________"}, {"_____________", "_Q__Q___Q__Q_", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_Q__Q___Q__Q_", "_____________"}, {"_____________", "_C__Q___Q__C_", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_C__Q___Q__C_", "_____________"}, {"_____________", "_Q__L___L__Q_", "_____________", "___S_____S___", "_L_________L_", "_____________", "_____________", "_____________", "_L_________L_", "___S_____S___", "_____________", "_Q__L___L__Q_", "_____________"}, {"_____________", "_K__Q___Q__K_", "_____________", "___Q_____Q___", "_Q_________Q_", "_____________", "______3______", "_____________", "_Q_________Q_", "___Q_____Q___", "_____________", "_K__Q___Q__K_", "_____________"}, {"XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXrXrXXXXX", "XXXXrXXXrXXXX", "XXXXXX0XXXXXX", "XXXXrXXXrXXXX", "XXXXXrXrXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX"}};
        SpectrumMultiblocks.registerMultiBlock(PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_CHECK, tier2Structure, targetBlocksCheck);
        SpectrumMultiblocks.registerMultiBlock(PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_PLACE, tier2Structure, targetBlocksPlace);
        String[][] tier2StructureUpgrades = new String[][]{{"_____________", "_Sttr___rttS_", "_T_________T_", "_T_________T_", "_r_________r_", "_____________", "_____________", "_____________", "_r_________r_", "_T_________T_", "_T_________T_", "_Sttr___rttS_", "_____________"}, {"_____________", "_Q__Q___Q__Q_", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_Q__Q___Q__Q_", "_____________"}, {"_____________", "_C__Q___Q__C_", "_____________", "___U_____U___", "_Q_________Q_", "_____________", "_____________", "_____________", "_Q_________Q_", "___U_____U___", "_____________", "_C__Q___Q__C_", "_____________"}, {"_____________", "_Q__L___L__Q_", "_____________", "___S_____S___", "_L_________L_", "_____________", "_____________", "_____________", "_L_________L_", "___S_____S___", "_____________", "_Q__L___L__Q_", "_____________"}, {"_____________", "_K__Q___Q__K_", "_____________", "___Q_____Q___", "_Q_________Q_", "_____________", "______3______", "_____________", "_Q_________Q_", "___Q_____Q___", "_____________", "_K__Q___Q__K_", "_____________"}, {"XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXrXrXXXXX", "XXXXrXXXrXXXX", "XXXXXX0XXXXXX", "XXXXrXXXrXXXX", "XXXXXrXrXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "XXXXXXXXXXXXX"}};
        SpectrumMultiblocks.registerMultiBlock(PEDESTAL_IDENTIFIER_WITH_UPGRADES, tier2StructureUpgrades, targetBlocksPlace);
        String[][] tier3StructureWithoutMoonstone = new String[][]{{"_____________", "____XtStX____", "_____________", "_____________", "_X__OtttO__X_", "_T__T___T__T_", "_S__T___T__S_", "_T__T___T__T_", "_X__OtttO__X_", "_____________", "_____________", "____XtStX____", "_____________"}, {"_____________", "_Sttr___rttS_", "_T__T___T__T_", "_T__T___T__T_", "_rttX___Xttr_", "_____________", "_____________", "_____________", "_rttX___Xttr_", "_T__T___T__T_", "_T__T___T__T_", "_Sttr___rttS_", "_____________"}, {"_____________", "_Q__Q___Q__Q_", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_Q__Q___Q__Q_", "_____________"}, {"_____________", "_C__Q___Q__C_", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_C__Q___Q__C_", "_____________"}, {"_____________", "_Q__L___L__Q_", "_____________", "___S_____S___", "_L_________L_", "_____________", "_____________", "_____________", "_L_________L_", "___S_____S___", "_____________", "_Q__L___L__Q_", "_____________"}, {"_____________", "_K__Q___Q__K_", "_____________", "___Q_____Q___", "_Q_________Q_", "_____________", "______4______", "_____________", "_Q_________Q_", "___Q_____Q___", "_____________", "_K__Q___Q__K_", "_____________"}, {"XXXXXXXXXXXXX", "XX__X___X__XX", "X_XXXXXXXXX_X", "X_XXXXXXXXX_X", "XXXXXrXrXXXXX", "X_XXrXXXrXX_X", "X_XXXX0XXXX_X", "X_XXrXXXrXX_X", "XXXXXrXrXXXXX", "X_XXXXXXXXX_X", "X_XXXXXXXXX_X", "XX__X___X__XX", "XXXXXXXXXXXXX"}};
        SpectrumMultiblocks.registerMultiBlock(PEDESTAL_COMPLEX_STRUCTURE_WITHOUT_MOONSTONE_IDENTIFIER_CHECK, tier3StructureWithoutMoonstone, targetBlocksCheck);
        SpectrumMultiblocks.registerMultiBlock(PEDESTAL_COMPLEX_STRUCTURE_WITHOUT_MOONSTONE_IDENTIFIER_PLACE, tier3StructureWithoutMoonstone, targetBlocksPlace);
        String[][] tier3Structure = new String[][]{{"_____________", "____XtStX____", "_____________", "_____________", "_X__OtttO__X_", "_T__T___T__T_", "_S__T___T__S_", "_T__T___T__T_", "_X__OtttO__X_", "_____________", "_____________", "____XtStX____", "_____________"}, {"_____________", "_Sttr___rttS_", "_T__T___T__T_", "_T__T___T__T_", "_rttX___Xttr_", "_____________", "_____________", "_____________", "_rttX___Xttr_", "_T__T___T__T_", "_T__T___T__T_", "_Sttr___rttS_", "_____________"}, {"_____________", "_Q__Q___Q__Q_", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_Q__Q___Q__Q_", "_____________"}, {"_____________", "_C__Q___Q__C_", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_____________", "_Q_________Q_", "_____________", "_____________", "_C__Q___Q__C_", "_____________"}, {"_____________", "_Q__L___L__Q_", "_____________", "___S_____S___", "_L_________L_", "_____________", "_____________", "_____________", "_L_________L_", "___S_____S___", "_____________", "_Q__L___L__Q_", "_____________"}, {"_____________", "_K__Q___Q__K_", "_____________", "___Q_____Q___", "_Q_________Q_", "_____________", "______4______", "_____________", "_Q_________Q_", "___Q_____Q___", "_____________", "_K__Q___Q__K_", "_____________"}, {"XXXXXXXXXXXXX", "XXnnXnnnXnnXX", "XmXXXXXXXXXMX", "XmXXXXXXXXXMX", "XXXXXrXrXXXXX", "XmXXrXXXrXXMX", "XmXXXX0XXXXMX", "XmXXrXXXrXXMX", "XXXXXrXrXXXXX", "XmXXXXXXXXXMX", "XmXXXXXXXXXMX", "XXNNXNNNXNNXX", "XXXXXXXXXXXXX"}};
        SpectrumMultiblocks.registerMultiBlock(PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_CHECK, tier3Structure, targetBlocksCheck);
        SpectrumMultiblocks.registerMultiBlock(PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_PLACE, tier3Structure, targetBlocksPlace);
    }

    @Contract(pure=true)
    @Nullable
    public static class_2960 getDisplayStructureIdentifierForTier(@NotNull PedestalRecipeTier pedestalRecipeTier, class_1657 player) {
        switch (pedestalRecipeTier) {
            case COMPLEX: {
                if (AdvancementHelper.hasAdvancement((class_1657)player, (class_2960)SpectrumCommon.locate("lategame/build_complex_pedestal_structure_without_moonstone"))) {
                    return PEDESTAL_COMPLEX_STRUCTURE_IDENTIFIER_CHECK;
                }
                return PEDESTAL_COMPLEX_STRUCTURE_WITHOUT_MOONSTONE_IDENTIFIER_CHECK;
            }
            case ADVANCED: {
                return PEDESTAL_ADVANCED_STRUCTURE_IDENTIFIER_CHECK;
            }
            case SIMPLE: {
                return PEDESTAL_SIMPLE_STRUCTURE_IDENTIFIER_CHECK;
            }
        }
        return null;
    }

    @Nullable
    public static class_2561 getPedestalStructureText(@NotNull PedestalRecipeTier pedestalRecipeTier) {
        switch (pedestalRecipeTier) {
            case COMPLEX: {
                return class_2561.method_43471((String)"multiblock.spectrum.pedestal.complex_structure");
            }
            case ADVANCED: {
                return class_2561.method_43471((String)"multiblock.spectrum.pedestal.advanced_structure");
            }
            case SIMPLE: {
                return class_2561.method_43471((String)"multiblock.spectrum.pedestal.simple_structure");
            }
        }
        return null;
    }
}

