/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.registries.client;

import de.dafuqs.spectrum.blocks.present.PresentBlock;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.storage.SingleInkStorage;
import de.dafuqs.spectrum.helpers.NullableDyeColor;
import de.dafuqs.spectrum.interfaces.PlayerEntityAccessor;
import de.dafuqs.spectrum.items.ActivatableItem;
import de.dafuqs.spectrum.items.ExperienceStorageItem;
import de.dafuqs.spectrum.items.MysteriousLocketItem;
import de.dafuqs.spectrum.items.StructureCompassItem;
import de.dafuqs.spectrum.items.energy.InkFlaskItem;
import de.dafuqs.spectrum.items.magic_items.PaintbrushItem;
import de.dafuqs.spectrum.items.magic_items.PipeBombItem;
import de.dafuqs.spectrum.items.tools.MalachiteCrossbowItem;
import de.dafuqs.spectrum.items.tools.SpectrumFishingRodItem;
import de.dafuqs.spectrum.items.trinkets.AshenCircletItem;
import de.dafuqs.spectrum.registries.SpectrumBlocks;
import de.dafuqs.spectrum.registries.SpectrumItems;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_638;
import net.minecraft.class_6395;
import net.minecraft.class_7391;
import net.minecraft.class_809;

public class SpectrumModelPredicateProviders {
    public static class_809.class_811 currentItemRenderMode;

    public static void registerClient() {
        SpectrumModelPredicateProviders.registerBowPredicates(SpectrumItems.BEDROCK_BOW);
        SpectrumModelPredicateProviders.registerCrossbowPredicates(SpectrumItems.BEDROCK_CROSSBOW);
        SpectrumModelPredicateProviders.registerSpectrumFishingRodItemPredicates((class_1792)SpectrumItems.LAGOON_ROD);
        SpectrumModelPredicateProviders.registerSpectrumFishingRodItemPredicates((class_1792)SpectrumItems.MOLTEN_ROD);
        SpectrumModelPredicateProviders.registerSpectrumFishingRodItemPredicates(SpectrumItems.BEDROCK_FISHING_ROD);
        SpectrumModelPredicateProviders.registerEnderSplicePredicates(SpectrumItems.ENDER_SPLICE);
        SpectrumModelPredicateProviders.registerAnimatedWandPredicates(SpectrumItems.NATURES_STAFF);
        SpectrumModelPredicateProviders.registerAnimatedWandPredicates(SpectrumItems.RADIANCE_STAFF);
        SpectrumModelPredicateProviders.registerAnimatedWandPredicates(SpectrumItems.STAFF_OF_REMEMBRANCE);
        SpectrumModelPredicateProviders.registerKnowledgeDropPredicates(SpectrumItems.KNOWLEDGE_GEM);
        SpectrumModelPredicateProviders.registerAshenCircletPredicates(SpectrumItems.ASHEN_CIRCLET);
        SpectrumModelPredicateProviders.registerColorPredicate(SpectrumItems.PAINTBRUSH);
        SpectrumModelPredicateProviders.registerInkColorPredicate(SpectrumItems.INK_FLASK);
        SpectrumModelPredicateProviders.registerInkFillStateItemPredicate(SpectrumItems.INK_FLASK);
        SpectrumModelPredicateProviders.registerMoonPhasePredicates(SpectrumItems.CRESCENT_CLOCK);
        SpectrumModelPredicateProviders.registerActivatableItemPredicate(SpectrumItems.DREAMFLAYER);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate(SpectrumItems.DREAMFLAYER);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate(SpectrumItems.MALACHITE_WORKSTAFF);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate(SpectrumItems.MALACHITE_ULTRA_GREATSWORD);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate(SpectrumItems.MALACHITE_CROSSBOW);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate(SpectrumItems.MALACHITE_BIDENT);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate(SpectrumItems.GLASS_CREST_WORKSTAFF);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate(SpectrumItems.GLASS_CREST_ULTRA_GREATSWORD);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate(SpectrumItems.GLASS_CREST_CROSSBOW);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate(SpectrumItems.FEROCIOUS_GLASS_CREST_BIDENT);
        SpectrumModelPredicateProviders.registerOversizedItemPredicate(SpectrumItems.FRACTAL_GLASS_CREST_BIDENT);
        SpectrumModelPredicateProviders.registerBidentThrowingItemPredicate(SpectrumItems.MALACHITE_BIDENT);
        SpectrumModelPredicateProviders.registerBidentThrowingItemPredicate(SpectrumItems.FEROCIOUS_GLASS_CREST_BIDENT);
        SpectrumModelPredicateProviders.registerBidentThrowingItemPredicate(SpectrumItems.FRACTAL_GLASS_CREST_BIDENT);
        SpectrumModelPredicateProviders.registerMalachiteCrossbowPredicates(SpectrumItems.MALACHITE_CROSSBOW);
        SpectrumModelPredicateProviders.registerMalachiteCrossbowPredicates(SpectrumItems.GLASS_CREST_CROSSBOW);
        SpectrumModelPredicateProviders.registerBottomlessBundlePredicates(SpectrumItems.BOTTOMLESS_BUNDLE);
        SpectrumModelPredicateProviders.registerEnchantmentCanvasPrediates(SpectrumItems.ENCHANTMENT_CANVAS);
        SpectrumModelPredicateProviders.registerPresentPredicates(SpectrumBlocks.PRESENT.method_8389());
        SpectrumModelPredicateProviders.registerMysteriousLocketPredicates(SpectrumItems.MYSTERIOUS_LOCKET);
        SpectrumModelPredicateProviders.registerStructureCompassPredicates(SpectrumItems.MYSTERIOUS_COMPASS);
        SpectrumModelPredicateProviders.registerNullableDyeColorPredicate(SpectrumBlocks.CRYSTALLARIEUM.method_8389());
        SpectrumModelPredicateProviders.registerPipeBombPredicates(SpectrumItems.PIPE_BOMB);
    }

    private static void registerNullableDyeColorPredicate(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("color"), (itemStack, clientWorld, livingEntity, i) -> {
            NullableDyeColor color = NullableDyeColor.get(itemStack.method_7969());
            return (float)color.getId() / 16.0f;
        });
    }

    private static void registerMysteriousLocketPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("socketed"), (itemStack, clientWorld, livingEntity, i) -> MysteriousLocketItem.isSocketed(itemStack) ? 1.0f : 0.0f);
    }

    private static void registerStructureCompassPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("angle"), (class_6395)new class_7391((world, stack, entity) -> StructureCompassItem.getStructurePos(stack)));
    }

    private static void registerMalachiteCrossbowPredicates(class_1792 crossbowItem) {
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)new class_2960("pull"), (itemStack, clientWorld, livingEntity, i) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return class_1764.method_7781((class_1799)itemStack) ? 0.0f : (float)(itemStack.method_7935() - livingEntity.method_6014()) / (float)class_1764.method_7775((class_1799)itemStack);
        });
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)new class_2960("pulling"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack && !class_1764.method_7781((class_1799)itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)new class_2960("charged"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && class_1764.method_7781((class_1799)itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)new class_2960("projectile"), (itemStack, world, entity, seed) -> {
            if (itemStack == null) {
                return 0.0f;
            }
            class_1799 projectile = MalachiteCrossbowItem.getFirstProjectile(itemStack);
            if (projectile.method_7960()) {
                return 0.0f;
            }
            if (projectile.method_31574(class_1802.field_8639)) {
                return 0.1f;
            }
            if (projectile.method_31574(SpectrumItems.MALACHITE_GLASS_ARROW)) {
                return 0.2f;
            }
            if (projectile.method_31574(SpectrumItems.TOPAZ_GLASS_ARROW)) {
                return 0.3f;
            }
            if (projectile.method_31574(SpectrumItems.AMETHYST_GLASS_ARROW)) {
                return 0.4f;
            }
            if (projectile.method_31574(SpectrumItems.CITRINE_GLASS_ARROW)) {
                return 0.5f;
            }
            if (projectile.method_31574(SpectrumItems.ONYX_GLASS_ARROW)) {
                return 0.6f;
            }
            if (projectile.method_31574(SpectrumItems.MOONSTONE_GLASS_ARROW)) {
                return 0.7f;
            }
            return 0.0f;
        });
    }

    private static void registerBidentThrowingItemPredicate(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("bident_throwing"), (itemStack, clientWorld, livingEntity, i) -> {
            if (currentItemRenderMode == class_809.class_811.field_4315) {
                return 1.0f;
            }
            return livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 0.5f : 0.0f;
        });
    }

    private static void registerColorPredicate(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("color"), (itemStack, clientWorld, livingEntity, i) -> {
            Optional<InkColor> color = PaintbrushItem.getColor(itemStack);
            return color.map(inkColor -> Float.valueOf((1.0f + (float)inkColor.getDyeColor().method_7789()) / 100.0f)).orElse(Float.valueOf(0.0f)).floatValue();
        });
    }

    private static void registerPresentPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("variant"), (itemStack, clientWorld, livingEntity, i) -> {
            class_2487 compound = itemStack.method_7969();
            if (compound == null || !compound.method_10573("Variant", 8)) {
                return 0.0f;
            }
            PresentBlock.WrappingPaper wrappingPaper = PresentBlock.WrappingPaper.valueOf(compound.method_10558("Variant").toUpperCase(Locale.ROOT));
            return (float)wrappingPaper.ordinal() / 10.0f;
        });
    }

    private static void registerBottomlessBundlePredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("locked"), (itemStack, clientWorld, livingEntity, i) -> {
            class_2487 compound = itemStack.method_7969();
            if (compound == null) {
                return 0.0f;
            }
            return compound.method_10545("Locked") ? 1.0f : 0.0f;
        });
        class_5272.method_27879((class_1792)SpectrumItems.BOTTOMLESS_BUNDLE, (class_2960)new class_2960("filled"), (itemStack, clientWorld, livingEntity, i) -> {
            class_2487 compound = itemStack.method_7969();
            if (compound == null) {
                return 0.0f;
            }
            return compound.method_10545("StoredStack") ? 1.0f : 0.0f;
        });
    }

    private static void registerMoonPhasePredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("phase"), (itemStack, clientWorld, livingEntity, i) -> {
            class_1937 patt8890$temp;
            class_1309 entity;
            Object object = entity = livingEntity != null ? livingEntity : itemStack.method_27319();
            if (entity == null) {
                return 0.0f;
            }
            if (clientWorld == null && (patt8890$temp = entity.field_6002) instanceof class_638) {
                class_638 clientWorld1;
                clientWorld = clientWorld1 = (class_638)patt8890$temp;
            }
            if (clientWorld == null) {
                return 0.0f;
            }
            if (!clientWorld.method_8597().comp_645()) {
                return 1.0f;
            }
            return (float)clientWorld.method_30273() / 8.0f;
        });
    }

    private static void registerActivatableItemPredicate(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("activated"), (itemStack, clientWorld, livingEntity, i) -> {
            if (ActivatableItem.isActivated(itemStack)) {
                return 1.0f;
            }
            return 0.0f;
        });
    }

    private static void registerOversizedItemPredicate(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("in_world"), (itemStack, world, livingEntity, i) -> {
            if (world == null && livingEntity == null && i == 0) {
                return 0.0f;
            }
            return currentItemRenderMode == class_809.class_811.field_4317 || currentItemRenderMode == class_809.class_811.field_4318 || currentItemRenderMode == class_809.class_811.field_4319 ? 0.0f : 1.0f;
        });
    }

    private static void registerBowPredicates(class_1792 bowItem) {
        class_5272.method_27879((class_1792)bowItem, (class_2960)new class_2960("pull"), (itemStack, world, livingEntity, i) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.method_6030() != itemStack ? 0.0f : (float)(itemStack.method_7935() - livingEntity.method_6014()) / 20.0f;
        });
        class_5272.method_27879((class_1792)bowItem, (class_2960)new class_2960("pulling"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
    }

    private static void registerCrossbowPredicates(class_1792 crossbowItem) {
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)new class_2960("pull"), (itemStack, clientWorld, livingEntity, i) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return class_1764.method_7781((class_1799)itemStack) ? 0.0f : (float)(itemStack.method_7935() - livingEntity.method_6014()) / (float)class_1764.method_7775((class_1799)itemStack);
        });
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)new class_2960("pulling"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack && !class_1764.method_7781((class_1799)itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)new class_2960("charged"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && class_1764.method_7781((class_1799)itemStack) ? 1.0f : 0.0f);
        class_5272.method_27879((class_1792)crossbowItem, (class_2960)new class_2960("firework"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && class_1764.method_7781((class_1799)itemStack) && class_1764.method_7772((class_1799)itemStack, (class_1792)class_1802.field_8639) ? 1.0f : 0.0f);
    }

    private static void registerPipeBombPredicates(class_1792 pipeBombItem) {
        class_5272.method_27879((class_1792)pipeBombItem, (class_2960)new class_2960("armed"), PipeBombItem::isArmed);
    }

    private static void registerSpectrumFishingRodItemPredicates(class_1792 fishingRodItem) {
        class_5272.method_27879((class_1792)fishingRodItem, (class_2960)new class_2960("cast"), (itemStack, clientWorld, livingEntity, i) -> {
            boolean isInOffhand;
            if (livingEntity == null) {
                return 0.0f;
            }
            boolean isInMainHand = livingEntity.method_6047() == itemStack;
            boolean bl = isInOffhand = livingEntity.method_6079() == itemStack;
            if (livingEntity.method_6047().method_7909() instanceof SpectrumFishingRodItem) {
                isInOffhand = false;
            }
            return (isInMainHand || isInOffhand) && livingEntity instanceof class_1657 && ((PlayerEntityAccessor)livingEntity).getSpectrumBobber() != null ? 1.0f : 0.0f;
        });
    }

    private static void registerEnderSplicePredicates(class_1792 enderSpliceItem) {
        class_5272.method_27879((class_1792)enderSpliceItem, (class_2960)new class_2960("bound"), (itemStack, clientWorld, livingEntity, i) -> {
            class_2487 compoundTag = itemStack.method_7969();
            if (compoundTag != null && (compoundTag.method_10545("PosX") || compoundTag.method_10545("TargetPlayerUUID"))) {
                return 1.0f;
            }
            return 0.0f;
        });
    }

    private static void registerAshenCircletPredicates(class_1792 ashenCircletItem) {
        class_5272.method_27879((class_1792)ashenCircletItem, (class_2960)new class_2960("cooldown"), (itemStack, clientWorld, livingEntity, i) -> {
            if (livingEntity != null && AshenCircletItem.getCooldownTicks(itemStack, livingEntity.field_6002) == 0L) {
                return 0.0f;
            }
            return 1.0f;
        });
    }

    private static void registerAnimatedWandPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("in_use"), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && livingEntity.method_6115() && livingEntity.method_6030() == itemStack ? 1.0f : 0.0f);
    }

    private static void registerKnowledgeDropPredicates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("stored_experience_10000"), (itemStack, clientWorld, livingEntity, i) -> {
            if (SpectrumItems.KNOWLEDGE_GEM instanceof ExperienceStorageItem) {
                return (float)ExperienceStorageItem.getStoredExperience(itemStack) / 10000.0f;
            }
            return 0.0f;
        });
    }

    private static void registerInkColorPredicate(InkFlaskItem item) {
        class_5272.method_27879((class_1792)SpectrumItems.INK_FLASK, (class_2960)new class_2960("color"), (itemStack, clientWorld, livingEntity, i) -> {
            SingleInkStorage storage = SpectrumItems.INK_FLASK.getEnergyStorage(itemStack);
            InkColor color = storage.getStoredColor();
            return (1.0f + (float)color.getDyeColor().method_7789()) / 100.0f;
        });
    }

    private static void registerInkFillStateItemPredicate(InkFlaskItem item) {
        class_5272.method_27879((class_1792)SpectrumItems.INK_FLASK, (class_2960)new class_2960("fill_state"), (itemStack, world, livingEntity, i) -> {
            SingleInkStorage storage = SpectrumItems.INK_FLASK.getEnergyStorage(itemStack);
            long current = storage.getCurrentTotal();
            if (current == 0L) {
                return 0.0f;
            }
            long max = storage.getMaxTotal();
            return (float)Math.max(0.01, (double)current / (double)max);
        });
    }

    private static void registerEnchantmentCanvasPrediates(class_1792 item) {
        class_5272.method_27879((class_1792)item, (class_2960)new class_2960("bound"), (itemStack, world, livingEntity, i) -> {
            class_2487 nbt = itemStack.method_7969();
            if (nbt != null && nbt.method_10573("BoundItem", 8)) {
                return 1.0f;
            }
            return 0.0f;
        });
    }
}

