/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.spells;

import de.dafuqs.spectrum.blocks.mob_blocks.FirestarterMobBlock;
import de.dafuqs.spectrum.energy.color.InkColor;
import de.dafuqs.spectrum.energy.color.InkColors;
import de.dafuqs.spectrum.helpers.BlockVariantHelper;
import de.dafuqs.spectrum.helpers.Support;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import de.dafuqs.spectrum.spells.InkSpellEffect;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class InkSpellEffects {
    public static final Map<InkColor, InkSpellEffect> effects = new HashMap<InkColor, InkSpellEffect>();

    @Nullable
    public static InkSpellEffect getEffect(InkColor inkColor) {
        return effects.getOrDefault(inkColor, null);
    }

    public static void registerEffect(InkSpellEffect effect) {
        effects.put(effect.color, effect);
    }

    public static void register() {
        InkSpellEffects.registerEffect(new InkSpellEffect(InkColors.PINK){

            @Override
            public void playEffects(class_1937 world, class_243 origin, float potency) {
                int count = 12 + (int)(potency * 3.0f);
                class_5819 random = world.field_9229;
                for (int i = 0; i < count; ++i) {
                    world.method_8406((class_2394)class_2398.field_29643, origin.field_1352 + (double)potency - (double)(random.method_43057() * potency * 2.0f), origin.field_1351 + (double)potency - (double)(random.method_43057() * potency * 2.0f), origin.field_1350 + (double)potency - (double)(random.method_43057() * potency * 2.0f), 0.0, 0.0, 0.0);
                }
            }

            @Override
            void affectEntity(class_1297 entity, class_243 origin, float potency) {
                float amount;
                class_1309 livingEntity;
                if (entity instanceof class_1309 && ((livingEntity = (class_1309)entity).method_6032() < livingEntity.method_6063() || livingEntity.method_5999()) && (amount = potency - (float)entity.method_19538().method_1022(origin)) >= 1.0f) {
                    livingEntity.method_6025(amount);
                    entity.method_37908().method_8396(null, entity.method_24515(), SpectrumSoundEvents.BLOCK_CITRINE_BLOCK_CHIME, class_3419.field_15254, 1.0f, 0.9f + entity.method_37908().field_9229.method_43057() * 0.2f);
                    SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)entity.method_37908(), entity.method_19538(), (class_2394)class_2398.field_29643, 10, new class_243(0.5, 0.5, 0.5), new class_243(0.0, 0.0, 0.0));
                }
            }

            @Override
            void affectArea(class_1937 world, class_2338 origin, float potency) {
                int range = Support.getIntFromDecimalWithChance(potency, world.field_9229);
                for (class_2338 blockPos : class_2338.method_25996((class_2338)origin, (int)range, (int)range, (int)range)) {
                    class_2248 repairedBlock = BlockVariantHelper.getCursedRepairedBlockVariant(world, blockPos);
                    if (repairedBlock == class_2246.field_10124) continue;
                    world.method_8501(blockPos, repairedBlock.method_9564());
                }
            }
        });
        InkSpellEffects.registerEffect(new InkSpellEffect(InkColors.ORANGE){

            @Override
            public void playEffects(class_1937 world, class_243 origin, float potency) {
                world.method_8406((class_2394)class_2398.field_11221, origin.field_1352, origin.field_1351, origin.field_1350, 0.0, 0.0, 0.0);
                world.method_8486(origin.field_1352, origin.field_1351, origin.field_1350, class_3417.field_15152, class_3419.field_15245, 4.0f, (1.0f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.2f) * 0.7f, false);
                int count = 10 + (int)(potency * 3.0f);
                class_5819 random = world.field_9229;
                for (int i = 0; i < count; ++i) {
                    world.method_8406((class_2394)class_2398.field_11223, origin.field_1352 + (double)potency - (double)(random.method_43057() * potency * 2.0f), origin.field_1351 + (double)potency - (double)(random.method_43057() * potency * 2.0f), origin.field_1350 + (double)potency - (double)(random.method_43057() * potency * 2.0f), 0.2 - (double)random.method_43057() * 0.4, -0.5, 0.2 - (double)random.method_43057() * 0.4);
                }
            }

            @Override
            void affectEntity(class_1297 entity, class_243 origin, float potency) {
                int duration;
                if (!entity.method_5753() && (duration = (int)(10.0f * potency) - (int)(5.0 * entity.method_19538().method_1022(origin))) >= 1) {
                    entity.method_20803(duration);
                    entity.method_37908().method_8396(null, entity.method_24515(), class_3417.field_14993, class_3419.field_15254, 1.0f, 0.9f + entity.method_37908().field_9229.method_43057() * 0.2f);
                    SpectrumS2CPacketSender.playParticleWithRandomOffsetAndVelocity((class_3218)entity.method_37908(), entity.method_19538(), (class_2394)class_2398.field_22247, 10, new class_243(0.5, 0.5, 0.5), new class_243(0.0, 0.0, 0.0));
                }
            }

            @Override
            void affectArea(class_1937 world, class_2338 origin, float potency) {
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    int range = Support.getIntFromDecimalWithChance(potency, world.field_9229);
                    for (class_2338 blockPos : class_2338.method_25996((class_2338)origin, (int)range, (int)range, (int)range)) {
                        int distance = 1 + blockPos.method_19455((class_2382)origin);
                        float div = (float)range / (float)distance;
                        if (!(div >= 1.0f) && !(world.field_9229.method_43057() < div)) continue;
                        FirestarterMobBlock.causeFire(serverWorld, blockPos, class_2350.method_10162((class_5819)world.field_9229));
                    }
                }
            }
        });
    }
}

