/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.spells;

import com.google.common.collect.Maps;
import de.dafuqs.spectrum.blocks.MoonstoneStrikeableBlock;
import de.dafuqs.spectrum.networking.SpectrumS2CPacketSender;
import de.dafuqs.spectrum.particle.SpectrumParticleTypes;
import de.dafuqs.spectrum.registries.SpectrumDamageSources;
import de.dafuqs.spectrum.registries.SpectrumSoundEvents;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1900;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class MoonstoneStrike {
    private final class_1937 world;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    public final class_1297 entity;
    public final float power;
    public final float knockbackMod;
    private final class_1282 damageSource;
    protected final Map<class_1657, class_243> affectedPlayers = Maps.newHashMap();

    public MoonstoneStrike(class_1937 world, @Nullable class_1297 entity, @Nullable class_1282 damageSource, double x, double y, double z, float power, float knockbackMod) {
        this.world = world;
        this.entity = entity;
        this.power = power;
        this.knockbackMod = knockbackMod;
        this.x = x;
        this.y = y;
        this.z = z;
        this.damageSource = damageSource == null ? SpectrumDamageSources.moonstoneBlast(this) : damageSource;
    }

    public static void create(class_1937 world, class_1297 entity, @Nullable class_1282 damageSource, double x, double y, double z, float power) {
        MoonstoneStrike.create(world, entity, damageSource, x, y, z, power, power);
    }

    public static void create(class_1937 world, class_1297 entity, @Nullable class_1282 damageSource, double x, double y, double z, float power, float knockbackMod) {
        MoonstoneStrike moonstoneStrike = new MoonstoneStrike(world, entity, damageSource, x, y, z, power, knockbackMod);
        if (world.field_9236) {
            world.method_8486(x, y, z, SpectrumSoundEvents.MOONSTONE_STRIKE, class_3419.field_15245, 4.0f, (1.0f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.2f) * 0.7f, false);
            world.method_8486(x, y, z, SpectrumSoundEvents.SOFT_HUM, class_3419.field_15245, 0.5f, (1.0f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.2f) * 0.7f, false);
            world.method_8406((class_2394)SpectrumParticleTypes.MOONSTONE_STRIKE, x, y, z, 1.0, 0.0, 0.0);
        } else {
            moonstoneStrike.damageAndKnockbackEntities();
            SpectrumS2CPacketSender.sendMoonstoneBlast((class_3218)world, moonstoneStrike);
            moonstoneStrike.affectWorld();
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getPower() {
        return this.power;
    }

    public float getKnockbackMod() {
        return this.knockbackMod;
    }

    public class_1282 getDamageSource() {
        return this.damageSource;
    }

    public Map<class_1657, class_243> getAffectedPlayers() {
        return this.affectedPlayers;
    }

    public static float getExposure(class_243 source, class_1297 entity) {
        class_238 box = entity.method_5829();
        double d = 1.0 / ((box.field_1320 - box.field_1323) * 2.0 + 1.0);
        double e = 1.0 / ((box.field_1325 - box.field_1322) * 2.0 + 1.0);
        double f = 1.0 / ((box.field_1324 - box.field_1321) * 2.0 + 1.0);
        double g = (1.0 - Math.floor(1.0 / d) * d) / 2.0;
        double h = (1.0 - Math.floor(1.0 / f) * f) / 2.0;
        if (!(d < 0.0 || e < 0.0 || f < 0.0)) {
            int i = 0;
            int j = 0;
            for (double k = 0.0; k <= 1.0; k += d) {
                for (double l = 0.0; l <= 1.0; l += e) {
                    for (double m = 0.0; m <= 1.0; m += f) {
                        double p;
                        double o;
                        double n = class_3532.method_16436((double)k, (double)box.field_1323, (double)box.field_1320);
                        class_243 vec3d = new class_243(n + g, o = class_3532.method_16436((double)l, (double)box.field_1322, (double)box.field_1325), (p = class_3532.method_16436((double)m, (double)box.field_1321, (double)box.field_1324)) + h);
                        if (entity.field_6002.method_17742(new class_3959(vec3d, source, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity)).method_17783() == class_239.class_240.field_1333) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public void damageAndKnockbackEntities() {
        this.world.method_43275(this.entity, class_5712.field_28178, new class_243(this.x, this.y, this.z));
        float power2 = this.power * 2.0f;
        int minX = class_3532.method_15357((double)(this.x - (double)power2 - 1.0));
        int maxX = class_3532.method_15357((double)(this.x + (double)power2 + 1.0));
        int minY = class_3532.method_15357((double)(this.y - (double)power2 - 1.0));
        int maxY = class_3532.method_15357((double)(this.y + (double)power2 + 1.0));
        int minZ = class_3532.method_15357((double)(this.z - (double)power2 - 1.0));
        int maxZ = class_3532.method_15357((double)(this.z + (double)power2 + 1.0));
        class_243 center = new class_243(this.x, this.y, this.z);
        for (class_1297 entity : this.world.method_8335(this.entity, new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ))) {
            class_1657 playerEntity;
            double difZ;
            double difY;
            double difX;
            double sqrt;
            double w;
            if (entity.method_5659() || !((w = Math.sqrt(entity.method_5707(center)) / (double)power2) <= 1.0) || (sqrt = Math.sqrt((difX = entity.method_23317() - this.x) * difX + (difY = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.y) * difY + (difZ = entity.method_23321() - this.z) * difZ)) == 0.0) continue;
            difX /= sqrt;
            difY /= sqrt;
            difZ /= sqrt;
            double exposure = MoonstoneStrike.getExposure(center, entity);
            double ac = (1.0 - w) * exposure;
            entity.method_5643(this.getDamageSource(), (float)((int)((ac * ac + ac) / 2.0 * 7.0 * (double)power2 + 1.0)));
            double knockback = ac * (double)this.knockbackMod;
            if (entity instanceof class_1309) {
                knockback = class_1900.method_8237((class_1309)((class_1309)entity), (double)ac);
            }
            entity.method_18799(entity.method_18798().method_1031(difX * knockback, difY * knockback, difZ * knockback));
            if (!(entity instanceof class_1657) || (playerEntity = (class_1657)entity).method_7325() || playerEntity.method_7337() && playerEntity.method_31549().field_7479) continue;
            this.affectedPlayers.put(playerEntity, new class_243(difX * ac, difY * ac, difZ * ac));
        }
    }

    public void affectWorld() {
        class_1309 cause = this.getCausingEntity();
        int range = Math.max(2, (int)this.power / 2);
        for (class_2338 pos : class_2338.method_25996((class_2338)new class_2338(this.x, this.y, this.z), (int)range, (int)range, (int)range)) {
            class_2680 blockState = this.world.method_8320(pos);
            class_2248 block = blockState.method_26204();
            if (!(block instanceof MoonstoneStrikeableBlock)) continue;
            MoonstoneStrikeableBlock moonstoneStrikeableBlock = (MoonstoneStrikeableBlock)block;
            moonstoneStrikeableBlock.onMoonstoneStrike(this.world, pos, cause);
        }
    }

    @Nullable
    public class_1309 getCausingEntity() {
        class_1676 projectileEntity;
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            return livingEntity;
        }
        class_12972 = this.entity;
        if (class_12972 instanceof class_1676 && (class_12972 = (projectileEntity = (class_1676)class_12972).method_24921()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            return livingEntity;
        }
        return null;
    }
}

