/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.spectrum.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.spectrum.registries.SpectrumStructureTypes;
import de.dafuqs.spectrum.structures.StructurePlacementType;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_4966;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7151;

public class UndergroundJigsawStructure
extends class_3195 {
    public static final Codec<UndergroundJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)UndergroundJigsawStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(structure -> structure.size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)StructurePlacementType.CODEC.fieldOf("placement_type").forGetter(structure -> structure.structurePlacementType), (App)Codec.intRange((int)0, (int)64).fieldOf("placement_check_width").forGetter(structure -> structure.placementCheckWidth), (App)Codec.intRange((int)0, (int)64).fieldOf("placement_check_height").forGetter(structure -> structure.placementCheckHeight), (App)Codec.BOOL.fieldOf("placement_required").forGetter(structure -> structure.placementRequired), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, UndergroundJigsawStructure::new)).codec();
    protected final class_6880<class_3785> startPool;
    protected final Optional<class_2960> startJigsawName;
    protected final int size;
    protected final int placementCheckWidth;
    protected final int placementCheckHeight;
    protected final boolean placementRequired;
    protected final class_6122 startHeight;
    protected final StructurePlacementType structurePlacementType;
    protected final int maxDistanceFromCenter;

    public UndergroundJigsawStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, Integer size, class_6122 startHeight, StructurePlacementType structurePlacementType, int placementCheckWidth, int placementCheckHeight, boolean placementRequired, Integer maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.structurePlacementType = structurePlacementType;
        this.placementCheckWidth = placementCheckWidth;
        this.placementCheckHeight = placementCheckHeight;
        this.placementRequired = placementRequired;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_2919 chunkRandom = context.comp_566();
        int x = context.comp_568().method_8326() + chunkRandom.method_43048(16);
        int z = context.comp_568().method_8328() + chunkRandom.method_43048(16);
        class_5868 heightContext = new class_5868(context.comp_562(), context.comp_569());
        int y = this.startHeight.method_35391((class_5819)chunkRandom, heightContext);
        class_2794 chunkGenerator = context.comp_562();
        class_5539 world = context.comp_569();
        class_7138 noiseConfig = context.comp_564();
        class_3341 structureBox = class_3341.method_34390((class_2382)new class_2338(x - this.placementCheckWidth / 2, y, z - this.placementCheckWidth / 2), (class_2382)new class_2338(x + this.placementCheckWidth / 2, y + this.placementCheckHeight, z + this.placementCheckWidth / 2));
        Optional<Integer> floorHeight = UndergroundJigsawStructure.getFloorHeight((class_5819)chunkRandom, chunkGenerator, this.structurePlacementType, y, this.placementCheckHeight, structureBox, world, noiseConfig);
        if (floorHeight.isPresent()) {
            y = floorHeight.get();
        } else if (!this.placementRequired) {
            return Optional.empty();
        }
        return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.size, (class_2338)new class_2338(x, y, z), (boolean)false, Optional.empty(), (int)this.maxDistanceFromCenter);
    }

    public class_7151<UndergroundJigsawStructure> method_41618() {
        return SpectrumStructureTypes.UNDERGROUND_JIGSAW;
    }

    private static Optional<Integer> getFloorHeight(class_5819 random, class_2794 chunkGenerator, StructurePlacementType structurePlacementType, int startHeight, int structureHeight, class_3341 box, class_5539 world, class_7138 noiseConfig) {
        int result;
        int y = startHeight;
        int lowestY = world.method_31607() + 15;
        class_4966 heightLimitView = chunkGenerator.method_26261(box.method_22874().method_10263(), box.method_22874().method_10260(), world, noiseConfig);
        while (true) {
            if (y < lowestY) {
                return Optional.empty();
            }
            if (!heightLimitView.method_32892(y).method_26207().method_15799()) break;
            --y;
        }
        ImmutableList boxCorners = ImmutableList.of((Object)new class_2338(box.method_35415(), 0, box.method_35417()), (Object)new class_2338(box.method_35418(), 0, box.method_35417()), (Object)new class_2338(box.method_35415(), 0, box.method_35420()), (Object)new class_2338(box.method_35418(), 0, box.method_35420()));
        List<class_4966> verticalBlockSamples = boxCorners.stream().map(blockPos -> chunkGenerator.method_26261(blockPos.method_10263(), blockPos.method_10260(), world, noiseConfig)).toList();
        class_2902.class_2903 type = structurePlacementType == StructurePlacementType.ON_GROUND_WATER ? class_2902.class_2903.field_13195 : class_2902.class_2903.field_13194;
        for (result = y; result > lowestY; --result) {
            int m = 0;
            for (class_4966 verticalBlockSample : verticalBlockSamples) {
                class_2680 blockState = verticalBlockSample.method_32892(result);
                if (!type.method_16402().test(blockState) || ++m != 3) continue;
                if (structurePlacementType == StructurePlacementType.PARTLY_BURIED) {
                    y = -class_3532.method_32751((class_5819)random, (int)(structureHeight / 8), (int)(structureHeight / 2));
                }
                return Optional.of(result);
            }
        }
        return Optional.of(result);
    }
}

