/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1322;
import net.spell_power.api.MagicSchool;
import net.spell_power.api.attributes.SpellAttributeEntry;
import net.spell_power.api.attributes.SpellAttributes;

public class ItemConfig {
    public Map<String, Weapon> weapons = new HashMap<String, Weapon>();
    public Map<String, ArmorSet> armor_sets = new HashMap<String, ArmorSet>();

    public static class ArmorSet {
        public float armor_toughness = 0.0f;
        public float knockback_resistance = 0.0f;
        public Piece head = new Piece();
        public Piece chest = new Piece();
        public Piece legs = new Piece();
        public Piece feet = new Piece();

        public static ArmorSet with(Piece head, Piece chest, Piece legs, Piece feet) {
            ArmorSet set = new ArmorSet();
            set.head = head;
            set.chest = chest;
            set.legs = legs;
            set.feet = feet;
            return set;
        }

        public static class Piece {
            public int armor = 0;
            public ArrayList<SpellAttribute> spell_attributes = new ArrayList();

            public Piece() {
            }

            public Piece(int armor) {
                this.armor = armor;
            }

            public Piece add(SpellAttribute attribute) {
                this.spell_attributes.add(attribute);
                return this;
            }

            public Piece addAll(List<SpellAttribute> attributes) {
                this.spell_attributes.addAll(attributes);
                return this;
            }
        }
    }

    public static class Weapon {
        public float attack_damage = 0.0f;
        public float attack_speed = 0.0f;
        public ArrayList<SpellAttribute> spell_attributes = new ArrayList();

        public Weapon() {
        }

        public Weapon(float attack_damage, float attack_speed) {
            this.attack_damage = attack_damage;
            this.attack_speed = attack_speed;
        }

        public Weapon add(SpellAttribute attribute) {
            this.spell_attributes.add(attribute);
            return this;
        }
    }

    public static class SpellAttribute {
        public String name;
        public float value;
        public class_1322.class_1323 operation;

        public SpellAttribute() {
        }

        public SpellAttribute(String name, float value, class_1322.class_1323 operation) {
            this.name = name;
            this.value = value;
            this.operation = operation;
        }

        public static SpellAttribute bonus(SpellAttributeEntry attribute, float value) {
            return new SpellAttribute(attribute.name, value, class_1322.class_1323.field_6328);
        }

        public static SpellAttribute multiply(SpellAttributeEntry attribute, float value) {
            return new SpellAttribute(attribute.name, value, class_1322.class_1323.field_6330);
        }

        public static ArrayList<SpellAttribute> bonuses(EnumSet<MagicSchool> attributes, float value) {
            List<SpellAttributeEntry> list = attributes.stream().map(school -> (SpellAttributeEntry)SpellAttributes.POWER.get(school)).toList();
            return SpellAttribute.bonuses(list, value);
        }

        public static ArrayList<SpellAttribute> bonuses(List<SpellAttributeEntry> attributes, float value) {
            ArrayList<SpellAttribute> spellAttributes = new ArrayList<SpellAttribute>();
            for (SpellAttributeEntry attribute : attributes) {
                spellAttributes.add(new SpellAttribute(attribute.name, value, class_1322.class_1323.field_6328));
            }
            return spellAttributes;
        }
    }
}

