/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3528;
import net.minecraft.class_5134;
import net.spell_engine.Platform;
import net.spell_engine.api.item.ConfigurableAttributes;
import net.spell_engine.api.item.ItemConfig;
import net.spell_power.api.attributes.CustomEntityAttribute;
import net.spell_power.api.attributes.SpellAttributeEntry;
import net.spell_power.api.attributes.SpellAttributes;
import org.jetbrains.annotations.Nullable;

public class Weapon {
    public static void register(Map<String, ItemConfig.Weapon> configs, List<Entry> entries) {
        for (Entry entry : entries) {
            ItemConfig.Weapon config = configs.get(entry.name);
            if (config == null) {
                config = entry.defaults;
                configs.put(entry.name(), config);
            }
            if (!entry.isRequiredModInstalled()) continue;
            class_1792 item = entry.item();
            ((ConfigurableAttributes)item).setAttributes(Weapon.attributesFrom(config));
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)entry.id(), (Object)item);
        }
    }

    private static Multimap<class_1320, class_1322> attributesFrom(ItemConfig.Weapon config) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(ItemAccessor.ATTACK_DAMAGE_MODIFIER_ID(), "Weapon modifier", (double)config.attack_damage, class_1322.class_1323.field_6328));
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(ItemAccessor.ATTACK_SPEED_MODIFIER_ID(), "Weapon modifier", (double)config.attack_speed, class_1322.class_1323.field_6328));
        for (ItemConfig.SpellAttribute attribute : config.spell_attributes) {
            if (attribute.value == 0.0f) continue;
            try {
                CustomEntityAttribute entityAttribute = ((SpellAttributeEntry)SpellAttributes.all.get((Object)attribute.name)).attribute;
                builder.put((Object)entityAttribute, (Object)new class_1322(entityAttribute.weaponUUID, "Weapon modifier", (double)attribute.value, attribute.operation));
            }
            catch (Exception e) {
                System.err.println("Failed to add item attribute modifier: " + e.getMessage());
            }
        }
        return builder.build();
    }

    public static final class Entry {
        private final String namespace;
        private final String name;
        private final CustomMaterial material;
        private final class_1792 item;
        private final ItemConfig.Weapon defaults;
        @Nullable
        private String requiredMod;

        public Entry(String namespace, String name, CustomMaterial material, class_1792 item, ItemConfig.Weapon defaults, @Nullable String requiredMod) {
            this.namespace = namespace;
            this.name = name;
            this.material = material;
            this.item = item;
            this.defaults = defaults;
            this.requiredMod = requiredMod;
        }

        public class_2960 id() {
            return new class_2960(this.namespace, this.name);
        }

        public Entry attribute(ItemConfig.SpellAttribute attribute) {
            this.defaults.add(attribute);
            return this;
        }

        public Entry requires(String modName) {
            this.requiredMod = modName;
            return this;
        }

        public boolean isRequiredModInstalled() {
            if (this.requiredMod == null || this.requiredMod.isEmpty()) {
                return true;
            }
            return Platform.isModLoaded(this.requiredMod);
        }

        public String name() {
            return this.name;
        }

        public CustomMaterial material() {
            return this.material;
        }

        public class_1792 item() {
            return this.item;
        }

        public ItemConfig.Weapon defaults() {
            return this.defaults;
        }

        @Nullable
        public String requiredMod() {
            return this.requiredMod;
        }
    }

    private static abstract class ItemAccessor
    extends class_1792 {
        public ItemAccessor(class_1792.class_1793 settings) {
            super(settings);
        }

        public static UUID ATTACK_DAMAGE_MODIFIER_ID() {
            return field_8006;
        }

        public static UUID ATTACK_SPEED_MODIFIER_ID() {
            return field_8001;
        }
    }

    public static class CustomMaterial
    implements class_1832 {
        private int miningLevel = 0;
        private int durability = 0;
        private float miningSpeed = 0.0f;
        private int enchantability = 0;
        private class_3528<class_1856> ingredient = null;

        public static CustomMaterial matching(class_1834 vanillaMaterial, Supplier<class_1856> repairIngredient) {
            CustomMaterial material = new CustomMaterial();
            material.miningLevel = vanillaMaterial.method_8024();
            material.durability = vanillaMaterial.method_8025();
            material.miningSpeed = vanillaMaterial.method_8027();
            material.enchantability = vanillaMaterial.method_8026();
            material.ingredient = new class_3528(repairIngredient);
            return material;
        }

        public int method_8025() {
            return this.durability;
        }

        public float method_8027() {
            return this.miningSpeed;
        }

        public float method_8028() {
            return 0.0f;
        }

        public int method_8024() {
            return this.miningLevel;
        }

        public int method_8026() {
            return this.enchantability;
        }

        public class_1856 method_8023() {
            return (class_1856)this.ingredient.method_15332();
        }
    }
}

