/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell;

import java.util.Objects;
import java.util.Random;

public final class Sound {
    private String id = null;
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private float randomness = 0.1f;
    private static Random rng = new Random();

    public Sound() {
    }

    public Sound(String id) {
        this.id = id;
    }

    public String id() {
        return this.id;
    }

    public float volume() {
        return this.volume;
    }

    public float pitch() {
        return this.pitch;
    }

    public float randomness() {
        return this.randomness;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Sound that = (Sound)obj;
        return Objects.equals(this.id, that.id) && Float.floatToIntBits(this.volume) == Float.floatToIntBits(that.volume) && Float.floatToIntBits(this.pitch) == Float.floatToIntBits(that.pitch) && Float.floatToIntBits(this.randomness) == Float.floatToIntBits(that.randomness);
    }

    public int hashCode() {
        return Objects.hash(this.id, Float.valueOf(this.volume), Float.valueOf(this.pitch), Float.valueOf(this.randomness));
    }

    public String toString() {
        return "SoundV2[id=" + this.id + ", volume=" + this.volume + ", pitch=" + this.pitch + ", randomness=" + this.randomness + "]";
    }

    public float randomizedPitch() {
        float pitch = this.randomness() > 0.0f ? rng.nextFloat(this.pitch() - this.randomness(), this.pitch() + this.randomness()) : this.pitch();
        return pitch;
    }
}

