/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell;

import net.spell_engine.api.spell.ParticleBatch;
import net.spell_engine.api.spell.Sound;
import net.spell_power.api.MagicSchool;

public class Spell {
    public MagicSchool school;
    public float range = 50.0f;
    public Learn learn = new Learn();
    public Cast cast = new Cast();
    public Release release;
    public boolean allow_mixed_intents = false;
    public Impact[] impact;
    public Cost cost = new Cost();

    public static class Learn {
        public int tier = 1;
        public int level_cost_per_tier = 3;
        public int level_requirement_per_tier = 10;
    }

    public static class Cast {
        public float duration = 0.0f;
        public int channel_ticks = 0;
        public String animation;
        public Sound start_sound;
        public Sound sound;
        public ParticleBatch[] particles = new ParticleBatch[0];
    }

    public static class Cost {
        public float exhaust = 0.1f;
        public String item_id;
        public String effect_id;
        public int durability = 1;
        public float cooldown_duration = 0.0f;
        public boolean cooldown_proportional = false;
    }

    public static class ProjectileData {
        public float velocity = 1.0f;
        public float divergence = 0.0f;
        public boolean inherit_shooter_velocity = false;
        public float homing_angle = 1.0f;
        public Client client_data;

        public static class Client {
            public ParticleBatch[] travel_particles;
            public String model_id;
            public float scale = 1.0f;
            public float rotate_degrees_per_tick = 2.0f;
            public RenderMode render = RenderMode.FLAT;

            public Client() {
            }

            public Client(ParticleBatch[] travel_particles, String model_id) {
                this.travel_particles = travel_particles;
                this.model_id = model_id;
            }

            public static enum RenderMode {
                FLAT,
                DEEP;

            }
        }
    }

    public static class Impact {
        public Action action;
        public ParticleBatch[] particles = new ParticleBatch[0];
        public Sound sound;

        public static class Action {
            public Type type;
            public boolean apply_to_caster = false;
            public float min_power = 1.0f;
            public Damage damage;
            public Heal heal;
            public StatusEffect status_effect;
            public Fire fire;

            public static class Fire {
                public int duration = 2;
                public int tick_offset = 10;
            }

            public static class StatusEffect {
                public String effect_id;
                public float duration = 10.0f;
                public int amplifier = 0;
                public float amplifier_power_multiplier = 0.0f;
                public ApplyMode apply_mode = ApplyMode.SET;
                public ApplyLimit apply_limit;
                public boolean show_particles = true;

                public static enum ApplyMode {
                    SET,
                    ADD;

                }

                public static class ApplyLimit {
                    public float health_base = 0.0f;
                    public float spell_power_multiplier = 0.0f;
                }
            }

            public static class Heal {
                public float spell_power_coefficient = 1.0f;
            }

            public static class Damage {
                public float spell_power_coefficient = 1.0f;
                public float knockback = 1.0f;
            }

            public static enum Type {
                DAMAGE,
                HEAL,
                STATUS_EFFECT,
                FIRE;

            }
        }
    }

    public static class Release {
        public Target target;
        public boolean custom_impact = false;
        public String animation;
        public ParticleBatch[] particles;
        public Sound sound;

        public static class Target {
            public Type type;
            public Area area;
            public Beam beam;
            public Cursor cursor;
            public ProjectileData projectile;
            public Meteor meteor;

            public static class Meteor {
                public float launch_height = 10.0f;
                public float impact_range = 10.0f;
                public ParticleBatch[] impact_particles = new ParticleBatch[0];
                public Sound impact_sound;
            }

            public static class Cursor {
                public boolean use_caster_as_fallback = false;
            }

            public static class Beam {
                public String texture_id = "textures/entity/beacon_beam.png";
                public long color_rgba = -1L;
                public float width = 0.1f;
                public float flow = 1.0f;
                public ParticleBatch[] block_hit_particles = new ParticleBatch[0];
            }

            public static class Area {
                public DropoffCurve distance_dropoff = DropoffCurve.NONE;
                public float horizontal_range_multiplier = 1.0f;
                public float vertical_range_multiplier = 1.0f;
                public float angle_degrees = 0.0f;
                public boolean include_caster = false;

                public static enum DropoffCurve {
                    NONE,
                    SQUARED;

                }
            }

            public static enum Type {
                AREA,
                BEAM,
                CURSOR,
                PROJECTILE,
                METEOR,
                SELF;

            }
        }
    }
}

