/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.api.spell;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;

public class SpellContainer {
    public boolean is_proxy = false;
    public int max_spell_count = 0;
    public String pool;
    public List<String> spell_ids = List.of();

    public SpellContainer() {
    }

    public SpellContainer(boolean is_proxy, String pool, int max_spell_count, List<String> spell_ids) {
        this.is_proxy = is_proxy;
        this.pool = pool;
        this.max_spell_count = max_spell_count;
        this.spell_ids = spell_ids;
    }

    public int cappedIndex(int selected) {
        if (this.spell_ids.isEmpty()) {
            return 0;
        }
        int remainder = selected % this.spell_ids.size();
        return remainder >= 0 ? remainder : remainder + this.spell_ids.size();
    }

    public String spellId(int selected) {
        if (this.spell_ids == null || this.spell_ids.isEmpty()) {
            return null;
        }
        int index = this.cappedIndex(selected);
        return this.spell_ids.get(index);
    }

    public boolean isValid() {
        if (this.is_proxy) {
            return true;
        }
        if (this.max_spell_count < 0) {
            return false;
        }
        return !this.spell_ids.isEmpty() || this.pool != null && !this.pool.isEmpty();
    }

    public boolean isUsable() {
        return this.isValid() && !this.spell_ids.isEmpty();
    }

    public SpellContainer copy() {
        return new SpellContainer(this.is_proxy, this.pool, this.max_spell_count, new ArrayList<String>(this.spell_ids));
    }

    public record Hosted(class_1799 host, SpellContainer container) {
    }
}

