/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.HudElement;
import net.spell_engine.client.gui.HudMessages;
import net.spell_engine.client.input.InputHelper;
import net.spell_engine.client.util.Color;
import net.spell_engine.client.util.Rect;
import net.spell_engine.client.util.SpellRender;
import net.spell_engine.client.util.TextureFile;
import net.spell_engine.config.ClientConfig;
import net.spell_engine.config.HudConfig;
import net.spell_engine.internals.SpellCasterClient;
import net.spell_engine.internals.SpellCooldownManager;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;

public class HudRenderHelper {
    public static void render(class_4587 matrixStack, float tickDelta) {
        HudRenderHelper.render(matrixStack, tickDelta, false);
    }

    public static void render(class_4587 matrixStack, float tickDelta, boolean config) {
        HudConfig hudConfig = (HudConfig)SpellEngineClient.hudConfig.value;
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null && !config) {
            return;
        }
        ClientConfig clientConfig = SpellEngineClient.config;
        TargetWidget.ViewModel targetViewModel = TargetWidget.ViewModel.mock();
        boolean renderHotbar = true;
        SpellHotBarWidget.ViewModel hotbarViewModel = SpellHotBarWidget.ViewModel.mock();
        ErrorMessageWidget.ViewModel errorViewModel = ErrorMessageWidget.ViewModel.mock();
        SpellHotBarWidget.ViewModel hotbarAccessories = null;
        CastBarWidget.ViewModel castBarViewModel = null;
        if (config) {
            castBarViewModel = CastBarWidget.ViewModel.mock();
        } else {
            targetViewModel = TargetWidget.ViewModel.from(player);
        }
        if (player != null) {
            SpellCasterClient caster = (SpellCasterClient)player;
            SpellContainer container = caster.getCurrentContainer();
            Spell currentSpell = caster.getCurrentSpell();
            class_2960 currentSpellId = caster.getCurrentSpellId();
            if (container != null && container.isUsable()) {
                SpellCooldownManager cooldownManager = caster.getCooldownManager();
                List<SpellHotBarWidget.SpellViewModel> spells = container.spell_ids.stream().map(id -> {
                    class_2960 spellId = new class_2960(id);
                    Spell spell = SpellRegistry.getSpell(spellId);
                    return new SpellHotBarWidget.SpellViewModel(SpellRender.iconTexture(spellId), cooldownManager.getCooldownProgress(new class_2960(id), tickDelta), Color.from(spell != null ? spell.school.color() : 0xFFFFFF));
                }).collect(Collectors.toList());
                int selected = caster.getSelectedSpellIndex(container);
                if (clientConfig.collapseSpellHotbar && !InputHelper.isLocked && selected < spells.size()) {
                    hotbarAccessories = new SpellHotBarWidget.ViewModel(spells, selected, Color.from(0xFFFFFF));
                    spells = List.of(spells.get(selected));
                    selected = 0;
                }
                hotbarViewModel = new SpellHotBarWidget.ViewModel(spells, selected, Color.from(0xFFFFFF));
            } else {
                hotbarViewModel = SpellHotBarWidget.ViewModel.empty;
            }
            renderHotbar = InputHelper.hotbarVisibility().spell();
            if (currentSpell != null) {
                castBarViewModel = new CastBarWidget.ViewModel(currentSpell.school.color(), caster.getCurrentCastProgress(), currentSpell.cast.duration, SpellRender.iconTexture(currentSpellId), true, SpellHelper.isChanneled(currentSpell));
            }
            if (!config) {
                HudMessages hudMessages = HudMessages.INSTANCE;
                HudMessages.ErrorMessageState error = hudMessages.currentError();
                errorViewModel = error != null && error.durationLeft > 0 ? ErrorMessageWidget.ViewModel.from(error.message, error.durationLeft, error.fadeOut, tickDelta) : null;
            }
        }
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        class_241 originPoint = hudConfig.castbar.base.origin.getPoint(screenWidth, screenHeight);
        class_241 baseOffset = originPoint.method_35586(hudConfig.castbar.base.offset);
        if (castBarViewModel != null) {
            CastBarWidget.render(matrixStack, tickDelta, hudConfig, baseOffset, castBarViewModel);
        }
        if (hudConfig.castbar.target.visible) {
            class_241 targetOffset = baseOffset.method_35586(hudConfig.castbar.target.offset);
            TargetWidget.render(matrixStack, tickDelta, targetOffset, targetViewModel);
        }
        if (renderHotbar || config) {
            if (config && (hotbarViewModel == null || hotbarViewModel.isEmpty())) {
                hotbarViewModel = SpellHotBarWidget.ViewModel.mock();
            }
            SpellHotBarWidget.render(matrixStack, screenWidth, screenHeight, hotbarViewModel);
            if (clientConfig.collapsedIndicators && hotbarAccessories != null) {
                SpellHotBarWidget.renderAccessories(matrixStack, screenWidth, screenHeight, hotbarAccessories);
            }
        }
        if (errorViewModel != null) {
            ErrorMessageWidget.render(matrixStack, hudConfig, screenWidth, screenHeight, errorViewModel);
        }
    }

    public static class TargetWidget {
        public static void render(class_4587 matrixStack, float tickDelta, class_241 starting, ViewModel viewModel) {
            class_310 client = class_310.method_1551();
            class_327 textRenderer = client.field_1705.method_1756();
            int textWidth = textRenderer.method_1727(viewModel.text);
            int x = (int)(starting.field_1343 - (float)textWidth / 2.0f);
            int y = (int)starting.field_1342;
            int opacity = 255;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Objects.requireNonNull(textRenderer);
            class_329.method_25294((class_4587)matrixStack, (int)(x - 2), (int)(y - 2), (int)(x + textWidth + 2), (int)(y + 9 + 2), (int)client.field_1690.method_19344(0));
            textRenderer.method_1720(matrixStack, viewModel.text, (float)x, (float)y, 0xFFFFFF);
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public record ViewModel(String text) {
            public static ViewModel mock() {
                return new ViewModel("Target name");
            }

            public static ViewModel from(class_746 player) {
                SpellCasterClient caster = (SpellCasterClient)player;
                class_1297 target = caster.getCurrentFirstTarget();
                String text = "";
                if (target != null && caster.getCurrentTargets().size() == 1) {
                    text = target.method_5477().getString();
                }
                return new ViewModel(text);
            }
        }
    }

    public class SpellHotBarWidget {
        public static Rect lastRendered;
        private static final TextureFile WIDGETS;
        private static final TextureFile ACCESSORIES;
        private static final int slotHeight = 22;
        private static final int slotWidth = 20;

        public static void render(class_4587 matrixStack, int screenWidth, int screenHeight, ViewModel viewModel) {
            HudElement config = ((HudConfig)SpellEngineClient.hudConfig.value).hotbar;
            if (viewModel.spells.isEmpty()) {
                return;
            }
            float estimatedWidth = 20 * viewModel.spells.size();
            float estimatedHeight = 22.0f;
            class_241 origin = config.origin.getPoint(screenWidth, screenHeight).method_35586(config.offset).method_35586(new class_241(estimatedWidth * -0.5f, estimatedHeight * -0.5f));
            lastRendered = new Rect(origin, origin.method_35586(new class_241(estimatedWidth, estimatedHeight)));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float barOpacity = SpellEngineClient.config.indicateActiveHotbar && InputHelper.isLocked ? 1.0f : 0.5f;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)barOpacity);
            RenderSystem.setShaderTexture((int)0, (class_2960)WIDGETS.id());
            class_332.method_25290((class_4587)matrixStack, (int)((int)origin.field_1343), (int)((int)origin.field_1342), (float)0.0f, (float)0.0f, (int)10, (int)22, (int)WIDGETS.width(), (int)WIDGETS.height());
            int middleElements = viewModel.spells.size() - 1;
            for (int i = 0; i < middleElements; ++i) {
                class_332.method_25290((class_4587)matrixStack, (int)((int)origin.field_1343 + 10 + i * 20), (int)((int)origin.field_1342), (float)10.0f, (float)0.0f, (int)20, (int)22, (int)WIDGETS.width(), (int)WIDGETS.height());
            }
            class_332.method_25290((class_4587)matrixStack, (int)((int)origin.field_1343 + 10 + middleElements * 20), (int)((int)origin.field_1342), (float)170.0f, (float)0.0f, (int)12, (int)22, (int)WIDGETS.width(), (int)WIDGETS.height());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_241 iconsOffset = new class_241(3.0f, 3.0f);
            int iconSize = 16;
            for (int i = 0; i < viewModel.spells.size(); ++i) {
                SpellViewModel spell = viewModel.spells.get(i);
                RenderSystem.setShaderTexture((int)0, (class_2960)spell.iconId);
                int x = (int)(origin.field_1343 + iconsOffset.field_1343) + 20 * i;
                int y = (int)(origin.field_1342 + iconsOffset.field_1342);
                class_332.method_25290((class_4587)matrixStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)iconSize, (int)iconSize, (int)iconSize, (int)iconSize);
                if (!(spell.cooldown > 0.0f)) continue;
                SpellHotBarWidget.renderCooldown(spell.cooldown, x, y);
            }
            if (viewModel.spells.size() > 1) {
                int selectorSize = 24;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)barOpacity);
                RenderSystem.setShaderTexture((int)0, (class_2960)WIDGETS.id());
                int x = (int)origin.field_1343 - 1 + 20 * viewModel.selected;
                int y = (int)origin.field_1342 - 1;
                class_332.method_25290((class_4587)matrixStack, (int)x, (int)y, (float)0.0f, (float)22.0f, (int)selectorSize, (int)selectorSize, (int)WIDGETS.width(), (int)WIDGETS.height());
            }
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public static void renderAccessories(class_4587 matrixStack, int screenWidth, int screenHeight, ViewModel viewModel) {
            if (viewModel.spells.size() < 2) {
                return;
            }
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            HudElement config = ((HudConfig)SpellEngineClient.hudConfig.value).hotbar;
            class_241 origin = config.origin.getPoint(screenWidth, screenHeight).method_35586(config.offset);
            float barOpacity = SpellEngineClient.config.indicateActiveHotbar && InputHelper.isLocked ? 1.0f : 0.5f;
            RenderSystem.setShaderTexture((int)0, (class_2960)ACCESSORIES.id());
            int spacing = 7;
            for (int i = 0; i < viewModel.spells.size(); ++i) {
                if (i == viewModel.selected) continue;
                SpellViewModel spell = viewModel.spells.get(i);
                int position = i - viewModel.selected;
                int x = (int)origin.field_1343 + (i < viewModel.selected ? -1 : 1) * 8 - 7 + position * spacing;
                int y = (int)origin.field_1342 - 8;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)barOpacity);
                class_332.method_25290((class_4587)matrixStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)ACCESSORIES.width(), (int)ACCESSORIES.height());
                RenderSystem.setShaderColor((float)spell.color().red(), (float)spell.color().green(), (float)spell.color().blue(), (float)1.0f);
                class_332.method_25290((class_4587)matrixStack, (int)x, (int)y, (float)16.0f, (float)0.0f, (int)16, (int)16, (int)ACCESSORIES.width(), (int)ACCESSORIES.height());
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }

        private static void renderCooldown(float progress, int x, int y) {
            RenderSystem.disableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_289 tessellator2 = class_289.method_1348();
            class_287 bufferBuilder2 = tessellator2.method_1349();
            SpellHotBarWidget.renderGuiQuad(bufferBuilder2, x, y + class_3532.method_15375((float)(16.0f * (1.0f - progress))), 16, class_3532.method_15386((float)(16.0f * progress)), 255, 255, 255, 127);
            RenderSystem.enableTexture();
            RenderSystem.enableDepthTest();
        }

        private static void renderGuiQuad(class_287 buffer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
            RenderSystem.setShader(class_757::method_34540);
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            buffer.method_22912((double)(x + 0), (double)(y + 0), 0.0).method_1336(red, green, blue, alpha).method_1344();
            buffer.method_22912((double)(x + 0), (double)(y + height), 0.0).method_1336(red, green, blue, alpha).method_1344();
            buffer.method_22912((double)(x + width), (double)(y + height), 0.0).method_1336(red, green, blue, alpha).method_1344();
            buffer.method_22912((double)(x + width), (double)(y + 0), 0.0).method_1336(red, green, blue, alpha).method_1344();
            class_286.method_43433((class_287.class_7433)buffer.method_1326());
        }

        static {
            WIDGETS = new TextureFile(new class_2960("textures/gui/widgets.png"), 256, 256);
            ACCESSORIES = new TextureFile(new class_2960("spell_engine", "textures/hud/hotbar_accessories.png"), 32, 16);
        }

        public record ViewModel(List<SpellViewModel> spells, int selected, Color sliderColor) {
            public static final ViewModel empty = new ViewModel(List.of(), 0, Color.from(0xFFFFFF));

            public static ViewModel mock() {
                return new ViewModel(List.of(new SpellViewModel(SpellRender.iconTexture(new class_2960("spell_engine", "dummy_spell")), 0.0f, Color.RED), new SpellViewModel(SpellRender.iconTexture(new class_2960("spell_engine", "dummy_spell")), 0.0f, Color.RED), new SpellViewModel(SpellRender.iconTexture(new class_2960("spell_engine", "dummy_spell")), 0.0f, Color.RED)), 1, Color.from(0xFFFFFF));
            }

            public boolean isEmpty() {
                return this.spells.isEmpty();
            }
        }

        public record SpellViewModel(class_2960 iconId, float cooldown, Color color) {
        }
    }

    public static class ErrorMessageWidget {
        public static Rect lastRendered;

        public static void render(class_4587 matrixStack, HudConfig hudConfig, int screenWidth, int screenHeight, ViewModel viewModel) {
            int alpha = (int)(viewModel.opacity * 255.0f);
            if (alpha < 10) {
                return;
            }
            class_310 client = class_310.method_1551();
            class_327 textRenderer = client.field_1705.method_1756();
            int textWidth = textRenderer.method_27525((class_5348)viewModel.message);
            Objects.requireNonNull(textRenderer);
            int textHeight = 9;
            HudElement config = hudConfig.error_message;
            class_241 origin = config.origin.getPoint(screenWidth, screenHeight).method_35586(config.offset);
            int x = (int)(origin.field_1343 - (float)textWidth / 2.0f);
            int y = (int)origin.field_1342;
            lastRendered = new Rect(new class_241((float)x, (float)y), new class_241((float)(x + textWidth), (float)(y + textHeight)));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Objects.requireNonNull(textRenderer);
            class_329.method_25294((class_4587)matrixStack, (int)(x - 2), (int)(y - 2), (int)(x + textWidth + 2), (int)(y + 9 + 2), (int)client.field_1690.method_19344(0));
            textRenderer.method_30881(matrixStack, viewModel.message(), (float)x, (float)y, 0xFFFFFF + (alpha << 24));
            RenderSystem.disableBlend();
        }

        public record ViewModel(class_2561 message, float opacity) {
            public static ViewModel mock() {
                return new ViewModel((class_2561)class_2561.method_43470((String)"Error Message!").method_27692(class_124.field_1061), 1.0f);
            }

            public static ViewModel from(class_2561 message, int durationLeft, int fadeOut, float tickDelta) {
                float tick = (float)durationLeft - tickDelta;
                float opacity = tick > (float)fadeOut ? 1.0f : tick / (float)fadeOut;
                return new ViewModel(message, opacity);
            }
        }
    }

    public static class CastBarWidget {
        public static Rect lastRendered;
        private static final float tailWidth = 5.0f;
        public static final float minWidth = 10.0f;
        private static final int textureWidth = 182;
        private static final int textureHeight = 10;
        private static final int barHeight = 5;
        private static final class_2960 CAST_BAR;
        private static final int spellIconSize = 16;

        public static void render(class_4587 matrixStack, float tickDelta, HudConfig hudConfig, class_241 starting, ViewModel viewModel) {
            int barWidth = hudConfig.castbar.width;
            float totalWidth = (float)barWidth + 10.0f;
            int totalHeight = 5;
            int x = (int)(starting.field_1343 - totalWidth / 2.0f);
            int y = (int)(starting.field_1342 - (float)(totalHeight / 2));
            lastRendered = new Rect(new class_241((float)x, (float)y), new class_241((float)x + totalWidth, (float)(y + totalHeight)));
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (class_2960)CAST_BAR);
            float red = (float)(viewModel.color >> 16 & 0xFF) / 255.0f;
            float green = (float)(viewModel.color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(viewModel.color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
            CastBarWidget.renderBar(matrixStack, barWidth, true, 1.0f, x, y);
            float partialProgress = 0.0f;
            if (viewModel.allowTickDelta && viewModel.castDuration > 0.0f) {
                partialProgress = tickDelta / (viewModel.castDuration * 20.0f);
            }
            float progress = viewModel.reverse() ? 1.0f - viewModel.progress - partialProgress : viewModel.progress + partialProgress;
            CastBarWidget.renderBar(matrixStack, barWidth, false, progress, x, y);
            if (hudConfig.castbar.icon.visible && viewModel.iconTexture != null) {
                x = (int)(starting.field_1343 + hudConfig.castbar.icon.offset.field_1343);
                y = (int)(starting.field_1342 + hudConfig.castbar.icon.offset.field_1342);
                RenderSystem.setShaderTexture((int)0, (class_2960)viewModel.iconTexture);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                class_332.method_25290((class_4587)matrixStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        private static void renderBar(class_4587 matrixStack, int barWidth, boolean isBackground, float progress, int x, int y) {
            float totalWidth = (float)barWidth + 10.0f;
            float centerWidth = totalWidth - 10.0f;
            float leftRenderBegin = 0.0f;
            float centerRenderBegin = 5.0f;
            float rightRenderBegin = totalWidth - 5.0f;
            CastBarWidget.renderBarPart(matrixStack, isBackground, PART.LEFT, progress, leftRenderBegin, 5.0f, x, y, totalWidth);
            CastBarWidget.renderBarPart(matrixStack, isBackground, PART.CENTER, progress, centerRenderBegin, centerRenderBegin + centerWidth, x, y, totalWidth);
            CastBarWidget.renderBarPart(matrixStack, isBackground, PART.RIGHT, progress, rightRenderBegin, totalWidth, x, y, totalWidth);
        }

        private static void renderBarPart(class_4587 matrixStack, boolean isBackground, PART part, float progress, float renderBegin, float renderEnd, int x, int y, float totalWidth) {
            int u = 0;
            float partMaxWidth = renderEnd - renderBegin;
            float progressRange = (renderEnd - renderBegin) / totalWidth;
            float progressFloor = renderBegin / totalWidth;
            float adjustedProgress = Math.min(Math.max(progress - progressFloor, 0.0f), progressRange) / progressRange;
            int width = Math.round(adjustedProgress * partMaxWidth);
            switch (part) {
                case LEFT: {
                    u = 0;
                    break;
                }
                case CENTER: {
                    u = 5;
                    break;
                }
                case RIGHT: {
                    u = 177;
                }
            }
            int v = isBackground ? 0 : 5;
            class_332.method_25290((class_4587)matrixStack, (int)((int)((float)x + renderBegin)), (int)y, (float)u, (float)v, (int)width, (int)5, (int)182, (int)10);
        }

        static {
            CAST_BAR = new class_2960("spell_engine", "textures/hud/castbar.png");
        }

        public record ViewModel(int color, float progress, float castDuration, class_2960 iconTexture, boolean allowTickDelta, boolean reverse) {
            public static ViewModel mock() {
                return new ViewModel(0xFF3300, 0.5f, 1.0f, SpellRender.iconTexture(new class_2960("spell_engine", "dummy_spell")), false, false);
            }
        }

        static enum PART {
            LEFT,
            CENTER,
            RIGHT;

        }
    }
}

