/*
 * Decompiled with CFR 0.152.
 */
package net.spell_engine.client.input;

import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.spell_engine.api.item.trinket.SpellBookItem;
import net.spell_engine.api.spell.SpellContainer;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.input.Keybindings;
import net.spell_engine.config.ClientConfig;
import net.spell_engine.internals.SpellCasterClient;

public class InputHelper {
    public static boolean isLocked = false;

    public static boolean shouldControlSpellHotbar() {
        return isLocked || Keybindings.hotbarModifier.method_1434();
    }

    public static boolean isLockAssigned() {
        return !Keybindings.hotbarLock.method_1415();
    }

    public static void toggleLock() {
        InputHelper.toggleLock(false);
    }

    public static void toggleLock(boolean skipValidation) {
        class_310 client = class_310.method_1551();
        if (isLocked) {
            isLocked = false;
        } else if (skipValidation || InputHelper.hasLockableSpellContainer((class_1657)client.field_1724)) {
            isLocked = true;
        }
    }

    public static boolean hasLockableSpellContainer(class_1657 player) {
        if (player != null) {
            SpellContainer.Hosted result = ((SpellCasterClient)player).getCurrentContainerWithHost();
            if (result.host().method_7909() instanceof SpellBookItem) {
                return false;
            }
            return InputHelper.canLockOnContainer(result.container());
        }
        return false;
    }

    public static boolean canLockOnContainer(SpellContainer container) {
        return container != null && container.isUsable() && container.spell_ids.size() > 1;
    }

    public static void showLockedMessage(String key) {
        class_310 client = class_310.method_1551();
        class_5250 component = class_2561.method_43469((String)"hud.leave_spell_hotbar", (Object[])new Object[]{key});
        client.field_1705.method_1758((class_2561)component, false);
    }

    public static HotbarVisibility hotbarVisibility() {
        ClientConfig config = SpellEngineClient.config;
        boolean item = true;
        boolean spell = true;
        if (config.showFocusedHotbarOnly) {
            spell = isLocked;
            item = !spell;
        }
        return new HotbarVisibility(item, spell);
    }

    public record HotbarVisibility(boolean item, boolean spell) {
    }
}

